/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.cdi.util.weft.config;

import java.util.HashMap;
import java.util.Map;
import org.commonjava.cdi.util.weft.config.WeftConfig;

public class DefaultWeftConfig
implements WeftConfig {
    public static final String THREADS_SUFFIX = "t";
    public static final String PRIORITY_SUFFIX = "p";
    private static final int DEFAULT_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private static final int DEFAULT_PRIORITY = 8;
    private boolean enabled = true;
    private final Map<String, Boolean> enabledPools = new HashMap<String, Boolean>();
    private final Map<String, Integer> config = new HashMap<String, Integer>();
    private int defaultThreads = DEFAULT_THREADS;
    private int defaultPriority = 8;

    public DefaultWeftConfig() {
    }

    public DefaultWeftConfig(Map<String, Integer> config) {
        this.config.putAll(config);
    }

    public DefaultWeftConfig(DefaultWeftConfig config) {
        this.config.putAll(config.config);
    }

    public DefaultWeftConfig configureDefaultThreads(int defaultThreads) {
        this.defaultThreads = defaultThreads;
        return this;
    }

    public DefaultWeftConfig configureDefaultPriority(int defaultPriority) {
        this.defaultPriority = defaultPriority;
        return this;
    }

    public DefaultWeftConfig configurePool(String name, int threads, int priority) {
        this.config.put(name + THREADS_SUFFIX, threads);
        this.config.put(name + PRIORITY_SUFFIX, priority);
        return this;
    }

    public DefaultWeftConfig configureThreads(String name, int threads) {
        this.config.put(name + THREADS_SUFFIX, threads);
        return this;
    }

    public DefaultWeftConfig configurePriority(String name, int priority) {
        this.config.put(name + PRIORITY_SUFFIX, priority);
        return this;
    }

    public DefaultWeftConfig configureEnabled(String name, boolean enabled) {
        this.enabledPools.put(name, enabled);
        return this;
    }

    public DefaultWeftConfig configureEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isEnabled(String name) {
        if (!this.isEnabled()) {
            return false;
        }
        Boolean result = this.enabledPools.get(name);
        return result == null ? this.isEnabled() : result.booleanValue();
    }

    @Override
    public int getDefaultThreads() {
        return this.defaultThreads;
    }

    @Override
    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    @Override
    public int getThreads(String poolName) {
        return this.getWithDefaultAndFailover(poolName, THREADS_SUFFIX, null, this.getDefaultThreads());
    }

    @Override
    public int getThreads(String poolName, Integer defaultValue) {
        return this.getWithDefaultAndFailover(poolName, THREADS_SUFFIX, defaultValue, this.getDefaultThreads());
    }

    @Override
    public int getPriority(String poolName) {
        return this.getWithDefaultAndFailover(poolName, PRIORITY_SUFFIX, null, this.getDefaultPriority());
    }

    @Override
    public int getPriority(String poolName, Integer defaultValue) {
        return this.getWithDefaultAndFailover(poolName, PRIORITY_SUFFIX, defaultValue, this.getDefaultPriority());
    }

    private int getWithDefaultAndFailover(String poolName, String suffix, Integer defaultValue, int failover) {
        Integer v = this.config.get(poolName + suffix);
        if (v == null) {
            return defaultValue == null ? failover : defaultValue;
        }
        return v;
    }
}

