/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io.resolver;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.io.resolver.GalleyInfrastructure;
import org.commonjava.maven.ext.io.resolver.MavenLocationExpander;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.DocRef;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.MavenXmlView;
import org.commonjava.maven.galley.maven.model.view.meta.MavenMetadataView;
import org.commonjava.maven.galley.maven.parse.GalleyMavenXMLException;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Named
@Singleton
public class GalleyAPIWrapper {
    private static final List<Location> MAVEN_REPOS = new ArrayList<Location>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(MavenLocationExpander.EXPANSION_TARGET);
        }
    };
    private GalleyInfrastructure infra;

    @Inject
    public GalleyAPIWrapper(@Named(value="galley") GalleyInfrastructure infra) {
        this.infra = infra;
    }

    public Document parseXml(String xml) throws GalleyMavenXMLException {
        return this.infra.getXml().parseDocument(xml, new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    public MavenXmlView<ProjectRef> parseXmlView(String xml) throws GalleyMavenXMLException {
        Document document = this.infra.getXml().parseDocument(xml, new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        DocRef<SimpleProjectRef> ref = new DocRef<SimpleProjectRef>(new SimpleProjectRef("unknown", "unknown"), xml, document);
        return new MavenXmlView<ProjectRef>(Collections.singletonList(ref), this.infra.getXPath(), this.infra.getXml(), new String[0]);
    }

    public MavenPomView readPomView(ProjectVersionRef ref) throws GalleyMavenException {
        return this.infra.getPomReader().read(ref, MAVEN_REPOS, new String[0]);
    }

    public MavenMetadataView readMetadataView(ProjectRef ref) throws GalleyMavenException {
        return this.infra.getMetadataReader().getMetadata(ref, MAVEN_REPOS);
    }

    public Transfer resolveArtifact(ArtifactRef asPomArtifact) throws TransferException {
        return this.infra.getArtifactManager().retrieveFirst(MAVEN_REPOS, asPomArtifact);
    }

    public String toXML(Node config, boolean includeXmlDeclaration) {
        return this.infra.getXml().toXML(config, includeXmlDeclaration);
    }
}

