/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.commonjava.cdi.util.weft.NamedThreadFactory;
import org.commonjava.maven.galley.GalleyCore;
import org.commonjava.maven.galley.GalleyInitException;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.auth.MemoryPasswordManager;
import org.commonjava.maven.galley.cache.CacheProviderFactory;
import org.commonjava.maven.galley.config.TransportManagerConfig;
import org.commonjava.maven.galley.event.NoOpFileEventManager;
import org.commonjava.maven.galley.internal.TransferManagerImpl;
import org.commonjava.maven.galley.internal.xfer.DownloadHandler;
import org.commonjava.maven.galley.internal.xfer.ExistenceHandler;
import org.commonjava.maven.galley.internal.xfer.ListingHandler;
import org.commonjava.maven.galley.internal.xfer.UploadHandler;
import org.commonjava.maven.galley.io.HashedLocationPathGenerator;
import org.commonjava.maven.galley.io.NoOpTransferDecorator;
import org.commonjava.maven.galley.io.SpecialPathManagerImpl;
import org.commonjava.maven.galley.nfc.MemoryNotFoundCache;
import org.commonjava.maven.galley.spi.auth.PasswordManager;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.io.PathGenerator;
import org.commonjava.maven.galley.spi.io.SpecialPathManager;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.commonjava.maven.galley.spi.transport.LocationResolver;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.spi.transport.TransportManager;
import org.commonjava.maven.galley.transport.NoOpLocationExpander;
import org.commonjava.maven.galley.transport.SimpleUrlLocationResolver;
import org.commonjava.maven.galley.transport.TransportManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalleyCoreBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LocationExpander locationExpander;
    private LocationResolver locationResolver;
    private TransferDecorator decorator;
    private FileEventManager events;
    private CacheProvider cache;
    private NotFoundCache nfc;
    private TransportManagerConfig transportManagerConfig;
    private TransportManager transportManager;
    private TransferManager transferManager;
    private List<Transport> transports;
    private SpecialPathManager specialPathManager;
    private ExecutorService handlerExecutor;
    private ExecutorService batchExecutor;
    private PasswordManager passwordManager;
    private PathGenerator pathGenerator;
    private CacheProviderFactory cacheProviderFactory;

    public GalleyCoreBuilder() {
    }

    public GalleyCoreBuilder(CacheProviderFactory cacheProviderFactory) {
        this.cacheProviderFactory = cacheProviderFactory;
    }

    public GalleyCore build() throws GalleyInitException {
        this.initMissingComponents();
        if (this.cache == null) {
            throw new GalleyInitException("No CacheProvider or cache directory supplied before calling initMissingComponents()!", new Object[0]);
        }
        return new GalleyCore(this.locationExpander, this.locationResolver, this.decorator, this.events, this.cache, this.nfc, this.transportManager, this.transferManager, this.transports, this.handlerExecutor, this.batchExecutor, this.passwordManager);
    }

    public void initMissingComponents() throws GalleyInitException {
        if (this.transportManager == null) {
            this.transportManager = new TransportManagerImpl(this.transports);
        }
        this.handlerExecutor = Executors.newFixedThreadPool(2, new NamedThreadFactory("transfer-handlers", true, 4));
        this.batchExecutor = Executors.newFixedThreadPool(2, new NamedThreadFactory("transfer-batches", true, 4));
        if (this.decorator == null) {
            this.decorator = new NoOpTransferDecorator();
        }
        if (this.events == null) {
            this.events = new NoOpFileEventManager();
        }
        if (this.nfc == null) {
            this.nfc = new MemoryNotFoundCache();
        }
        if (this.transportManagerConfig == null) {
            this.transportManagerConfig = new TransportManagerConfig();
        }
        DownloadHandler dh = new DownloadHandler(this.getNfc(), this.transportManagerConfig, this.handlerExecutor);
        UploadHandler uh = new UploadHandler(this.getNfc(), this.transportManagerConfig, this.handlerExecutor);
        ListingHandler lh = new ListingHandler(this.getNfc());
        ExistenceHandler eh = new ExistenceHandler(this.getNfc());
        if (this.specialPathManager == null) {
            this.specialPathManager = new SpecialPathManagerImpl();
        }
        if (this.pathGenerator == null) {
            this.pathGenerator = new HashedLocationPathGenerator();
        }
        if (this.cache == null) {
            if (this.cacheProviderFactory != null) {
                this.cache = this.cacheProviderFactory.create(this.pathGenerator, this.decorator, this.events);
            } else {
                throw new GalleyInitException("No CacheProvider / CacheProviderFactory specified!", new Object[0]);
            }
        }
        if (this.transferManager == null) {
            this.transferManager = new TransferManagerImpl(this.transportManager, this.getCache(), this.getNfc(), this.getFileEvents(), dh, uh, lh, eh, this.specialPathManager, this.batchExecutor);
        }
        if (this.locationExpander == null) {
            this.logger.debug("Initializing default location expander");
            this.locationExpander = new NoOpLocationExpander();
        }
        if (this.locationResolver == null) {
            this.locationResolver = new SimpleUrlLocationResolver(this.locationExpander, this.transportManager);
        }
        if (this.passwordManager == null) {
            this.passwordManager = new MemoryPasswordManager();
        }
    }

    public CacheProviderFactory getCacheProviderFactory() {
        return this.cacheProviderFactory;
    }

    public GalleyCoreBuilder withCacheProviderFactory(CacheProviderFactory cacheProviderFactory) {
        this.cacheProviderFactory = cacheProviderFactory;
        return this;
    }

    public PasswordManager getPasswordManager() {
        return this.passwordManager;
    }

    public GalleyCoreBuilder withPasswordManager(PasswordManager passwordManager) {
        this.passwordManager = passwordManager;
        return this;
    }

    public LocationExpander getLocationExpander() {
        return this.locationExpander;
    }

    public TransferDecorator getTransferDecorator() {
        return this.decorator;
    }

    public FileEventManager getFileEvents() {
        return this.events;
    }

    public CacheProvider getCache() {
        return this.cache;
    }

    public NotFoundCache getNfc() {
        return this.nfc;
    }

    public SpecialPathManager getSpecialPathManager() {
        return this.specialPathManager;
    }

    public GalleyCoreBuilder withLocationExpander(LocationExpander locations) {
        this.logger.debug("Setting location expander: {}", (Object)locations);
        this.locationExpander = locations;
        return this;
    }

    public GalleyCoreBuilder withTransferDecorator(TransferDecorator decorator) {
        this.decorator = decorator;
        return this;
    }

    public GalleyCoreBuilder withFileEvents(FileEventManager events) {
        this.events = events;
        return this;
    }

    public GalleyCoreBuilder withCache(CacheProvider cache) {
        this.cache = cache;
        return this;
    }

    public GalleyCoreBuilder withNfc(NotFoundCache nfc) {
        this.nfc = nfc;
        return this;
    }

    public GalleyCoreBuilder withSpecialPathManager(SpecialPathManager specialPathManager) {
        this.specialPathManager = specialPathManager;
        return this;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public TransferManager getTransferManager() {
        return this.transferManager;
    }

    public GalleyCoreBuilder withTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
        return this;
    }

    public GalleyCoreBuilder withTransferManager(TransferManager transferManager) {
        this.transferManager = transferManager;
        return this;
    }

    public List<Transport> getEnabledTransports() {
        return this.transports;
    }

    public GalleyCoreBuilder withEnabledTransports(List<Transport> transports) {
        this.transports = transports;
        return this;
    }

    public GalleyCoreBuilder withEnabledTransports(Transport ... transports) {
        this.transports = new ArrayList<Transport>(Arrays.asList(transports));
        return this;
    }

    public ExecutorService getHandlerExecutor() {
        return this.handlerExecutor;
    }

    public GalleyCoreBuilder withHandlerExecutor(ExecutorService handlerExecutor) {
        this.handlerExecutor = handlerExecutor;
        return this;
    }

    public ExecutorService getBatchExecutor() {
        return this.batchExecutor;
    }

    public GalleyCoreBuilder withBatchExecutor(ExecutorService batchExecutor) {
        this.batchExecutor = batchExecutor;
        return this;
    }

    public LocationResolver getLocationResolver() {
        return this.locationResolver;
    }

    public GalleyCoreBuilder withLocationResolver(LocationResolver locationResolver) {
        this.locationResolver = locationResolver;
        return this;
    }

    public GalleyCoreBuilder withAdditionalTransport(Transport transport) {
        if (this.transports == null) {
            this.transports = new ArrayList<Transport>();
        }
        this.transports.add(transport);
        return this;
    }

    public TransportManagerConfig getTransportManagerConfig() {
        return this.transportManagerConfig;
    }

    public GalleyCoreBuilder withTransportManagerConfig(TransportManagerConfig transportManagerConfig) {
        this.transportManagerConfig = transportManagerConfig;
        return this;
    }

    public PathGenerator getPathGenerator() {
        return this.pathGenerator;
    }

    public GalleyCoreBuilder withPathGenerator(PathGenerator pathGenerator) {
        this.pathGenerator = pathGenerator;
        return this;
    }
}

