/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.model;

import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;

public enum SiteTrustType {
    TRUST_SELF_SIGNED(new String[]{"self-signed", "trust-self-signed"}){

        @Override
        public TrustStrategy getTrustStrategy() {
            return new TrustSelfSignedStrategy();
        }
    }
    ,
    DEFAULT(new String[]{"default"}){

        @Override
        public TrustStrategy getTrustStrategy() {
            return null;
        }
    };

    private String[] aliases;

    private SiteTrustType(String ... aliases) {
        this.aliases = aliases;
    }

    public abstract TrustStrategy getTrustStrategy();

    public static SiteTrustType getType(String named) {
        for (SiteTrustType type : SiteTrustType.values()) {
            if (type.name().equalsIgnoreCase(named)) {
                return type;
            }
            for (String alias : type.aliases) {
                if (!alias.equalsIgnoreCase(named)) continue;
                return type;
            }
        }
        return DEFAULT;
    }
}

