/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import javax.annotation.CheckForNull;

public class HttpException
extends IOException {
    static final long serialVersionUID = 1L;
    private final int responseCode;
    private final String responseMessage;
    private final String url;

    public HttpException(String message, int responseCode, String responseMessage, String url) {
        super(message);
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.url = url;
    }

    public HttpException(String message, int responseCode, String responseMessage, String url, Throwable cause) {
        super(message);
        this.initCause(cause);
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.url = url;
    }

    public HttpException(int responseCode, String responseMessage, String url, Throwable cause) {
        super("Server returned HTTP response code: " + responseCode + ", message: '" + responseMessage + "' for URL: " + url);
        this.initCause(cause);
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.url = url;
    }

    public HttpException(int responseCode, String responseMessage, @CheckForNull URL url, Throwable cause) {
        this(responseCode, responseMessage, url == null ? null : url.toString(), cause);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getUrl() {
        return this.url;
    }
}

