/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.w3c.dom.NodeList;

@ApplicationScoped
public class XPathManager {
    public static final String G = "groupId";
    public static final String A = "artifactId";
    public static final String V = "version";
    public static final String T = "type";
    public static final String C = "classifier";
    public static final String AND = " and ";
    public static final String OR = " or ";
    public static final String NOT = " not(";
    public static final String OPEN_PAREN = "(";
    public static final String END_PAREN = ")";
    public static final String RESOLVE = "ext:resolve(";
    public static final String TEXT = "/text()";
    public static final String EQQUOTE = "=\"";
    public static final String QUOTE = "\"";
    private final XPath xpath = XPathFactory.newInstance().newXPath();

    public XPathManager() {
        this.xpath.setXPathFunctionResolver(new TLFunctionResolver());
    }

    public synchronized void clear() {
    }

    public XPathExpression getXPath(String path, boolean cache) throws XPathExpressionException {
        XPathExpression expression = this.xpath.compile(path);
        return expression;
    }

    private static final class ResolveFunction
    implements XPathFunction {
        private final MavenPomView pom;

        public ResolveFunction(MavenPomView pom) {
            this.pom = pom;
        }

        public Object evaluate(List args) throws XPathFunctionException {
            if (args.isEmpty()) {
                return null;
            }
            NodeList val = (NodeList)args.get(0);
            if (val == null || val.getLength() != 1) {
                return null;
            }
            String value = val.item(0).getTextContent();
            return this.pom.resolveExpressions(value, new String[0]);
        }
    }

    public static final class TLFunctionResolver
    implements XPathFunctionResolver {
        private static InheritableThreadLocal<MavenPomView> pomView = new InheritableThreadLocal();

        public static void setPomView(MavenPomView pom) {
            pomView.set(pom);
        }

        public static MavenPomView getPomView() {
            return (MavenPomView)pomView.get();
        }

        @Override
        public XPathFunction resolveFunction(QName functionName, int arity) {
            if (functionName.getLocalPart().equals("resolve")) {
                return new ResolveFunction((MavenPomView)pomView.get());
            }
            return null;
        }
    }
}

