/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.core.aggregation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.set.mavendependencyupdater.ArtifactResult;
import org.jboss.set.mavendependencyupdater.ComponentUpgrade;
import org.jboss.set.mavendependencyupdater.LocatedDependency;
import org.jboss.set.mavendependencyupdater.LocatedProperty;
import org.jboss.set.mavendependencyupdater.PomDependencyUpdater;

public class ComponentUpgradeAggregator {
    public static List<ArtifactResult<ComponentUpgrade>> aggregateComponentUpgrades(File rootPom, List<ArtifactResult<ComponentUpgrade>> upgrades) throws IOException, XmlPullParserException {
        HashSet<LocatedProperty> modifiedProperties = new HashSet<LocatedProperty>();
        ArrayList<ArtifactResult<ComponentUpgrade>> aggregatedUpgrades = new ArrayList<ArtifactResult<ComponentUpgrade>>();
        for (ArtifactResult<ComponentUpgrade> artifactUpgrade : upgrades) {
            LocatedDependency locatedDependency;
            LocatedProperty locatedProperty;
            boolean added;
            Optional<LocatedDependency> locatedDependencyOpt;
            File pomFile;
            Optional<ComponentUpgrade> componentUpgradeOptional = artifactUpgrade.getAny();
            if (!componentUpgradeOptional.isPresent()) continue;
            ComponentUpgrade upgrade = componentUpgradeOptional.get();
            if (upgrade.getProject() != null) {
                pomFile = upgrade.getProject().getPom();
                locatedDependencyOpt = PomDependencyUpdater.locateDependency(upgrade.getProject(), artifactUpgrade.getArtifactRef());
            } else {
                pomFile = rootPom;
                locatedDependencyOpt = PomDependencyUpdater.locateDependency(pomFile, artifactUpgrade.getArtifactRef());
            }
            if (!locatedDependencyOpt.isPresent() || !(added = modifiedProperties.add(locatedProperty = (locatedDependency = locatedDependencyOpt.get()).getLocatedProperty()))) continue;
            aggregatedUpgrades.add(artifactUpgrade);
        }
        return aggregatedUpgrades;
    }
}

