/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.cdi.util.weft;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.commonjava.cdi.util.weft.ContextSensitiveExecutorService;
import org.commonjava.cdi.util.weft.ExecutorConfig;
import org.commonjava.cdi.util.weft.NamedThreadFactory;
import org.commonjava.cdi.util.weft.SingleThreadedExecutorService;
import org.commonjava.cdi.util.weft.WeftManaged;
import org.commonjava.cdi.util.weft.WeftScheduledExecutor;
import org.commonjava.cdi.util.weft.config.WeftConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExecutorProvider {
    private final Map<String, ExecutorService> services = new ConcurrentHashMap<String, ExecutorService>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private WeftConfig config;
    private SingleThreadedExecutorService singleThreaded = new SingleThreadedExecutorService();

    @PreDestroy
    public void shutdown() {
        for (Map.Entry<String, ExecutorService> entry : this.services.entrySet()) {
            ExecutorService service = entry.getValue();
            service.shutdown();
            try {
                List<Runnable> running;
                service.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                if (service.isTerminated() || (running = service.shutdownNow()).isEmpty()) continue;
                this.logger.warn("{} tasks remain for executor: {}", (Object)running.size(), (Object)entry.getKey());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    @Produces
    @WeftManaged
    public ExecutorService getExecutorService(InjectionPoint ip) {
        return this.getExec(ip, false);
    }

    @Produces
    @WeftScheduledExecutor
    public ScheduledExecutorService getScheduledExecutorService(InjectionPoint ip) {
        return (ScheduledExecutorService)this.getExec(ip, true);
    }

    private ExecutorService getExec(InjectionPoint ip, boolean scheduled) {
        ExecutorConfig ec = ip.getAnnotated().getAnnotation(ExecutorConfig.class);
        Integer threadCount = 0;
        Integer priority = null;
        boolean daemon = true;
        String name = "weft-unannotated";
        if (ec != null) {
            threadCount = ec.threads();
            name = ec.named();
            priority = ec.priority();
            daemon = ec.daemon();
        }
        if (!this.config.isEnabled() || !this.config.isEnabled(name)) {
            return this.singleThreaded;
        }
        threadCount = this.config.getThreads(name, threadCount);
        priority = this.config.getPriority(name, priority);
        String key = name + ":" + (scheduled ? "scheduled" : "");
        ExecutorService service = this.services.get(key);
        if (service == null) {
            NamedThreadFactory fac = new NamedThreadFactory(name, daemon, priority);
            if (scheduled) {
                if (threadCount < 1) {
                    throw new RuntimeException(ip + " must specify a non-zero number for threads parameter in @ExecutorConfig.");
                }
                service = Executors.newScheduledThreadPool(threadCount, fac);
            } else {
                service = threadCount > 0 ? Executors.newFixedThreadPool(threadCount, fac) : Executors.newCachedThreadPool(fac);
            }
            service = new ContextSensitiveExecutorService(service);
            this.services.put(key, service);
        }
        return service;
    }
}

