/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.common.util;

import java.util.LinkedHashMap;
import java.util.TreeMap;
import org.apache.maven.model.Dependency;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildcardMap<T> {
    public static final String WILDCARD = "*";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TreeMap<String, LinkedHashMap<String, T>> map = new TreeMap();

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(Dependency key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        return this.internalContainsKey(groupId, artifactId);
    }

    public boolean containsKey(ProjectRef key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        return this.internalContainsKey(groupId, artifactId);
    }

    private boolean internalContainsKey(String groupId, String artifactId) {
        LinkedHashMap<String, T> vMap = this.map.get(groupId);
        boolean result = vMap == null || vMap.isEmpty() ? false : (vMap.get(WILDCARD) != null ? true : vMap.containsKey(artifactId));
        return result;
    }

    public void put(ProjectRef key, T value) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        LinkedHashMap<String, Object> vMap = this.map.get(groupId);
        if (vMap == null) {
            vMap = new LinkedHashMap();
        }
        boolean wildcard = false;
        if (WILDCARD.equals(artifactId)) {
            if (!vMap.isEmpty()) {
                this.logger.warn("Emptying map with keys " + vMap.keySet() + " as replacing with wildcard mapping " + key);
            }
            vMap.clear();
        } else {
            for (String o : vMap.keySet()) {
                if (!o.equals(WILDCARD)) continue;
                wildcard = true;
            }
        }
        if (wildcard) {
            this.logger.warn("Unable to add " + key + " with value " + value + " as wildcard mapping for " + groupId + " already exists.");
        } else {
            this.logger.debug("Entering artifact of " + artifactId + " and value " + value);
            vMap.put(artifactId, value);
            this.map.put(groupId, vMap);
        }
    }

    public T get(Dependency key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        return this.get(groupId, artifactId);
    }

    public T get(ProjectRef key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        return this.get(groupId, artifactId);
    }

    private T get(String groupId, String artifactId) {
        T result = null;
        LinkedHashMap<String, T> value = this.map.get(groupId);
        if (value != null) {
            this.logger.debug("Retrieved value map of " + value);
            result = value.get(WILDCARD) != null ? (T)value.get(WILDCARD) : (T)value.get(artifactId);
        }
        this.logger.debug("Returning result of " + result);
        return result;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return "WildcardMap{map=" + this.map + '}';
    }
}

