/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import groovy.lang.GroovyShell;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.groovy.BaseScript;
import org.commonjava.maven.ext.core.groovy.InvocationPoint;
import org.commonjava.maven.ext.core.groovy.InvocationStage;
import org.commonjava.maven.ext.core.groovy.PMEInvocationPoint;
import org.commonjava.maven.ext.io.FileIO;
import org.commonjava.maven.ext.io.ModelIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGroovyManipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ModelIO modelBuilder;
    protected FileIO fileIO;
    protected ManipulationSession session;

    BaseGroovyManipulator(ModelIO modelIO, FileIO fileIO) {
        this.modelBuilder = modelIO;
        this.fileIO = fileIO;
    }

    public abstract int getExecutionIndex();

    public List<File> parseGroovyScripts(String value) throws ManipulationException {
        if (StringUtils.isEmpty(value)) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        this.logger.debug("Processing groovy scripts {} ", (Object)value);
        try {
            String[] scripts;
            for (String script : scripts = value.split(",")) {
                File found;
                if (script.startsWith("http") || script.startsWith("file")) {
                    this.logger.info("Attempting to read URL {} ", (Object)script);
                    found = this.fileIO.resolveURL(new URL(script));
                } else {
                    SimpleArtifactRef ar = SimpleArtifactRef.parse(script);
                    this.logger.info("Attempting to read GAV {} with classifier {} and type {} ", ar.asProjectVersionRef(), ar.getClassifier(), ar.getType());
                    found = this.modelBuilder.resolveRawFile(ar);
                }
                result.add(found);
            }
        }
        catch (IOException e) {
            throw new ManipulationException("Unable to parse groovyScripts", (Throwable)e, new Object[0]);
        }
        return result;
    }

    void applyGroovyScript(List<Project> projects, Project project, File groovyScript) throws ManipulationException {
        InvocationStage stage;
        Script script;
        GroovyShell shell = new GroovyShell();
        try {
            script = shell.parse(groovyScript);
            PMEInvocationPoint deprecatedInvocationPoint = script.getClass().getAnnotation(PMEInvocationPoint.class);
            InvocationPoint invocationPoint = script.getClass().getAnnotation(InvocationPoint.class);
            if (deprecatedInvocationPoint != null) {
                this.logger.warn("Using deprecated InvocationPoint annotation (for {})", (Object)deprecatedInvocationPoint.invocationPoint().toString());
                this.logger.debug("InvocationPoint is {}", (Object)deprecatedInvocationPoint.invocationPoint().toString());
                stage = deprecatedInvocationPoint.invocationPoint();
            } else if (invocationPoint != null) {
                this.logger.debug("InvocationPoint is {}", (Object)invocationPoint.invocationPoint().toString());
                stage = invocationPoint.invocationPoint();
            } else {
                stage = null;
            }
            if (stage == null) {
                throw new ManipulationException("Mandatory annotation '@InvocationPoint(invocationPoint = ' not declared", new String[0]);
            }
            if (!(script instanceof BaseScript)) {
                throw new ManipulationException("Cannot cast " + groovyScript + " to a BaseScript to set values.", new String[0]);
            }
            ((BaseScript)script).setValues(this.modelBuilder, this.session, projects, project, stage);
        }
        catch (MissingMethodException e) {
            try {
                this.logger.debug("Failure when injecting into script {} ", (Object)FileUtils.readFileToString(groovyScript, Charset.defaultCharset()), (Object)e);
            }
            catch (IOException e1) {
                this.logger.debug("Unable to read script file {} for debugging! {} ", (Object)groovyScript, (Object)e1);
            }
            throw new ManipulationException("Unable to inject values into base script", (Throwable)e, new Object[0]);
        }
        catch (CompilationFailedException e) {
            try {
                this.logger.debug("Failure when parsing script {} ", (Object)FileUtils.readFileToString(groovyScript, Charset.defaultCharset()), (Object)e);
            }
            catch (IOException e1) {
                this.logger.debug("Unable to read script file {} for debugging! {} ", (Object)groovyScript, (Object)e1);
            }
            throw new ManipulationException("Unable to parse script", (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new ManipulationException("Unable to parse script", (Throwable)e, new Object[0]);
        }
        if (this.getExecutionIndex() == stage.getStageValue() || stage == InvocationStage.BOTH) {
            try {
                this.logger.info("Executing {} on {} at invocation point {}", new Object[]{groovyScript, project, stage});
                script.run();
                this.logger.info("Completed {}.", (Object)groovyScript);
            }
            catch (Exception e) {
                throw new ManipulationException("Unable to parse script", (Throwable)e, new Object[0]);
            }
        } else {
            this.logger.debug("Ignoring script {} as invocation point {} does not match index {}", new Object[]{groovyScript, stage, this.getExecutionIndex()});
        }
    }
}

