/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.WildcardMap;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.CommonState;
import org.commonjava.maven.ext.core.state.DependencyState;
import org.commonjava.maven.ext.core.state.RESTState;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.core.util.PropertyMapper;
import org.commonjava.maven.ext.io.ModelIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="project-dependency-manipulator")
@Singleton
public class DependencyManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Project, Map<String, PropertyMapper>> explicitVersionPropertyUpdateMap = new LinkedHashMap<Project, Map<String, PropertyMapper>>();
    private final Map<Project, Map<String, PropertyMapper>> versionPropertyUpdateMap = new LinkedHashMap<Project, Map<String, PropertyMapper>>();
    private ModelIO effectiveModelBuilder;
    private ManipulationSession session;

    @Inject
    public DependencyManipulator(ModelIO effectiveModelBuilder) {
        this.effectiveModelBuilder = effectiveModelBuilder;
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        session.setState(new DependencyState(session.getUserProperties()));
        this.session = session;
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        DependencyState state = this.session.getState(DependencyState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        return this.internalApplyChanges(projects, this.loadRemoteOverrides());
    }

    private Map<ArtifactRef, String> loadRemoteOverrides() throws ManipulationException {
        DependencyState depState = this.session.getState(DependencyState.class);
        RESTState restState = this.session.getState(RESTState.class);
        List<ProjectVersionRef> gavs = depState.getRemoteBOMDepMgmt();
        Map<String, ProjectVersionRef> extraGAVs = depState.getExtraBOMs();
        Map<String, Map<ProjectRef, String>> extraBOMOverrides = depState.getExtraBOMDepMgmts();
        Map<ArtifactRef, String> restOverrides = depState.getRemoteRESTOverrides();
        LinkedHashMap<ArtifactRef, String> bomOverrides = new LinkedHashMap<ArtifactRef, String>();
        Map<Object, Object> mergedOverrides = new LinkedHashMap();
        if (gavs != null) {
            Iterator<Map.Entry<String, ProjectVersionRef>> iter = gavs.listIterator(gavs.size());
            while (iter.hasPrevious()) {
                ProjectVersionRef ref = (ProjectVersionRef)iter.previous();
                Map<ArtifactRef, String> rBom = this.effectiveModelBuilder.getRemoteDependencyVersionOverrides(ref);
                bomOverrides.putAll(rBom);
            }
        }
        for (Map.Entry<String, ProjectVersionRef> entry : extraGAVs.entrySet()) {
            extraBOMOverrides.put(entry.getKey(), this.effectiveModelBuilder.getRemoteDependencyVersionOverridesByProject(entry.getValue()));
        }
        if (depState.getPrecedence() == DependencyState.DependencyPrecedence.BOM && (mergedOverrides = bomOverrides).isEmpty()) {
            String msg = restState.isEnabled() ? "dependencySource for restURL" : "dependencyManagement";
            this.logger.warn("No dependencies found for dependencySource {}. Has {} been configured? ", (Object)depState.getPrecedence(), (Object)msg);
        }
        if (depState.getPrecedence() == DependencyState.DependencyPrecedence.REST) {
            mergedOverrides = restOverrides;
            if (mergedOverrides.isEmpty()) {
                this.logger.warn("No dependencies found for dependencySource {}. Has restURL been configured? ", (Object)depState.getPrecedence());
            }
        } else if (depState.getPrecedence() == DependencyState.DependencyPrecedence.RESTBOM) {
            mergedOverrides = bomOverrides;
            this.removeDuplicateArtifacts(mergedOverrides, restOverrides);
            mergedOverrides.putAll(restOverrides);
        } else if (depState.getPrecedence() == DependencyState.DependencyPrecedence.BOMREST) {
            mergedOverrides = restOverrides;
            this.removeDuplicateArtifacts(mergedOverrides, bomOverrides);
            mergedOverrides.putAll(bomOverrides);
        }
        this.logger.info("Remote precedence is {}", (Object)depState.getPrecedence());
        this.logger.debug("Final remote override list is {}", (Object)mergedOverrides);
        return mergedOverrides;
    }

    private void removeDuplicateArtifacts(Map<ArtifactRef, String> mergedOverrides, Map<ArtifactRef, String> targetOverrides) {
        Iterator<ArtifactRef> i = mergedOverrides.keySet().iterator();
        block0: while (i.hasNext()) {
            ArtifactRef key = i.next();
            ProjectRef pRef = key.asProjectRef();
            for (ArtifactRef target : targetOverrides.keySet()) {
                if (!pRef.equals(target.asProjectRef())) continue;
                this.logger.debug("From source overrides artifact {} clashes with target {}", (Object)key, (Object)target);
                i.remove();
                continue block0;
            }
        }
    }

    @Override
    public int getExecutionIndex() {
        return 40;
    }

    private Set<Project> internalApplyChanges(List<Project> projects, Map<ArtifactRef, String> overrides) throws ManipulationException {
        DependencyState state = this.session.getState(DependencyState.class);
        CommonState cState = this.session.getState(CommonState.class);
        HashSet<Project> result = new HashSet<Project>();
        for (Project project : projects) {
            Model model = project.getModel();
            if (overrides.isEmpty() && state.getDependencyExclusions().isEmpty()) continue;
            this.apply(project, model, overrides);
            result.add(project);
        }
        if (!result.isEmpty()) {
            PropertiesUtils.PropertyUpdate found;
            if (cState.getStrictDependencyPluginPropertyValidation() > 0) {
                this.logger.info("Iterating to validate dependency updates...");
                for (Project p : this.versionPropertyUpdateMap.keySet()) {
                    this.validateDependenciesUpdatedProperty(cState, p, p.getResolvedManagedDependencies(this.session));
                    this.validateDependenciesUpdatedProperty(cState, p, p.getResolvedDependencies(this.session));
                    for (Profile profile : p.getResolvedProfileDependencies(this.session).keySet()) {
                        this.validateDependenciesUpdatedProperty(cState, p, p.getResolvedProfileDependencies(this.session).get(profile));
                    }
                    for (Profile profile : p.getResolvedProfileManagedDependencies(this.session).keySet()) {
                        this.validateDependenciesUpdatedProperty(cState, p, p.getResolvedProfileManagedDependencies(this.session).get(profile));
                    }
                }
            }
            this.logger.info("Iterating for standard overrides...");
            for (Project project : this.versionPropertyUpdateMap.keySet()) {
                this.logger.debug("Checking property override within project {} ", (Object)project);
                for (Map.Entry<String, PropertyMapper> entry : this.versionPropertyUpdateMap.get(project).entrySet()) {
                    found = PropertiesUtils.updateProperties(this.session, project, false, entry.getKey(), entry.getValue().getNewVersion());
                    if (found != PropertiesUtils.PropertyUpdate.NOTFOUND) continue;
                    this.logger.info("Unable to find a property for {} to update", (Object)entry.getKey());
                    this.logger.info("Adding property {} with {} ", (Object)entry.getKey(), (Object)entry.getValue().getNewVersion());
                    project.getInheritedList().get(0).getModel().getProperties().setProperty(entry.getKey(), entry.getValue().getNewVersion());
                }
            }
            this.logger.info("Iterating for explicit overrides...");
            for (Project project : this.explicitVersionPropertyUpdateMap.keySet()) {
                this.logger.debug("Checking property override within project {} ", (Object)project);
                for (Map.Entry entry : this.explicitVersionPropertyUpdateMap.get(project).entrySet()) {
                    found = PropertiesUtils.updateProperties(this.session, project, true, (String)entry.getKey(), ((PropertyMapper)entry.getValue()).getNewVersion());
                    if (found != PropertiesUtils.PropertyUpdate.NOTFOUND) continue;
                    this.logger.info("Unable to find a property for {} to update for explicit overrides", entry.getKey());
                    this.logger.info("Adding property {} with {} ", entry.getKey(), (Object)((PropertyMapper)entry.getValue()).getNewVersion());
                    project.getInheritedList().get(0).getModel().getProperties().setProperty((String)entry.getKey(), ((PropertyMapper)entry.getValue()).getNewVersion());
                }
            }
        }
        return result;
    }

    private void apply(Project project, Model model, Map<ArtifactRef, String> overrides) throws ManipulationException {
        WildcardMap<String> explicitOverrides = new WildcardMap<String>();
        String projectGA = IdUtils.ga(project);
        DependencyState dependencyState = this.session.getState(DependencyState.class);
        CommonState commonState = this.session.getState(CommonState.class);
        this.logger.debug("Processing project {} ", (Object)projectGA);
        Map<ArtifactRef, String> moduleOverrides = new LinkedHashMap<ArtifactRef, String>(overrides);
        moduleOverrides = this.removeReactorGAs(moduleOverrides);
        try {
            moduleOverrides = this.applyModuleVersionOverrides(projectGA, dependencyState.getDependencyExclusions(), moduleOverrides, explicitOverrides, dependencyState.getExtraBOMDepMgmts());
            this.logger.debug("Module overrides are:\n{}", (Object)moduleOverrides);
            this.logger.debug("Explicit overrides are:\n{}", (Object)explicitOverrides);
        }
        catch (InvalidRefException e) {
            this.logger.error("Invalid module exclusion override {} : {} ", (Object)moduleOverrides, (Object)explicitOverrides);
            throw e;
        }
        if (project.isInheritanceRoot()) {
            if (project.getModelParent() != null) {
                for (Map.Entry<ArtifactRef, String> entry : moduleOverrides.entrySet()) {
                    String oldValue = project.getModelParent().getVersion();
                    String newValue = entry.getValue();
                    if (!entry.getKey().asProjectRef().equals(SimpleProjectRef.parse(IdUtils.ga(project.getModelParent())))) continue;
                    if (commonState.isStrict() && !PropertiesUtils.checkStrictValue(this.session, oldValue, newValue)) {
                        if (commonState.isFailOnStrictViolation()) {
                            throw new ManipulationException("Parent reference {} replacement: {} of original version: {} violates the strict version-alignment rule!", IdUtils.ga(project.getModelParent()), newValue, oldValue);
                        }
                        this.logger.warn("Parent reference {} replacement: {} of original version: {} violates the strict version-alignment rule!", IdUtils.ga(project.getModelParent()), newValue, oldValue);
                        continue;
                    }
                    this.logger.debug(" Modifying parent reference from {} to {} for {} ", model.getParent().getVersion(), newValue, IdUtils.ga(project.getModelParent()));
                    model.getParent().setVersion(newValue);
                    break;
                }
                HashMap<ArtifactRef, Dependency> pDepMap = new HashMap<ArtifactRef, Dependency>();
                Dependency d = new Dependency();
                d.setGroupId(project.getModelParent().getGroupId());
                d.setArtifactId(project.getModelParent().getArtifactId());
                d.setVersion(project.getModelParent().getVersion());
                pDepMap.put(SimpleArtifactRef.parse(d.getManagementKey()), d);
                this.applyExplicitOverrides(project, pDepMap, explicitOverrides, commonState, this.explicitVersionPropertyUpdateMap);
                project.getModelParent().setVersion(d.getVersion());
            }
            this.logger.debug("Applying overrides to managed dependencies for: {}", (Object)projectGA);
            Map<ArtifactRef, String> nonMatchingVersionOverrides = this.applyOverrides(project, project.getResolvedManagedDependencies(this.session), explicitOverrides, moduleOverrides);
            this.applyExplicitOverrides(project, project.getResolvedManagedDependencies(this.session), explicitOverrides, commonState, this.explicitVersionPropertyUpdateMap);
            if (commonState.isOverrideTransitive()) {
                ArrayList<Dependency> extraDeps = new ArrayList<Dependency>();
                for (ArtifactRef var : overrides.keySet()) {
                    if (!nonMatchingVersionOverrides.containsKey(var)) continue;
                    Dependency newDependency = new Dependency();
                    newDependency.setGroupId(var.getGroupId());
                    newDependency.setArtifactId(var.getArtifactId());
                    newDependency.setType(var.getType());
                    newDependency.setClassifier(var.getClassifier());
                    String artifactVersion = moduleOverrides.get(var);
                    newDependency.setVersion(artifactVersion);
                    extraDeps.add(newDependency);
                    this.logger.debug("New entry added to <DependencyManagement/> - {} : {} ", (Object)var, (Object)artifactVersion);
                }
                DependencyManagement dependencyManagement = model.getDependencyManagement();
                if (extraDeps.size() > 0) {
                    if (dependencyManagement == null) {
                        dependencyManagement = new DependencyManagement();
                        model.setDependencyManagement(dependencyManagement);
                        this.logger.debug("Added <DependencyManagement/> for current project");
                    }
                    dependencyManagement.getDependencies().addAll(0, extraDeps);
                }
            } else {
                this.logger.debug("Non-matching dependencies ignored.");
            }
        } else {
            this.logger.debug("Applying overrides to managed dependencies for: {}", (Object)projectGA);
            this.applyOverrides(project, project.getResolvedManagedDependencies(this.session), explicitOverrides, moduleOverrides);
            this.applyExplicitOverrides(project, project.getResolvedManagedDependencies(this.session), explicitOverrides, commonState, this.explicitVersionPropertyUpdateMap);
        }
        this.logger.debug("Applying overrides to concrete dependencies for: {}", (Object)projectGA);
        this.applyOverrides(project, project.getResolvedDependencies(this.session), explicitOverrides, moduleOverrides);
        this.applyExplicitOverrides(project, project.getResolvedDependencies(this.session), explicitOverrides, commonState, this.explicitVersionPropertyUpdateMap);
        Map<Profile, Map<ArtifactRef, Dependency>> pd = project.getResolvedProfileDependencies(this.session);
        Map<Profile, Map<ArtifactRef, Dependency>> pmd = project.getResolvedProfileManagedDependencies(this.session);
        for (Profile p : pd.keySet()) {
            this.applyOverrides(project, pd.get(p), explicitOverrides, moduleOverrides);
            this.applyExplicitOverrides(project, pd.get(p), explicitOverrides, commonState, this.explicitVersionPropertyUpdateMap);
        }
        for (Profile p : pmd.keySet()) {
            this.applyOverrides(project, pmd.get(p), explicitOverrides, moduleOverrides);
            this.applyExplicitOverrides(project, pmd.get(p), explicitOverrides, commonState, this.explicitVersionPropertyUpdateMap);
        }
    }

    private void applyExplicitOverrides(Project project, Map<ArtifactRef, Dependency> dependencies, WildcardMap<String> explicitOverrides, CommonState state, Map<Project, Map<String, PropertyMapper>> versionPropertyUpdateMap) throws ManipulationException {
        for (ArtifactRef dependency : dependencies.keySet()) {
            SimpleProjectRef groupIdArtifactId = new SimpleProjectRef(dependency.getGroupId(), dependency.getArtifactId());
            if (!explicitOverrides.containsKey(groupIdArtifactId)) continue;
            String overrideVersion = explicitOverrides.get(groupIdArtifactId);
            String oldVersion = dependencies.get(dependency).getVersion();
            if (StringUtils.isEmpty(overrideVersion) || StringUtils.isEmpty(oldVersion)) {
                if (StringUtils.isEmpty(oldVersion)) {
                    this.logger.debug("Unable to force align as no existing version field to update for " + groupIdArtifactId + "; ignoring");
                    continue;
                }
                this.logger.warn("Unable to force align as override version is empty for " + groupIdArtifactId + "; ignoring");
                continue;
            }
            for (String target : overrideVersion.split(",")) {
                if (target.startsWith("+")) {
                    this.logger.info("Adding dependency exclusion {} to dependency {} ", (Object)target.substring(1), (Object)dependency);
                    Exclusion e = new Exclusion();
                    e.setGroupId(target.substring(1).split(":")[0]);
                    e.setArtifactId(target.split(":")[1]);
                    dependencies.get(dependency).addExclusion(e);
                    continue;
                }
                this.logger.info("Explicit overrides : force aligning {} to {}.", (Object)groupIdArtifactId, (Object)target);
                if (PropertiesUtils.cacheProperty(project, state, versionPropertyUpdateMap, oldVersion, target, dependency, true)) continue;
                if (oldVersion.contains("${")) {
                    this.logger.warn("Overriding version with {} when old version contained a property {} ", (Object)target, (Object)oldVersion);
                }
                dependencies.get(dependency).setVersion(target);
            }
        }
    }

    private Map<ArtifactRef, String> applyOverrides(Project project, Map<ArtifactRef, Dependency> dependencies, WildcardMap<String> explicitOverrides, Map<ArtifactRef, String> overrides) throws ManipulationException {
        LinkedHashMap<ArtifactRef, String> unmatchedVersionOverrides = new LinkedHashMap<ArtifactRef, String>(overrides);
        if (dependencies == null || dependencies.size() == 0) {
            return unmatchedVersionOverrides;
        }
        CommonState commonState = this.session.getState(CommonState.class);
        boolean strict = commonState.isStrict();
        for (ArtifactRef dependency : dependencies.keySet()) {
            SimpleProjectRef depPr = new SimpleProjectRef(dependency.getGroupId(), dependency.getArtifactId());
            for (Map.Entry<ArtifactRef, String> entry : overrides.entrySet()) {
                ProjectRef groupIdArtifactId = entry.getKey().asProjectRef();
                if (!((Object)depPr).equals(groupIdArtifactId)) continue;
                String oldVersion = dependencies.get(dependency).getVersion();
                String overrideVersion = entry.getValue();
                String resolvedValue = dependency.getVersionString();
                if (StringUtils.isEmpty(overrideVersion)) {
                    this.logger.warn("Unable to align with an empty override version for {}; ignoring", (Object)groupIdArtifactId);
                    continue;
                }
                if (StringUtils.isEmpty(oldVersion)) {
                    this.logger.debug("Dependency is a managed version for {}; ignoring", (Object)groupIdArtifactId);
                    continue;
                }
                if (oldVersion.equals("${project.version}") || oldVersion.contains("$") && project.getVersion().equals(resolvedValue)) {
                    this.logger.debug("Dependency {} with original version {} and project version {} for {} references ${project.version} so skipping.", dependency, oldVersion, project.getVersion(), project.getPom());
                    continue;
                }
                if (explicitOverrides.containsKey(depPr)) {
                    this.logger.debug("Dependency {} matches known explicit override so not performing initial override pass.", (Object)depPr);
                    unmatchedVersionOverrides.remove(entry.getKey());
                    continue;
                }
                if (strict && oldVersion.contains("$") && !PropertiesUtils.checkStrictValue(this.session, resolvedValue, overrideVersion)) {
                    this.logger.debug("Original fully resolved version {} of {} does not match override version {} -> {} so ignoring", resolvedValue, dependency, entry.getKey(), overrideVersion);
                    if (commonState.isFailOnStrictViolation()) {
                        throw new ManipulationException("For {} replacing original property version {} (fully resolved: {} ) with new version {} for {} violates the strict version-alignment rule!", ((Object)depPr).toString(), dependencies.get(dependency).getVersion(), resolvedValue, entry.getKey().getVersionString(), entry.getKey().asProjectRef().toString());
                    }
                    this.logger.warn("Replacing original property version {} with new version {} for {} violates the strict version-alignment rule!", resolvedValue, overrideVersion, dependencies.get(dependency).getVersion());
                    continue;
                }
                if (!PropertiesUtils.cacheProperty(project, commonState, this.versionPropertyUpdateMap, oldVersion, overrideVersion, entry.getKey(), false)) {
                    if (strict && !PropertiesUtils.checkStrictValue(this.session, resolvedValue, overrideVersion)) {
                        if (commonState.isFailOnStrictViolation()) {
                            throw new ManipulationException("Replacing original version {} in dependency {} with new version {} violates the strict version-alignment rule!", oldVersion, groupIdArtifactId.toString(), overrideVersion);
                        }
                        this.logger.warn("Replacing original version {} in dependency {} with new version {} violates the strict version-alignment rule!", oldVersion, groupIdArtifactId, overrideVersion);
                    } else {
                        this.logger.debug("Altered dependency {} : {} -> {}", groupIdArtifactId, oldVersion, overrideVersion);
                        if (oldVersion.contains("${")) {
                            String replaceVersion;
                            String suffix = PropertiesUtils.getSuffix(this.session);
                            if (commonState.isStrictIgnoreSuffix() && oldVersion.contains(suffix)) {
                                replaceVersion = StringUtils.substringBefore(oldVersion, suffix);
                                replaceVersion = replaceVersion + suffix + StringUtils.substringAfter(overrideVersion, suffix);
                            } else {
                                replaceVersion = oldVersion + StringUtils.removeStart(overrideVersion, resolvedValue);
                            }
                            this.logger.debug("Resolved value is {} and replacement version is {} ", (Object)resolvedValue, (Object)replaceVersion);
                            dependencies.get(dependency).setVersion(replaceVersion);
                        } else {
                            dependencies.get(dependency).setVersion(overrideVersion);
                        }
                    }
                }
                unmatchedVersionOverrides.remove(entry.getKey());
            }
        }
        return unmatchedVersionOverrides;
    }

    private Map<ArtifactRef, String> removeReactorGAs(Map<ArtifactRef, String> versionOverrides) {
        LinkedHashMap<ArtifactRef, String> reducedVersionOverrides = new LinkedHashMap<ArtifactRef, String>(versionOverrides);
        for (Project project : this.session.getProjects()) {
            reducedVersionOverrides.remove(new SimpleArtifactRef(project.getGroupId(), project.getArtifactId(), project.getVersion(), "pom", null));
        }
        return reducedVersionOverrides;
    }

    private Map<ArtifactRef, String> applyModuleVersionOverrides(String projectGA, Map<String, String> moduleOverrides, Map<ArtifactRef, String> originalOverrides, WildcardMap<String> explicitOverrides, Map<String, Map<ProjectRef, String>> extraBOMOverrides) throws ManipulationException {
        boolean[] wildcardMode;
        LinkedHashMap<ArtifactRef, String> remainingOverrides = new LinkedHashMap<ArtifactRef, String>(originalOverrides);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Calculating module-specific version overrides. Starting with:\n  {}", (Object)StringUtils.join(remainingOverrides.entrySet(), "\n  "));
        }
        for (boolean aWildcardMode : wildcardMode = new boolean[]{false, true}) {
            for (String currentKey : new HashSet<String>(moduleOverrides.keySet())) {
                String newArtifactValue;
                String artifactGA;
                String currentValue = moduleOverrides.get(currentKey);
                this.logger.debug("Processing key {} for override with value {}", (Object)currentKey, (Object)currentValue);
                if (!currentKey.contains("@")) {
                    this.logger.debug("Not an override. Skip.");
                    continue;
                }
                boolean isModuleWildcard = currentKey.endsWith("@*");
                this.logger.debug("Is wildcard? {} and in module wildcard mode? {} ", (Object)isModuleWildcard, (Object)aWildcardMode);
                boolean replace = false;
                if (!aWildcardMode) {
                    if (isModuleWildcard) {
                        this.logger.debug("Not currently in wildcard mode. Skip.");
                        continue;
                    }
                    String[] artifactAndModule = currentKey.split("@");
                    if (artifactAndModule.length != 2) {
                        throw new ManipulationException("Invalid format for exclusion key " + currentKey, new String[0]);
                    }
                    artifactGA = artifactAndModule[0];
                    ProjectRef moduleGA = SimpleProjectRef.parse(artifactAndModule[1]);
                    this.logger.debug("For artifact override: {}, comparing parsed module: {} to current project: {}", artifactGA, moduleGA, projectGA);
                    if (moduleGA.toString().equals(projectGA) || moduleGA.getArtifactId().equals("*") && SimpleProjectRef.parse(projectGA).getGroupId().equals(moduleGA.getGroupId())) {
                        if (currentValue != null && !currentValue.isEmpty()) {
                            replace = true;
                            this.logger.debug("Overriding module dependency for {} with {} : {}", moduleGA, artifactGA, currentValue);
                        } else {
                            this.removeGA(remainingOverrides, SimpleProjectRef.parse(artifactGA));
                            this.logger.debug("For module {}, ignoring dependency override for {} ", (Object)moduleGA, (Object)artifactGA);
                        }
                    }
                } else {
                    if (!isModuleWildcard) {
                        this.logger.debug("Currently in wildcard mode. Skip.");
                        continue;
                    }
                    artifactGA = currentKey.substring(0, currentKey.length() - 2);
                    this.logger.debug("For artifact override: {}, checking if current overrides already contain a module-specific version.", (Object)artifactGA);
                    if (explicitOverrides.containsKey(SimpleProjectRef.parse(artifactGA))) {
                        this.logger.debug("For artifact override: {}, current overrides already contain a module-specific version. Skip.", (Object)artifactGA);
                        continue;
                    }
                    if (currentValue != null && !currentValue.isEmpty()) {
                        this.logger.debug("Overriding module dependency for {} with {} : {}", projectGA, artifactGA, currentValue);
                        replace = true;
                    } else {
                        this.removeGA(remainingOverrides, SimpleProjectRef.parse(artifactGA));
                        this.logger.debug("Removing artifactGA {} from overrides", (Object)artifactGA);
                    }
                }
                if (!replace) continue;
                ProjectRef projectRef = SimpleProjectRef.parse(artifactGA);
                Map<ProjectRef, String> extraBOM = extraBOMOverrides.get(currentValue);
                if (extraBOM == null) {
                    newArtifactValue = currentValue;
                } else {
                    newArtifactValue = extraBOM.get(projectRef);
                    if (newArtifactValue == null) {
                        throw new ManipulationException("Extra BOM {} does not define a version for artifact {} targeted by {}", currentValue, artifactGA, currentKey);
                    }
                    this.logger.debug("Dereferenced value {} for {} from extra BOM {}", newArtifactValue, artifactGA, currentValue);
                }
                explicitOverrides.put(projectRef, newArtifactValue);
            }
        }
        return remainingOverrides;
    }

    private void removeGA(Map<ArtifactRef, String> overrides, ProjectRef ref) {
        Iterator<ArtifactRef> it = overrides.keySet().iterator();
        while (it.hasNext()) {
            ArtifactRef a = it.next();
            if (a.asProjectRef().equals(ref) || ref.getArtifactId().equals("*") && a.getGroupId().equals(ref.getGroupId()) || ref.getGroupId().equals("*") && a.getArtifactId().equals(ref.getArtifactId())) {
                it.remove();
                continue;
            }
            if (!ref.getArtifactId().equals("*") || !ref.getGroupId().equals("*")) continue;
            it.remove();
        }
    }

    private void validateDependenciesUpdatedProperty(CommonState cState, Project p, Map<ArtifactRef, Dependency> dependencies) throws ManipulationException {
        for (ArtifactRef d : dependencies.keySet()) {
            String versionProperty = dependencies.get(d).getVersion();
            if (!versionProperty.startsWith("${")) continue;
            PropertiesUtils.verifyPropertyMapping(cState, p, this.versionPropertyUpdateMap, d, PropertiesUtils.extractPropertyName(versionProperty));
        }
    }
}

