/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.YamlFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

@Named
@Singleton
public class ConfigIO {
    private final Logger logger = LoggerFactory.getLogger(ConfigIO.class);
    private static final String propertyFileString = "pme.properties";
    private static final String yamlPMEFileString = "pme.yaml";
    private static final String yamlPNCFileString = "pnc.yaml";
    private static final String jsonPNCFileString = "pnc.json";

    public Properties parse(String workingDir) throws ManipulationException {
        return this.parse(new File(workingDir));
    }

    public Properties parse(File workingDir) throws ManipulationException {
        Properties result = new Properties();
        File propertyFile = new File(workingDir, propertyFileString);
        File yamlPMEFile = new File(workingDir, yamlPMEFileString);
        File yamlPNCFile = new File(workingDir, yamlPNCFileString);
        File jsonPNCFile = new File(workingDir, jsonPNCFileString);
        if (propertyFile.exists() && (yamlPMEFile.exists() || yamlPNCFile.exists() || jsonPNCFile.exists())) {
            throw new ManipulationException("Cannot have both yaml, json and property configuration files.", new String[0]);
        }
        if (yamlPMEFile.exists() && yamlPNCFile.exists()) {
            throw new ManipulationException("Cannot have both yaml configuration file formats.", new String[0]);
        }
        if ((yamlPMEFile.exists() || yamlPNCFile.exists()) && jsonPNCFile.exists()) {
            throw new ManipulationException("Cannot have yaml and json configuration file formats.", new String[0]);
        }
        if (yamlPMEFile.exists()) {
            result = this.loadYamlFile(yamlPMEFile);
            this.logger.debug("Read yaml file containing {}.", (Object)result);
        } else if (yamlPNCFile.exists()) {
            result = this.loadYamlFile(yamlPNCFile);
            this.logger.debug("Read yaml file containing {}.", (Object)result);
        } else if (jsonPNCFile.exists()) {
            try {
                result.putAll((Map<?, ?>)JsonPath.parse(jsonPNCFile).read("$.pme", Map.class, new Predicate[0]));
            }
            catch (JsonPathException | IOException e) {
                throw new ManipulationException("Caught exception processing JSON file.", (Throwable)e, new Object[0]);
            }
            this.logger.debug("Read json file containing {}.", (Object)result);
        } else if (propertyFile.exists()) {
            result = this.loadPropertiesFile(propertyFile);
            this.logger.debug("Read properties file containing {}.", (Object)result);
        }
        return result;
    }

    private Properties loadYamlFile(File configFile) throws ManipulationException {
        Properties result = new Properties();
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml(representer);
        try {
            YamlFile yf = yaml.loadAs(new FileInputStream(configFile), YamlFile.class);
            result.putAll(yf.getPme());
        }
        catch (FileNotFoundException e) {
            throw new ManipulationException("Unable to load yaml file.", (Throwable)e, new Object[0]);
        }
        return result;
    }

    private Properties loadPropertiesFile(File configFile) throws ManipulationException {
        Properties result = new Properties();
        try (FileInputStream input = new FileInputStream(configFile);){
            result.load(input);
        }
        catch (IOException e) {
            throw new ManipulationException("Unable to load properties file.", (Throwable)e, new Object[0]);
        }
        return result;
    }
}

