/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.commonjava.cdi.util.weft.ExecutorConfig;
import org.commonjava.cdi.util.weft.WeftManaged;
import org.commonjava.maven.atlas.ident.util.JoinString;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.TransferLocationException;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.event.FileErrorEvent;
import org.commonjava.maven.galley.event.FileNotFoundEvent;
import org.commonjava.maven.galley.internal.xfer.BatchRetriever;
import org.commonjava.maven.galley.internal.xfer.DownloadHandler;
import org.commonjava.maven.galley.internal.xfer.ExistenceHandler;
import org.commonjava.maven.galley.internal.xfer.ListingHandler;
import org.commonjava.maven.galley.internal.xfer.UploadHandler;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.ListingResult;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Resource;
import org.commonjava.maven.galley.model.SpecialPathInfo;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferBatch;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.model.VirtualResource;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.io.SpecialPathManager;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.spi.transport.TransportManager;
import org.commonjava.maven.galley.util.LocationUtils;
import org.commonjava.maven.galley.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TransferManagerImpl
implements TransferManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private CacheProvider cacheProvider;
    @Inject
    private NotFoundCache nfc;
    @Inject
    private TransportManager transportManager;
    @Inject
    private FileEventManager fileEventManager;
    @Inject
    private DownloadHandler downloader;
    @Inject
    private UploadHandler uploader;
    @Inject
    private ListingHandler lister;
    @Inject
    private ExistenceHandler exister;
    @Inject
    private SpecialPathManager specialPathManager;
    @Inject
    @WeftManaged
    @ExecutorConfig(threads=12, named="galley-batching", priority=8)
    private ExecutorService executorService;
    private ExecutorCompletionService<BatchRetriever> batchExecutor;

    protected TransferManagerImpl() {
    }

    public TransferManagerImpl(TransportManager transportManager, CacheProvider cacheProvider, NotFoundCache nfc, FileEventManager fileEventManager, DownloadHandler downloader, UploadHandler uploader, ListingHandler lister, ExistenceHandler exister, SpecialPathManager specialPathManager, ExecutorService executorService) {
        this.transportManager = transportManager;
        this.cacheProvider = cacheProvider;
        this.nfc = nfc;
        this.fileEventManager = fileEventManager;
        this.downloader = downloader;
        this.uploader = uploader;
        this.lister = lister;
        this.exister = exister;
        this.specialPathManager = specialPathManager;
        this.executorService = executorService;
        this.init();
    }

    @PostConstruct
    public void init() {
        this.batchExecutor = new ExecutorCompletionService(this.executorService);
    }

    @Override
    public boolean exists(ConcreteResource resource) throws TransferException {
        return this.exists(resource, false);
    }

    @Override
    public ConcreteResource findFirstExisting(VirtualResource virt) throws TransferException {
        for (ConcreteResource res : virt) {
            if (!this.exists(res, true)) continue;
            return res;
        }
        return null;
    }

    @Override
    public List<ConcreteResource> findAllExisting(VirtualResource virt) throws TransferException {
        ArrayList<ConcreteResource> results = new ArrayList<ConcreteResource>();
        for (ConcreteResource res : virt) {
            if (!this.exists(res, true)) continue;
            results.add(res);
        }
        return results;
    }

    private boolean exists(ConcreteResource resource, boolean suppressFailures) throws TransferException {
        Transfer cached = this.getCacheReference(resource);
        return cached.exists() || this.exister.exists(resource, cached, LocationUtils.getTimeoutSeconds(resource), this.getTransport(resource), suppressFailures);
    }

    @Override
    public List<ListingResult> listAll(VirtualResource virt) throws TransferException {
        return this.listAll(virt, new EventMetadata());
    }

    @Override
    public List<ListingResult> listAll(VirtualResource virt, final EventMetadata metadata) throws TransferException {
        HashMap<ConcreteResource, Future<ListingResult>> futureList = new HashMap<ConcreteResource, Future<ListingResult>>();
        for (final ConcreteResource res : virt) {
            Future<ListingResult> listingFuture = this.executorService.submit(new Callable<ListingResult>(){

                @Override
                public ListingResult call() throws TransferException {
                    return TransferManagerImpl.this.doList(res, true, metadata);
                }
            });
            futureList.put(res, listingFuture);
        }
        ArrayList<ListingResult> results = new ArrayList<ListingResult>();
        for (Map.Entry entry : futureList.entrySet()) {
            ListingResult listing;
            Future listingFuture = (Future)entry.getValue();
            ConcreteResource res = (ConcreteResource)entry.getKey();
            try {
                listing = (ListingResult)listingFuture.get();
            }
            catch (InterruptedException ex) {
                throw new TransferException("Listing of %s was interrupted", (Throwable)ex, res);
            }
            catch (ExecutionException ex) {
                throw new TransferException("Listing of %s threw an error: %s", (Throwable)ex, res, ex);
            }
            if (listing == null) continue;
            results.add(listing);
        }
        return results;
    }

    @Override
    public ListingResult list(ConcreteResource resource) throws TransferException {
        return this.list(resource, new EventMetadata());
    }

    @Override
    public ListingResult list(ConcreteResource resource, EventMetadata metadata) throws TransferException {
        return this.doList(resource, false, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListingResult doList(ConcreteResource resource, boolean suppressFailures, EventMetadata metadata) throws TransferException {
        Transport transport;
        int timeoutSeconds;
        ListingResult listingResult;
        Transfer cachedListing = this.getCacheReference(resource.getChild(".listing.txt"));
        HashSet<Object> filenames = new HashSet<Object>();
        if (cachedListing.exists()) {
            InputStream stream = null;
            try {
                stream = cachedListing.openInputStream();
                filenames.addAll(IOUtils.readLines(stream, "UTF-8"));
                Logger logger2 = LoggerFactory.getLogger(this.getClass());
                logger2.debug("Got cached listing:\n\n{}\n\n", (Object)filenames);
            }
            catch (IOException e) {
                throw new TransferException("Failed to read listing from cached file: %s. Reason: %s", (Throwable)e, cachedListing, e.getMessage());
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        Transfer cached = this.getCacheReference(resource);
        if (cached.exists()) {
            if (cached.isFile()) {
                throw new TransferException("Cannot list: {}. It does not appear to be a directory.", resource);
            }
            try {
                String[] fnames = cached.list();
                if (fnames != null && fnames.length > 0) {
                    for (String fname : fnames) {
                        if (metadata.get("storage-path") != null) {
                            filenames.add(fname);
                            continue;
                        }
                        ConcreteResource child = resource.getChild(fname);
                        Transfer childRef = this.getCacheReference(child);
                        if (childRef.isFile()) {
                            filenames.add(fname);
                            continue;
                        }
                        filenames.add((String)fname + "/");
                    }
                }
            }
            catch (IOException e) {
                throw new TransferException("Listing failed: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
            }
        }
        if (resource.getLocation().allowsDownloading() && (listingResult = this.lister.list(resource, cachedListing, timeoutSeconds = LocationUtils.getTimeoutSeconds(resource), transport = this.getTransport(resource), suppressFailures)) != null) {
            TransferDecorator decorator;
            Object[] remoteListing = listingResult.getListing();
            if (remoteListing != null && remoteListing.length > 0 && (decorator = cachedListing.getDecorator()) != null) {
                try {
                    Logger logger3 = LoggerFactory.getLogger(this.getClass());
                    logger3.debug("Un-decorated listing:\n\n{}\n\n", remoteListing);
                    remoteListing = decorator.decorateListing(cachedListing.getParent(), (String[])remoteListing, metadata);
                }
                catch (IOException e) {
                    this.logger.error("Failed to decorate directory listing for: {}. Reason: {}", e, resource, e.getMessage());
                    remoteListing = null;
                }
            }
            if (remoteListing != null && remoteListing.length > 0) {
                if (transport != null && transport.allowsCaching()) {
                    OutputStream stream = null;
                    try {
                        Logger logger2 = LoggerFactory.getLogger(this.getClass());
                        logger2.debug("Writing listing:\n\n{}\n\nto: {}", (Object)remoteListing, (Object)cachedListing);
                        stream = cachedListing.openOutputStream(TransferOperation.DOWNLOAD);
                        stream.write(StringUtils.join(remoteListing, "\n").getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        try {
                            this.logger.debug("Failed to store directory listing for: {}. Reason: {}", e, resource, e.getMessage());
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(stream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly(stream);
                    }
                    IOUtils.closeQuietly(stream);
                }
                filenames.addAll(Arrays.asList(remoteListing));
            }
        }
        Logger logger4 = LoggerFactory.getLogger(this.getClass());
        logger4.debug("Listing before non-listable file removal:\n\n{}\n\n", (Object)filenames);
        ArrayList<String> resultingNames = new ArrayList<String>(filenames.size());
        for (String string : filenames) {
            ConcreteResource child = resource.getChild(string);
            SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(child, metadata.getPackageType());
            if (specialPathInfo != null && !specialPathInfo.isListable()) continue;
            resultingNames.add(string);
        }
        logger4.debug("Final listing result:\n\n{}\n\n", (Object)resultingNames);
        return new ListingResult(resource, resultingNames.toArray(new String[resultingNames.size()]));
    }

    private Transport getTransport(ConcreteResource resource) throws TransferException {
        Transport transport = this.transportManager.getTransport(resource);
        if (transport == null && resource.getLocationUri() == null) {
            this.logger.debug("NFC: No remote URI. Marking as missing: {}", (Object)resource);
            this.nfc.addMissing(resource);
            return null;
        }
        return transport;
    }

    @Override
    public Transfer retrieveFirst(VirtualResource virt) throws TransferException {
        return this.retrieveFirst(virt, new EventMetadata());
    }

    @Override
    public Transfer retrieveFirst(VirtualResource virt, EventMetadata eventMetadata) throws TransferException {
        TransferException lastError = null;
        int tries = 0;
        for (ConcreteResource res : virt) {
            ++tries;
            if (res == null) continue;
            try {
                Transfer target = this.retrieve(res, true, eventMetadata);
                lastError = null;
                if (target == null || !target.exists()) continue;
                return target;
            }
            catch (TransferException e) {
                this.logger.warn("Failed to retrieve: {}. {} more tries. (Reason: {})", res, virt.toConcreteResources().size() - tries, e.getMessage());
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        this.fileEventManager.fire(new FileNotFoundEvent(virt, eventMetadata));
        return null;
    }

    @Override
    public List<Transfer> retrieveAll(VirtualResource virt) throws TransferException {
        return this.retrieveAll(virt, new EventMetadata());
    }

    @Override
    public List<Transfer> retrieveAll(VirtualResource virt, EventMetadata eventMetadata) throws TransferException {
        TransferBatch batch = new TransferBatch(Collections.singleton(virt));
        batch = this.batchRetrieveAll(batch, eventMetadata);
        return new ArrayList<Transfer>(batch.getTransfers().values());
    }

    @Override
    public Transfer retrieve(ConcreteResource resource) throws TransferException {
        return this.retrieve(resource, false, new EventMetadata());
    }

    @Override
    public Transfer retrieve(ConcreteResource resource, boolean suppressFailures) throws TransferException {
        return this.retrieve(resource, suppressFailures, new EventMetadata());
    }

    @Override
    public Transfer retrieve(ConcreteResource resource, boolean suppressFailures, EventMetadata eventMetadata) throws TransferException {
        Transfer target = null;
        try {
            target = this.getCacheReference(resource);
            if (target.exists()) {
                this.logger.debug("Using cached copy of: {}", (Object)target);
                return target;
            }
            SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(resource, eventMetadata.getPackageType());
            if (!resource.allowsDownloading() || specialPathInfo != null && !specialPathInfo.isRetrievable()) {
                this.logger.debug("Download not allowed for: {}. Returning null transfer.", (Object)resource);
                return null;
            }
            Transfer retrieved = this.downloader.download(resource, target, LocationUtils.getTimeoutSeconds(resource), this.getTransport(resource), suppressFailures, eventMetadata);
            if (retrieved != null && retrieved.exists() && !target.equals(retrieved) && (specialPathInfo == null || specialPathInfo.isCachable())) {
                this.cacheProvider.createAlias(retrieved.getResource(), target.getResource());
            }
            if (target.exists()) {
                this.logger.debug("DOWNLOADED: {}", (Object)resource);
                return target;
            }
            this.logger.debug("NOT DOWNLOADED: {}", (Object)resource);
            return null;
        }
        catch (TransferException e) {
            this.fileEventManager.fire(new FileErrorEvent(target, e, eventMetadata));
            throw e;
        }
        catch (IOException e) {
            TransferException error = new TransferException("Failed to download: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
            this.fileEventManager.fire(new FileErrorEvent(target, error, eventMetadata));
            throw error;
        }
    }

    @Override
    public Transfer store(ConcreteResource resource, InputStream stream) throws TransferException {
        return this.store(resource, stream, new EventMetadata());
    }

    @Override
    public Transfer store(ConcreteResource resource, InputStream stream, EventMetadata eventMetadata) throws TransferException {
        if (eventMetadata.get("storage-path") != null) {
            resource = ResourceUtils.storageResource(resource, eventMetadata);
        }
        SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(resource, eventMetadata.getPackageType());
        if (!resource.allowsStoring() || specialPathInfo != null && !specialPathInfo.isStorable()) {
            throw new TransferException("Storing not allowed for: {}", resource);
        }
        Transfer target = this.getCacheReference(resource);
        this.logger.info("STORE {}", (Object)target.getResource());
        OutputStream out = null;
        try {
            out = target.openOutputStream(TransferOperation.UPLOAD, true, eventMetadata);
            IOUtils.copy(stream, out);
            this.nfc.clearMissing(resource);
        }
        catch (IOException e) {
            try {
                throw new TransferException("Failed to store: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
        return target;
    }

    @Override
    public Transfer getStoreRootDirectory(Location key) {
        return this.cacheProvider.getTransfer(new ConcreteResource(key, new String[0]));
    }

    @Override
    public Transfer getCacheReference(ConcreteResource resource) {
        return this.cacheProvider.getTransfer(resource);
    }

    @Override
    public boolean deleteAll(VirtualResource virt) throws TransferException {
        return this.deleteAll(virt, new EventMetadata());
    }

    @Override
    public boolean deleteAll(VirtualResource virt, EventMetadata eventMetadata) throws TransferException {
        boolean result = false;
        for (ConcreteResource res : virt) {
            result = this.delete(res, new EventMetadata()) || result;
        }
        return result;
    }

    @Override
    public boolean delete(ConcreteResource resource) throws TransferException {
        return this.delete(resource, new EventMetadata());
    }

    @Override
    public boolean delete(ConcreteResource resource, EventMetadata eventMetadata) throws TransferException {
        if (!resource.allowsDeletion()) {
            throw new TransferException("Deletion not allowed for: {}", resource);
        }
        Transfer item = this.getCacheReference(resource);
        return this.doDelete(item, eventMetadata);
    }

    private Boolean doDelete(Transfer item, EventMetadata eventMetadata) throws TransferException {
        if (!item.exists()) {
            return false;
        }
        Logger contentLogger = LoggerFactory.getLogger("org.commonjava.topic.content.delete");
        contentLogger.info("BEGIN: Delete {} ({})", (Object)item.getResource(), (Object)eventMetadata);
        SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(item, eventMetadata.getPackageType());
        if (specialPathInfo != null && !specialPathInfo.isDeletable()) {
            throw new TransferException("Deleting not allowed for: %s", item);
        }
        if (item.isDirectory()) {
            String[] listing;
            try {
                listing = item.list();
            }
            catch (IOException e) {
                throw new TransferException("Delete failed: {}. Reason: cannot list directory due to: {}", (Throwable)e, item, e.getMessage());
            }
            for (String sub : listing) {
                if (this.doDelete(item.getChild(sub), eventMetadata).booleanValue()) continue;
                contentLogger.info("FAIL: Delete: {}", (Object)item.getResource());
                return false;
            }
        } else {
            try {
                if (!item.delete(true, eventMetadata)) {
                    throw new TransferException("Failed to delete: {}.", item);
                }
            }
            catch (IOException e) {
                throw new TransferException("Failed to delete stored location: {}. Reason: {}", (Throwable)e, item, e.getMessage());
            }
        }
        contentLogger.info("FINISH: Delete: {}", (Object)item.getResource());
        return true;
    }

    @Override
    public boolean publish(ConcreteResource resource, InputStream stream, long length) throws TransferException {
        return this.publish(resource, stream, length, new EventMetadata());
    }

    @Override
    public boolean publish(ConcreteResource resource, InputStream stream, long length, EventMetadata eventMetadata) throws TransferException {
        return this.publish(resource, stream, length, null, eventMetadata);
    }

    @Override
    public boolean publish(ConcreteResource resource, InputStream stream, long length, String contentType) throws TransferException {
        return this.publish(resource, stream, length, contentType, new EventMetadata());
    }

    @Override
    public boolean publish(ConcreteResource resource, InputStream stream, long length, String contentType, EventMetadata metadata) throws TransferException {
        SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(resource, metadata.getPackageType());
        if (specialPathInfo != null && !specialPathInfo.isPublishable()) {
            throw new TransferException("Publishing not allowed for: %s", resource);
        }
        return this.uploader.upload(resource, stream, length, contentType, LocationUtils.getTimeoutSeconds(resource), this.getTransport(resource));
    }

    @Override
    public <T extends TransferBatch> T batchRetrieve(T batch) throws TransferException {
        return this.batchRetrieve(batch, new EventMetadata());
    }

    @Override
    public <T extends TransferBatch> T batchRetrieve(T batch, EventMetadata eventMetadata) throws TransferException {
        return this.doBatch(batch.getResources(), batch, true, eventMetadata);
    }

    @Override
    public <T extends TransferBatch> T batchRetrieveAll(T batch) throws TransferException {
        return this.batchRetrieveAll(batch, new EventMetadata());
    }

    @Override
    public <T extends TransferBatch> T batchRetrieveAll(T batch, EventMetadata eventMetadata) throws TransferException {
        Set<Resource> resources = batch.getResources();
        for (Resource resource : new HashSet<Resource>(resources)) {
            if (!(resource instanceof VirtualResource)) continue;
            resources.remove(resource);
            for (Resource r : (VirtualResource)resource) {
                resources.add(r);
            }
        }
        return this.doBatch(resources, batch, false, eventMetadata);
    }

    private <T extends TransferBatch> T doBatch(Set<Resource> resources, T batch, boolean suppressFailures, EventMetadata eventMetadata) throws TransferException {
        this.logger.info("Attempting to batch-retrieve {} resources:\n  {}", (Object)resources.size(), (Object)new JoinString("\n  ", resources));
        HashSet<BatchRetriever> retrievers = new HashSet<BatchRetriever>(resources.size());
        for (Resource resource : resources) {
            retrievers.add(new BatchRetriever(this, resource, suppressFailures, eventMetadata));
        }
        HashMap<ConcreteResource, TransferException> errors = new HashMap<ConcreteResource, TransferException>();
        HashMap<ConcreteResource, Transfer> transfers = new HashMap<ConcreteResource, Transfer>();
        block4: do {
            for (BatchRetriever retriever : retrievers) {
                this.batchExecutor.submit(retriever);
            }
            int count = retrievers.size();
            for (int i = 0; i < count; ++i) {
                try {
                    Future<BatchRetriever> pending = this.batchExecutor.take();
                    BatchRetriever retriever = pending.get();
                    ConcreteResource resource = retriever.getLastTry();
                    TransferException error = retriever.getError();
                    if (error != null) {
                        this.logger.warn("ERROR: {}...{}", error, resource, error.getMessage());
                        retrievers.remove(retriever);
                        if (error instanceof TransferLocationException) continue;
                        errors.put(resource, error);
                        continue;
                    }
                    Transfer transfer = retriever.getTransfer();
                    if (transfer != null && transfer.exists()) {
                        transfers.put(resource, transfer);
                        retrievers.remove(retriever);
                        this.logger.debug("Completed: {}", (Object)resource);
                        continue;
                    }
                    if (retriever.hasMoreTries()) continue;
                    this.logger.debug("Not completed, but out of tries: {}", (Object)resource);
                    retrievers.remove(retriever);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.error(String.format("Failed to wait for batch retrieval attempts to complete: %s", e.getMessage()), e);
                    continue block4;
                }
                catch (ExecutionException e) {
                    this.logger.error(String.format("Failed to retrieve next completed retrieval: %s", e.getMessage()), e);
                }
            }
        } while (!retrievers.isEmpty());
        batch.setErrors(errors);
        batch.setTransfers(transfers);
        return batch;
    }
}

