/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.commonjava.maven.galley.GalleyCoreBuilder;
import org.commonjava.maven.galley.GalleyInitException;
import org.commonjava.maven.galley.TransferManager;
import org.commonjava.maven.galley.cache.CacheProviderFactory;
import org.commonjava.maven.galley.maven.ArtifactManager;
import org.commonjava.maven.galley.maven.ArtifactMetadataManager;
import org.commonjava.maven.galley.maven.GalleyMaven;
import org.commonjava.maven.galley.maven.internal.ArtifactManagerImpl;
import org.commonjava.maven.galley.maven.internal.ArtifactMetadataManagerImpl;
import org.commonjava.maven.galley.maven.internal.defaults.StandardMaven350PluginDefaults;
import org.commonjava.maven.galley.maven.internal.defaults.StandardMavenPluginImplications;
import org.commonjava.maven.galley.maven.internal.type.StandardTypeMapper;
import org.commonjava.maven.galley.maven.internal.version.VersionResolverImpl;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.parse.MavenMetadataReader;
import org.commonjava.maven.galley.maven.parse.MavenPomReader;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginDefaults;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginImplications;
import org.commonjava.maven.galley.maven.spi.type.TypeMapper;
import org.commonjava.maven.galley.maven.spi.version.VersionResolver;
import org.commonjava.maven.galley.spi.auth.PasswordManager;
import org.commonjava.maven.galley.spi.cache.CacheProvider;
import org.commonjava.maven.galley.spi.event.FileEventManager;
import org.commonjava.maven.galley.spi.io.PathGenerator;
import org.commonjava.maven.galley.spi.io.TransferDecorator;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.commonjava.maven.galley.spi.transport.LocationResolver;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.commonjava.maven.galley.spi.transport.TransportManager;

public class GalleyMavenBuilder {
    private final GalleyCoreBuilder coreBuilder;
    private ArtifactManager artifactManager;
    private ArtifactMetadataManager metadata;
    private TypeMapper mapper;
    private MavenPomReader pomReader;
    private MavenPluginDefaults pluginDefaults;
    private MavenPluginImplications pluginImplications;
    private XPathManager xpathManager;
    private XMLInfrastructure xmlInfra;
    private MavenMetadataReader metaReader;
    private VersionResolver versionResolver;

    public GalleyMavenBuilder() {
        this.coreBuilder = new GalleyCoreBuilder();
    }

    public GalleyMavenBuilder(CacheProvider cache) {
        this.coreBuilder = new GalleyCoreBuilder().withCache(cache);
    }

    public GalleyMavenBuilder(CacheProviderFactory cacheProviderFactory) {
        this.coreBuilder = new GalleyCoreBuilder(cacheProviderFactory);
    }

    public GalleyMaven build() throws GalleyInitException {
        this.initMissingComponents();
        return new GalleyMaven(this.coreBuilder.build(), this.artifactManager, this.metadata, this.mapper, this.pomReader, this.pluginDefaults, this.pluginImplications, this.xpathManager, this.xmlInfra, this.metaReader, this.versionResolver);
    }

    public void initMissingComponents() throws GalleyInitException {
        this.coreBuilder.initMissingComponents();
        if (this.mapper == null) {
            this.mapper = new StandardTypeMapper();
        }
        if (this.metadata == null) {
            this.metadata = new ArtifactMetadataManagerImpl(this.coreBuilder.getTransferManager(), this.coreBuilder.getLocationExpander());
        }
        if (this.xmlInfra == null) {
            this.xmlInfra = new XMLInfrastructure();
        }
        if (this.metaReader == null) {
            this.metaReader = new MavenMetadataReader(this.xmlInfra, this.coreBuilder.getLocationExpander(), this.metadata, this.xpathManager);
        }
        if (this.versionResolver == null) {
            this.versionResolver = new VersionResolverImpl(this.metaReader);
        }
        if (this.artifactManager == null) {
            this.artifactManager = new ArtifactManagerImpl(this.coreBuilder.getTransferManager(), this.coreBuilder.getLocationExpander(), this.mapper, this.versionResolver);
        }
        if (this.pluginDefaults == null) {
            this.pluginDefaults = new StandardMaven350PluginDefaults();
        }
        if (this.pluginImplications == null) {
            this.pluginImplications = new StandardMavenPluginImplications(this.xmlInfra);
        }
        if (this.xpathManager == null) {
            this.xpathManager = new XPathManager();
        }
        if (this.pomReader == null && this.artifactManager != null) {
            this.pomReader = new MavenPomReader(this.xmlInfra, this.coreBuilder.getLocationExpander(), this.artifactManager, this.xpathManager, this.pluginDefaults, this.pluginImplications);
        }
    }

    public ArtifactManager getArtifactManager() {
        return this.artifactManager;
    }

    public ArtifactMetadataManager getArtifactMetadataManager() {
        return this.metadata;
    }

    public GalleyMavenBuilder withArtifactManager(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
        return this;
    }

    public GalleyMavenBuilder withArtifactMetadataManager(ArtifactMetadataManager metadata) {
        this.metadata = metadata;
        return this;
    }

    public TypeMapper getTypeMapper() {
        return this.mapper;
    }

    public MavenPomReader getPomReader() {
        return this.pomReader;
    }

    public GalleyMavenBuilder withPomReader(MavenPomReader pomReader) {
        this.pomReader = pomReader;
        return this;
    }

    public MavenPluginDefaults getPluginDefaults() {
        return this.pluginDefaults;
    }

    public XPathManager getXPathManager() {
        return this.xpathManager;
    }

    public GalleyMavenBuilder withXPathManager(XPathManager xpathManager) {
        this.xpathManager = xpathManager;
        return this;
    }

    public XMLInfrastructure getXmlInfrastructure() {
        return this.xmlInfra;
    }

    public GalleyMavenBuilder withXmlInfrastructure(XMLInfrastructure xmlInfra) {
        this.xmlInfra = xmlInfra;
        return this;
    }

    public GalleyMavenBuilder withTypeMapper(TypeMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public GalleyMavenBuilder withPluginDefaults(MavenPluginDefaults pluginDefaults) {
        this.pluginDefaults = pluginDefaults;
        return this;
    }

    public MavenPluginImplications getPluginImplications() {
        return this.pluginImplications;
    }

    public GalleyMavenBuilder withPluginImplications(MavenPluginImplications pluginImplications) {
        this.pluginImplications = pluginImplications;
        return this;
    }

    public MavenMetadataReader getMavenMetadataReader() {
        return this.metaReader;
    }

    public VersionResolver getVersionResolver() {
        return this.versionResolver;
    }

    public GalleyMavenBuilder withMavenMetadataReader(MavenMetadataReader metaReader) {
        this.metaReader = metaReader;
        return this;
    }

    public GalleyMavenBuilder withVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = versionResolver;
        return this;
    }

    public LocationExpander getLocationExpander() {
        return this.coreBuilder.getLocationExpander();
    }

    public LocationResolver getLocationResolver() {
        return this.coreBuilder.getLocationResolver();
    }

    public TransferDecorator getTransferDecorator() {
        return this.coreBuilder.getTransferDecorator();
    }

    public FileEventManager getFileEvents() {
        return this.coreBuilder.getFileEvents();
    }

    public CacheProvider getCache() {
        return this.coreBuilder.getCache();
    }

    public NotFoundCache getNfc() {
        return this.coreBuilder.getNfc();
    }

    public GalleyMavenBuilder withLocationExpander(LocationExpander locationExpander) {
        this.coreBuilder.withLocationExpander(locationExpander);
        return this;
    }

    public GalleyMavenBuilder withLocationResolver(LocationResolver locationResolver) {
        this.coreBuilder.withLocationResolver(locationResolver);
        return this;
    }

    public GalleyMavenBuilder withTransferDecorator(TransferDecorator decorator) {
        this.coreBuilder.withTransferDecorator(decorator);
        return this;
    }

    public GalleyMavenBuilder withFileEvents(FileEventManager events) {
        this.coreBuilder.withFileEvents(events);
        return this;
    }

    public GalleyMavenBuilder withCache(CacheProvider cache) {
        this.coreBuilder.withCache(cache);
        return this;
    }

    public GalleyMavenBuilder withNfc(NotFoundCache nfc) {
        this.coreBuilder.withNfc(nfc);
        return this;
    }

    public TransportManager getTransportManager() {
        return this.coreBuilder.getTransportManager();
    }

    public TransferManager getTransferManager() {
        return this.coreBuilder.getTransferManager();
    }

    public GalleyMavenBuilder withTransportManager(TransportManager transportManager) {
        this.coreBuilder.withTransportManager(transportManager);
        return this;
    }

    public GalleyMavenBuilder withTransferManager(TransferManager transferManager) {
        this.coreBuilder.withTransferManager(transferManager);
        return this;
    }

    public List<Transport> getEnabledTransports() {
        return this.coreBuilder.getEnabledTransports();
    }

    public GalleyMavenBuilder withEnabledTransports(List<Transport> transports) {
        this.coreBuilder.withEnabledTransports(transports);
        return this;
    }

    public GalleyMavenBuilder withEnabledTransports(Transport ... transports) {
        this.coreBuilder.withEnabledTransports(transports);
        return this;
    }

    public ExecutorService getHandlerExecutor() {
        return this.coreBuilder.getHandlerExecutor();
    }

    public GalleyMavenBuilder withHandlerExecutor(ExecutorService handlerExecutor) {
        this.coreBuilder.withHandlerExecutor(handlerExecutor);
        return this;
    }

    public ExecutorService getBatchExecutor() {
        return this.coreBuilder.getBatchExecutor();
    }

    public GalleyMavenBuilder withBatchExecutor(ExecutorService batchExecutor) {
        this.coreBuilder.withBatchExecutor(batchExecutor);
        return this;
    }

    public PasswordManager getPasswordManager() {
        return this.coreBuilder.getPasswordManager();
    }

    public GalleyMavenBuilder withPasswordManager(PasswordManager passwordManager) {
        this.coreBuilder.withPasswordManager(passwordManager);
        return this;
    }

    public GalleyMavenBuilder withAdditionalTransport(Transport transport) {
        this.coreBuilder.withAdditionalTransport(transport);
        return this;
    }

    public PathGenerator getPathGenerator() {
        return this.coreBuilder.getPathGenerator();
    }

    public GalleyMavenBuilder withPathGenerator(PathGenerator pathGenerator) {
        this.coreBuilder.withPathGenerator(pathGenerator);
        return this;
    }

    public GalleyMavenBuilder withCacheProviderFactory(CacheProviderFactory cacheProviderFactory) {
        this.coreBuilder.withCacheProviderFactory(cacheProviderFactory);
        return this;
    }

    public CacheProviderFactory getCacheProviderFactory() {
        return this.coreBuilder.getCacheProviderFactory();
    }
}

