/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.commonjava.maven.galley.BadGatewayException;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.TransferLocationException;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransferResponseUtils {
    private static final Set<Integer> NON_SERVER_GATEWAY_ERRORS = Collections.unmodifiableSet(new HashSet<Integer>(Collections.singletonList(410)));

    private TransferResponseUtils() {
    }

    public static boolean handleUnsuccessfulResponse(HttpUriRequest request, CloseableHttpResponse response, HttpLocation location, String url) throws TransferException {
        return TransferResponseUtils.handleUnsuccessfulResponse(request, response, location, url, true);
    }

    public static boolean handleUnsuccessfulResponse(HttpUriRequest request, CloseableHttpResponse response, HttpLocation location, String url, boolean graceful404) throws TransferException {
        Logger logger2 = LoggerFactory.getLogger(TransferResponseUtils.class);
        StatusLine line = response.getStatusLine();
        InputStream in = null;
        HttpEntity entity = null;
        try {
            boolean contentMissing;
            entity = response.getEntity();
            int sc = line.getStatusCode();
            boolean bl = contentMissing = sc == 404 || sc == 410;
            if (graceful404 && contentMissing) {
                boolean bl2 = false;
                return bl2;
            }
            try {
                ByteArrayOutputStream out = null;
                if (entity != null) {
                    in = entity.getContent();
                    out = new ByteArrayOutputStream();
                    IOUtils.copy(in, (OutputStream)out);
                }
                if (NON_SERVER_GATEWAY_ERRORS.contains(sc) || sc > 499 && sc < 599) {
                    throw new BadGatewayException((Location)location, url, sc, "HTTP request failed: %s%s", line, out == null ? "" : "\n\n" + new String(out.toByteArray()));
                }
                if (contentMissing) {
                    throw new TransferException("HTTP request failed: %s\nURL: %s%s", line, url, out == null ? "" : "\n\n" + new String(out.toByteArray()));
                }
                throw new TransferLocationException((Location)location, "HTTP request failed: %s%s", line, out == null ? "" : "\n\n" + new String(out.toByteArray()));
            }
            catch (IOException e) {
                request.abort();
                throw new TransferLocationException((Location)location, "Error reading body of unsuccessful request.\nStatus: %s.\nURL: %s.\nReason: %s", e, line, url, e.getMessage());
            }
        }
        finally {
            IOUtils.closeQuietly(in);
            if (entity != null) {
                try {
                    EntityUtils.consume(entity);
                }
                catch (IOException e) {
                    logger2.debug("Failed to consume entity: " + e.getMessage(), e);
                }
            }
        }
    }
}

