/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.core.processingstrategies;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.ArtifactResult;
import org.jboss.set.mavendependencyupdater.ComponentUpgrade;
import org.jboss.set.mavendependencyupdater.PomDependencyUpdater;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.configuration.GitConfigurationModel;
import org.jboss.set.mavendependencyupdater.configuration.GitHubConfigurationModel;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.PatchDigestRecorder;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.UpgradeProcessingStrategy;
import org.jboss.set.mavendependencyupdater.git.GitRepository;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class SeparatePRsProcessingStrategy
implements UpgradeProcessingStrategy {
    private static final Logger LOG = Logger.getLogger(SeparatePRsProcessingStrategy.class);
    private static final String PR_DESCRIPTION = "New version of dependency %s:%s was found.\n\n(This pull request was automatically generated.)";
    private static final String POM_XML = "pom.xml";
    private final Configuration configuration;
    private final File pomFile;
    private final GitRepository gitRepository;
    private final GitHub gitHub;
    private final PatchDigestRecorder digestRecorder = new PatchDigestRecorder();

    public SeparatePRsProcessingStrategy(Configuration configuration, File pomFile) {
        this.configuration = configuration;
        this.pomFile = pomFile;
        File gitDir = new File(pomFile.getParent(), ".git");
        try {
            this.gitRepository = new GitRepository(gitDir, configuration.getGitHub().getAccessToken());
        }
        catch (IOException e) {
            throw new RuntimeException("Failure when reading git repository: " + gitDir, e);
        }
        try {
            GitHubConfigurationModel ghConfig = configuration.getGitHub();
            this.gitHub = GitHub.connect(ghConfig.getLogin(), ghConfig.getAccessToken());
        }
        catch (IOException e) {
            throw new RuntimeException("Can't connect to GitHub account", e);
        }
    }

    public SeparatePRsProcessingStrategy(Configuration configuration, File pomFile, GitRepository gitRepository, GitHub gitHub) {
        this.configuration = configuration;
        this.pomFile = pomFile;
        this.gitRepository = gitRepository;
        this.gitHub = gitHub;
    }

    @Override
    public boolean process(List<ArtifactResult<ComponentUpgrade>> upgrades) {
        boolean result = true;
        for (ArtifactResult<ComponentUpgrade> upgrade : upgrades) {
            if (!upgrade.getLatestConfigured().isPresent()) continue;
            boolean partialResult = this.createPRForUpgrade(upgrade.getLatestConfigured().get());
            result = partialResult && result;
        }
        return result;
    }

    protected boolean createPRForUpgrade(ComponentUpgrade componentUpgrade) {
        ArtifactRef artifact = componentUpgrade.getArtifact();
        String newVersion = componentUpgrade.getNewVersion();
        String baseBranch = this.configuration.getGit().getBaseBranch();
        String workingBranch = this.getBranchName(artifact, newVersion);
        String commitMessage = this.getCommitMessage(artifact, newVersion);
        GitConfigurationModel gitConfig = this.configuration.getGit();
        GitHubConfigurationModel ghConfig = this.configuration.getGitHub();
        try {
            GHRepository repo = this.gitHub.getRepository(ghConfig.getUpstreamRepository());
            String remoteRef = "refs/remotes/" + gitConfig.getRemote() + "/" + workingBranch;
            if (this.gitRepository.getRemoteBranches().contains(remoteRef)) {
                LOG.infof("Remote branch '%s' already exists, skipping this upgrade`.", (Object)workingBranch);
                boolean bl = true;
                return bl;
            }
            Optional<GHPullRequest> existingPR = SeparatePRsProcessingStrategy.findOpenPRByTitle(repo, commitMessage);
            if (existingPR.isPresent()) {
                LOG.infof("PR already exists, skipping this upgrade: %s", (Object)existingPR.get().getHtmlUrl());
                boolean e = true;
                return e;
            }
            this.gitRepository.checkout(baseBranch);
            PomDependencyUpdater.upgradeDependencies(this.pomFile, Collections.singletonList(componentUpgrade));
            Pair<ArtifactRef, String> previousUpgrade = this.digestRecorder.recordPatchDigest(this.pomFile, artifact, newVersion);
            if (previousUpgrade != null) {
                LOG.infof("Patch for %s:%s:%s is identical to already created patch for %s:%s:%s, skipping PR creation.", artifact.getGroupId(), artifact.getArtifactId(), newVersion, previousUpgrade.getLeft().getGroupId(), previousUpgrade.getLeft().getArtifactId(), previousUpgrade.getRight());
                this.gitRepository.resetLocalChanges();
                boolean e = true;
                return e;
            }
            this.gitRepository.checkout(workingBranch, true);
            this.gitRepository.add(POM_XML);
            this.gitRepository.commit(commitMessage);
            this.gitRepository.push(gitConfig.getRemote(), workingBranch);
            String sourceBranch = SeparatePRsProcessingStrategy.getSourceBranch(ghConfig.getOriginRepository(), workingBranch);
            String upstreamBaseBranch = ghConfig.getUpstreamBaseBranch();
            String title = commitMessage;
            String description = String.format(PR_DESCRIPTION, artifact.getGroupId(), artifact.getArtifactId());
            GHPullRequest pr = repo.createPullRequest(title, sourceBranch, upstreamBaseBranch, description);
            System.out.println(pr.getHtmlUrl());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException("PR creation failed", e);
        }
        finally {
            try {
                this.gitRepository.checkout(baseBranch);
            }
            catch (GitAPIException e) {
                LOG.errorf("Failed to checkout base branch: %s", (Object)baseBranch);
            }
        }
    }

    protected String getBranchName(ArtifactRef artifact, String newVersion) {
        return "upgrade_" + artifact.getGroupId() + "_" + artifact.getArtifactId() + "_" + newVersion;
    }

    protected String getCommitMessage(ArtifactRef artifact, String newVersion) {
        return String.format("Upgrade %s:%s from %s to %s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersionString(), newVersion);
    }

    private static Optional<GHPullRequest> findOpenPRByTitle(GHRepository repo, String title) throws IOException {
        List<GHPullRequest> pullRequests = repo.getPullRequests(GHIssueState.OPEN);
        for (GHPullRequest pr : pullRequests) {
            if (!pr.getTitle().equals(title)) continue;
            return Optional.of(pr);
        }
        return Optional.empty();
    }

    private static String getSourceBranch(String originRepository, String branch) {
        String[] origin = originRepository.split("/");
        return origin[0] + ":" + branch;
    }
}

