/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64InputStream;
import org.kohsuke.github.GitHub;

public class GHBlob {
    private String content;
    private String encoding;
    private String url;
    private String sha;
    private long size;

    public URL getUrl() {
        return GitHub.parseURL(this.url);
    }

    public String getSha() {
        return this.sha;
    }

    public long getSize() {
        return this.size;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getContent() {
        return this.content;
    }

    public InputStream read() {
        if (this.encoding.equals("base64")) {
            try {
                return new Base64InputStream(new ByteArrayInputStream(this.content.getBytes("US-ASCII")), false);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new UnsupportedOperationException("Unrecognized encoding: " + this.encoding);
    }
}

