/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.AvailableVersionsResolver;
import org.jboss.set.mavendependencyupdater.VersionStream;
import org.jboss.set.mavendependencyupdater.common.ident.ScopedArtifactRef;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.loggerclient.ComponentUpgradeDTO;
import org.jboss.set.mavendependencyupdater.loggerclient.LoggerClient;
import org.jboss.set.mavendependencyupdater.loggerclient.UpgradeNotFoundException;
import org.jboss.set.mavendependencyupdater.rules.NeverRestriction;
import org.jboss.set.mavendependencyupdater.rules.Restriction;
import org.jboss.set.mavendependencyupdater.rules.TokenizedVersion;
import org.jboss.set.mavendependencyupdater.rules.VersionPrefixRestriction;
import org.jboss.set.mavendependencyupdater.rules.VersionStreamRestriction;

public class DependencyEvaluator {
    private static final Logger LOG = Logger.getLogger(DependencyEvaluator.class);
    private static final VersionStreamRestriction DEFAULT_STREAM_RESTRICTION = new VersionStreamRestriction(VersionStream.MICRO);
    private final Configuration configuration;
    private final AvailableVersionsResolver availableVersionsResolver;
    private final LoggerClient loggerClient;
    private boolean configUpToDate;

    public DependencyEvaluator(Configuration configuration, AvailableVersionsResolver availableVersionsResolver, LoggerClient loggerClient) {
        this.configuration = configuration;
        this.availableVersionsResolver = availableVersionsResolver;
        this.loggerClient = loggerClient;
    }

    public List<ComponentUpgrade> getVersionsToUpgrade(Collection<ScopedArtifactRef> dependencies) {
        ArrayList<ComponentUpgrade> versionsToUpgrade = new ArrayList<ComponentUpgrade>();
        this.configUpToDate = true;
        for (ScopedArtifactRef dep : dependencies) {
            Artifact rangeArtifact = DependencyEvaluator.toVersionRangeArtifact((ArtifactRef)dep);
            if (dep.getVersionString().startsWith("$")) {
                LOG.warnf("Skipping dependency '%s', should this be resolved?", (Object)dep);
                continue;
            }
            if (this.configuration.getIgnoreScopes().contains(dep.getScope())) {
                LOG.debugf("Skipping dependency '%s', scope '%s' is ignored", (Object)dep, (Object)dep.getScope());
                continue;
            }
            try {
                List<Restriction> restrictions = this.configuration.getRestrictionsFor(dep.getGroupId(), dep.getArtifactId());
                VersionRangeResult versionRangeResult = this.availableVersionsResolver.resolveVersionRange(rangeArtifact);
                Optional<Version> latest = this.findLatest(dep, restrictions, versionRangeResult.getVersions());
                LOG.debugf("Available versions for '%s': %s", (Object)dep, (Object)versionRangeResult);
                if (latest.isPresent() && !dep.getVersionString().equals(latest.get().toString())) {
                    String latestVersion = latest.get().toString();
                    String repoId = versionRangeResult.getRepository(latest.get()).getId();
                    LOG.infof("Found possible upgrade of '%s' to '%s' in repo '%s'", (Object)dep, (Object)latestVersion, (Object)repoId);
                    LocalDateTime firstSeen = this.findComponentUpgradeDate(dep, latestVersion);
                    versionsToUpgrade.add(new ComponentUpgrade((ArtifactRef)dep, latestVersion, repoId, firstSeen));
                    continue;
                }
                LOG.debugf("  => no change", new Object[0]);
            }
            catch (RepositoryException e) {
                LOG.errorf("Could not resolve '%s'", (Object)rangeArtifact.toString());
            }
        }
        if (!this.configUpToDate) {
            LOG.warn((Object)"Configuration not up to date. Check the warnings above.");
        }
        this.sendDetectedUpgradesToExternalService(versionsToUpgrade);
        return versionsToUpgrade;
    }

    private static Artifact toVersionRangeArtifact(ArtifactRef ref) {
        return new DefaultArtifact(ref.getGroupId(), ref.getArtifactId(), null, "[" + ref.getVersionString() + ",)");
    }

    Optional<Version> findLatest(ScopedArtifactRef dependency, List<Restriction> restrictions, List<Version> availableVersions) {
        VersionPrefixRestriction prefixRestriction;
        if (restrictions.stream().anyMatch(r -> r instanceof NeverRestriction)) {
            return Optional.empty();
        }
        Optional<Restriction> prefixRestrictionOptional = restrictions.stream().filter(r -> r instanceof VersionPrefixRestriction).findFirst();
        boolean restrictedPrefix = prefixRestrictionOptional.isPresent();
        boolean restrictedStream = restrictions.stream().anyMatch(r -> r instanceof VersionStreamRestriction);
        if (restrictedPrefix && !(prefixRestriction = (VersionPrefixRestriction)prefixRestrictionOptional.get()).applies(dependency.getVersionString(), dependency.getVersionString())) {
            LOG.warnf("Existing dependency '%s' doesn't match configured prefix: '%s'", (Object)dependency, (Object)prefixRestriction.getPrefixString());
            this.configUpToDate = false;
            return Optional.empty();
        }
        Stream<Object> workingStream = availableVersions.stream();
        if (!restrictedPrefix && !restrictedStream) {
            workingStream = workingStream.filter(v -> DEFAULT_STREAM_RESTRICTION.applies(v.toString(), dependency.getVersionString()));
        }
        for (Restriction restriction : restrictions) {
            workingStream = workingStream.filter(v -> restriction.applies(v.toString(), dependency.getVersionString()));
        }
        return workingStream.max(Comparator.comparing(v -> TokenizedVersion.parse(v.toString())));
    }

    LocalDateTime findComponentUpgradeDate(ScopedArtifactRef dep, String newVersion) {
        if (this.loggerClient != null) {
            try {
                ComponentUpgradeDTO componentUpgrade = this.loggerClient.getFirst(this.configuration.getLogger().getProjectCode(), dep.getGroupId(), dep.getArtifactId(), newVersion);
                if (componentUpgrade != null) {
                    LOG.infof("Component upgrade to %s:%s:%s already seen at %s", new Object[]{dep.getGroupId(), dep.getArtifactId(), newVersion, componentUpgrade.created});
                    return componentUpgrade.created;
                }
            }
            catch (UpgradeNotFoundException e) {
                LOG.infof("Component upgrade to %s:%s:%s was not previously recorded", (Object)dep.getGroupId(), (Object)dep.getArtifactId(), (Object)newVersion);
            }
        }
        return null;
    }

    void sendDetectedUpgradesToExternalService(List<ComponentUpgrade> componentUpgrades) {
        if (this.loggerClient == null) {
            LOG.info((Object)"Logger not configured. Discovered component upgrades will not be recorded.");
            return;
        }
        LOG.infof("Recording %d component upgrades under project '%s'", (Object)componentUpgrades.size(), (Object)this.configuration.getLogger().getProjectCode());
        int batchSize = 30;
        int fromIndex = 0;
        do {
            int toIndex = Math.min(componentUpgrades.size(), fromIndex + 30);
            List dtos = componentUpgrades.subList(fromIndex, toIndex).stream().map(u -> DependencyEvaluator.convertToDTO(this.configuration.getLogger().getProjectCode(), u)).collect(Collectors.toList());
            if (LOG.isEnabled(Logger.Level.DEBUG)) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String json = objectMapper.writeValueAsString(dtos);
                    LOG.debugf("Sending detected upgrades to %s (json length: %d):\n%s", (Object)this.configuration.getLogger().getUri(), (Object)json.length(), (Object)json);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
            this.loggerClient.create(dtos);
        } while ((fromIndex += 30) < componentUpgrades.size());
    }

    static ComponentUpgradeDTO convertToDTO(String projectCode, ComponentUpgrade componentUpgrade) {
        return new ComponentUpgradeDTO(projectCode, componentUpgrade.getArtifact().getGroupId(), componentUpgrade.getArtifact().getArtifactId(), componentUpgrade.artifact.getVersionString(), componentUpgrade.newVersion, null);
    }

    public static class ComponentUpgrade {
        private final ArtifactRef artifact;
        private final String newVersion;
        private final String repository;
        private final LocalDateTime firstSeen;

        public ComponentUpgrade(ArtifactRef artifact, String newVersion, String repository, LocalDateTime firstSeen) {
            this.artifact = artifact;
            this.newVersion = newVersion;
            this.repository = repository;
            this.firstSeen = firstSeen;
        }

        public ComponentUpgrade(ArtifactRef artifact, String newVersion, String repository) {
            this(artifact, newVersion, repository, null);
        }

        public ArtifactRef getArtifact() {
            return this.artifact;
        }

        public String getNewVersion() {
            return this.newVersion;
        }

        public String getRepository() {
            return this.repository;
        }

        public LocalDateTime getFirstSeen() {
            return this.firstSeen;
        }

        public String toString() {
            return this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + ":" + this.artifact.getVersionString() + " -> " + this.newVersion;
        }
    }
}

