/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.jboss.set.mavendependencyupdater.VersionStream;
import org.jboss.set.mavendependencyupdater.common.ident.ScopedArtifactRef;
import org.jboss.set.mavendependencyupdater.configuration.ConfigurationModel;
import org.jboss.set.mavendependencyupdater.configuration.GitConfigurationModel;
import org.jboss.set.mavendependencyupdater.configuration.GitHubConfigurationModel;
import org.jboss.set.mavendependencyupdater.configuration.LoggerModel;
import org.jboss.set.mavendependencyupdater.rules.IgnoreRestriction;
import org.jboss.set.mavendependencyupdater.rules.NeverRestriction;
import org.jboss.set.mavendependencyupdater.rules.QualifierRestriction;
import org.jboss.set.mavendependencyupdater.rules.Restriction;
import org.jboss.set.mavendependencyupdater.rules.VersionPrefixRestriction;
import org.jboss.set.mavendependencyupdater.rules.VersionStreamRestriction;

public class Configuration {
    private static final String WILDCARD = "*";
    public static final String QUALIFIER = "QUALIFIER";
    public static final String PREFIX = "PREFIX";
    public static final String STREAM = "STREAM";
    public static final String COMMENT = "COMMENT";
    public static final String NEVER = "NEVER";
    public static final String IGNORE = "IGNORE";
    private final Map<String, Map<String, List<Restriction>>> restrictions = new HashMap<String, Map<String, List<Restriction>>>();
    private final List<String> ignoreScopes = new ArrayList<String>();
    private final GitHubConfigurationModel gitHub;
    private final GitConfigurationModel git;
    private final LoggerModel logger;
    private final Map<String, String> repositories = new LinkedHashMap<String, String>();

    public Configuration(File file) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ConfigurationModel data = file != null ? (ConfigurationModel)mapper.readValue(file, ConfigurationModel.class) : new ConfigurationModel();
        this.gitHub = data.getGitHub();
        this.git = data.getGit();
        this.logger = data.getLogger();
        if (data.getRepositories() != null) {
            this.repositories.putAll(data.getRepositories());
        } else {
            this.repositories.put("Central", "https://repo1.maven.org/maven2/");
        }
        if (data.getIgnoreScopes() != null) {
            this.ignoreScopes.addAll(data.getIgnoreScopes());
        }
        if (data.getRules() != null) {
            for (Map.Entry<String, Object> gaEntry : data.getRules().entrySet()) {
                String ga = gaEntry.getKey();
                if (gaEntry.getValue() instanceof String) {
                    if (NEVER.equals(gaEntry.getValue())) {
                        this.addRestriction(ga, NeverRestriction.INSTANCE);
                        continue;
                    }
                    this.addRestriction(ga, new VersionStreamRestriction(VersionStream.valueOf((String)gaEntry.getValue())));
                    continue;
                }
                if (!(gaEntry.getValue() instanceof Map)) continue;
                Map configMap = (Map)gaEntry.getValue();
                if (configMap.containsKey(PREFIX) && configMap.containsKey(STREAM)) {
                    throw new IllegalArgumentException("Only one of STREAM and PREFIX keys can be defined for " + ga);
                }
                for (Map.Entry restrictionEntry : configMap.entrySet()) {
                    String restrictionName = (String)restrictionEntry.getKey();
                    Object restrictionConfig = restrictionEntry.getValue();
                    try {
                        switch (restrictionName) {
                            case "PREFIX": {
                                this.addRestriction(ga, new VersionPrefixRestriction((String)restrictionConfig));
                                break;
                            }
                            case "QUALIFIER": {
                                this.addRestriction(ga, new QualifierRestriction(Configuration.readSingleStringOrArray(restrictionConfig)));
                                break;
                            }
                            case "IGNORE": {
                                this.addRestriction(ga, new IgnoreRestriction(Configuration.readSingleStringOrArray(restrictionConfig)));
                                break;
                            }
                            case "STREAM": {
                                if (!(restrictionConfig instanceof String)) {
                                    throw new IllegalArgumentException(String.format("String expected, %s given.", restrictionConfig.getClass().getName()));
                                }
                                this.addRestriction(ga, new VersionStreamRestriction(VersionStream.valueOf((String)restrictionConfig)));
                                break;
                            }
                            case "COMMENT": {
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown rule.");
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(String.format("Configuration exception for rule %s:%s: %s", ga, restrictionName, e.getMessage()), e);
                    }
                }
            }
        }
    }

    public List<Restriction> getRestrictionsFor(String g, String a) {
        return Configuration.findConfigForGA(this.restrictions, g, a, Collections.emptyList());
    }

    public <T extends Restriction> Optional<T> getRestrictionFor(String g, String a, Class<T> restrictionClass) {
        List restrictions = Configuration.findConfigForGA(this.restrictions, g, a, Collections.emptyList());
        return restrictions.stream().filter(r -> r.getClass().isAssignableFrom(restrictionClass)).map(r -> r).findFirst();
    }

    public List<String> getIgnoreScopes() {
        return this.ignoreScopes;
    }

    public Collection<Pair<ScopedArtifactRef, String>> findOutOfDateRestrictions(Collection<ScopedArtifactRef> currentDependencies) {
        HashSet<Pair<ScopedArtifactRef, String>> outOfDate = new HashSet<Pair<ScopedArtifactRef, String>>();
        for (ScopedArtifactRef ref : currentDependencies) {
            Optional<VersionPrefixRestriction> prefixRestriction;
            if (this.getIgnoreScopes().contains(ref.getScope()) || !(prefixRestriction = this.getRestrictionFor(ref.getGroupId(), ref.getArtifactId(), VersionPrefixRestriction.class)).isPresent() || prefixRestriction.get().applies(ref.getVersionString(), ref.getVersionString())) continue;
            String prefixString = prefixRestriction.get().getPrefixString();
            outOfDate.add((Pair<ScopedArtifactRef, String>)Pair.of((Object)ref, (Object)prefixString));
        }
        return outOfDate;
    }

    public GitHubConfigurationModel getGitHub() {
        return this.gitHub;
    }

    public GitConfigurationModel getGit() {
        return this.git;
    }

    public LoggerModel getLogger() {
        return this.logger;
    }

    public Map<String, String> getRepositories() {
        return this.repositories;
    }

    private void addRestriction(String ga, Restriction restriction) {
        String[] coord = ga.split(":");
        if (coord.length != 2) {
            throw new IllegalArgumentException("Invalid rules ga: " + ga);
        }
        String g = coord[0];
        String a = coord[1];
        Map groupRestrictions = this.restrictions.computeIfAbsent(g, k -> new HashMap());
        List restrictions = groupRestrictions.computeIfAbsent(a, k -> new ArrayList());
        restrictions.add(restriction);
    }

    private static <T> T findConfigForGA(Map<String, Map<String, T>> streams, String g, String a, T defaultValue) {
        if (streams.containsKey(g)) {
            if (streams.get(g).containsKey(a)) {
                return streams.get(g).get(a);
            }
            if (streams.get(g).containsKey(WILDCARD)) {
                return streams.get(g).get(WILDCARD);
            }
        }
        for (Map.Entry<String, Map<String, T>> entry : streams.entrySet()) {
            String group = entry.getKey();
            Map<String, T> groupRules = entry.getValue();
            if (group.equals(WILDCARD) || !group.endsWith(WILDCARD)) continue;
            String groupPrefix = group.substring(0, group.length() - 1);
            if (g.startsWith(groupPrefix) && groupRules.containsKey(a)) {
                return groupRules.get(a);
            }
            if (!g.startsWith(groupPrefix) || !groupRules.containsKey(WILDCARD)) continue;
            return groupRules.get(WILDCARD);
        }
        if (streams.containsKey(WILDCARD)) {
            if (streams.get(WILDCARD).containsKey(a)) {
                return streams.get(WILDCARD).get(a);
            }
            if (streams.get(WILDCARD).containsKey(WILDCARD)) {
                return streams.get(WILDCARD).get(WILDCARD);
            }
        }
        return defaultValue;
    }

    private static String[] readSingleStringOrArray(Object restrictionObject) {
        String[] result;
        if (restrictionObject instanceof String) {
            result = new String[]{(String)restrictionObject};
        } else if (restrictionObject instanceof List) {
            String[] stringArray = new String[((List)restrictionObject).size()];
            result = ((List)restrictionObject).toArray(stringArray);
        } else {
            throw new IllegalArgumentException("String or list of strings expected.");
        }
        return result;
    }
}

