/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.bugzilla;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcCommonsTransport;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransport;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.Comment;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.IssueStatus;
import org.jboss.set.aphrodite.domain.SearchCriteria;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.BugzillaFields;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.BugzillaQueryBuilder;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.IssueWrapper;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class BugzillaClient {
    private static final Log LOG = LogFactory.getLog(BugzillaClient.class);
    static final Pattern ID_PARAM_PATTERN = Pattern.compile("id=([^&]+)");
    static final Pattern FILTER_NAME_PARAM_PATTERN = Pattern.compile("namedcmd=([^&]+)");
    static final Pattern SHARER_ID_PARAM_PATTERN = Pattern.compile("sharer_id=([^&]+)");
    private final ExecutorService executorService;
    private final IssueWrapper WRAPPER = new IssueWrapper();
    private final URL baseURL;
    private final String apiKey;

    public BugzillaClient(URL baseURL, String apiKey, ExecutorService executorService) throws IllegalStateException {
        this.baseURL = baseURL;
        this.apiKey = apiKey;
        this.executorService = executorService;
    }

    public Issue getIssue(String trackerId) throws NotFoundException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("include_fields", BugzillaFields.RESULT_FIELDS);
        params.put("ids", trackerId);
        params.put("permissive", true);
        Map<String, Object> resultMap = this.executeRequest(XMLRPC.RPC_STRUCT, "Bug.get", params);
        Object[] bugs = (Object[])resultMap.get("bugs");
        if (bugs.length == 1) {
            Map results = (Map)bugs[0];
            results.putIfAbsent("cf_type", "UNDEFINED");
            return this.WRAPPER.bugzillaBugToIssue(results, this.baseURL);
        }
        Utils.logWarnMessage((Log)LOG, (String)("Zero or more than one bug found with id: " + trackerId));
        throw new NotFoundException("No issues found with id: " + trackerId);
    }

    public List<Issue> getIssues(Collection<URL> urls) {
        ArrayList<String> ids = new ArrayList<String>();
        for (URL url : urls) {
            try {
                ids.add(Utils.getParamaterFromUrl((Pattern)ID_PARAM_PATTERN, (URL)url));
            }
            catch (NotFoundException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("Unable to extract trackerId from: " + url));
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("include_fields", BugzillaFields.RESULT_FIELDS);
        params.put("ids", ids.toArray());
        params.put("permissive", true);
        Map<String, Object> resultMap = this.executeRequest(XMLRPC.RPC_STRUCT, "Bug.get", params);
        Object[] bugs = (Object[])resultMap.get("bugs");
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Object bugObject : bugs) {
            Map bug = (Map)bugObject;
            issues.add(this.WRAPPER.bugzillaBugToIssue(bug, this.baseURL));
        }
        return issues;
    }

    public Issue getIssueWithComments(URL url) throws NotFoundException {
        String trackerId = Utils.getParamaterFromUrl((Pattern)ID_PARAM_PATTERN, (URL)url);
        return this.getIssueWithComments(trackerId);
    }

    public Issue getIssueWithComments(String trackerId) throws NotFoundException {
        Issue issue = this.getIssue(trackerId);
        this.setCommentsForIssue(issue);
        return issue;
    }

    private void setCommentsForIssue(Issue issue) {
        try {
            issue.setComments(this.getCommentsForIssue(issue));
        }
        catch (NotFoundException e) {
            Utils.logException((Log)LOG, (String)"Unable to retrieve comments for issue: ", (Exception)((Object)e));
        }
    }

    public List<Comment> getCommentsForIssue(Issue issue) throws NotFoundException {
        if (issue == null) {
            throw new IllegalArgumentException("The provided issue cannot be null.");
        }
        if (issue.getTrackerId().isPresent()) {
            return this.getCommentsForIssue((String)issue.getTrackerId().get());
        }
        return this.getCommentsForIssue(Utils.getParamaterFromUrl((Pattern)ID_PARAM_PATTERN, (URL)issue.getURL()));
    }

    public Map<String, List<Comment>> getCommentsForIssues(Map<String, Issue> issues) {
        if (issues == null || issues.isEmpty()) {
            Collections.emptyMap();
        }
        HashMap<String, Object[]> params = new HashMap<String, Object[]>();
        params.put("ids", this.extractIssueIdsList(issues.values()));
        params.put("include_fields", BugzillaFields.COMMENT_FIELDS);
        return this.buildMapOfCommentsIndexedByBugId(this.executeRequest(XMLRPC.RPC_STRUCT, "Bug.comments", params));
    }

    private Map<String, List<Comment>> buildMapOfCommentsIndexedByBugId(Map<String, Object> results) {
        HashMap<String, List<Comment>> commentsMap = new HashMap<String, List<Comment>>();
        if (results != null && !results.isEmpty() && results.containsKey("bugs")) {
            for (Map<String, Object> comments : XMLRPC.iterable(XMLRPC.RPC_STRUCT, results.values())) {
                for (Map.Entry<String, Object> comment : comments.entrySet()) {
                    String bugId = comment.getKey();
                    commentsMap.put(bugId, this.buildCommentsForBug(XMLRPC.cast(XMLRPC.RPC_ARRAY, XMLRPC.cast(XMLRPC.RPC_STRUCT, comment.getValue()).get("comments"))));
                }
            }
        }
        return commentsMap;
    }

    private List<Comment> buildCommentsForBug(Object[] commentObjArray) {
        ArrayList<Comment> comments = new ArrayList<Comment>(commentObjArray.length);
        for (Object o : commentObjArray) {
            comments.add(this.buildComment(XMLRPC.cast(XMLRPC.RPC_STRUCT, o)));
        }
        return comments;
    }

    private Comment buildComment(Map<String, Object> comment) {
        String id = String.valueOf(comment.get("id"));
        String body = (String)comment.get("text");
        boolean isPrivate = (Boolean)comment.get("is_private");
        return new Comment(id, body, isPrivate);
    }

    private Object[] extractIssueIdsList(Collection<Issue> collection) {
        return collection.stream().filter(Objects::nonNull).map(issue -> (String)issue.getTrackerId().get()).collect(Collectors.toList()).toArray();
    }

    public List<Comment> getCommentsForIssue(String trackerId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", trackerId);
        params.put("include_fields", BugzillaFields.COMMENT_FIELDS);
        Map<String, Object> results = this.executeRequest(XMLRPC.RPC_STRUCT, "Bug.comments", params);
        if (results != null && !results.isEmpty() && results.containsKey("bugs")) {
            Map<String, Object> issues = XMLRPC.cast(XMLRPC.RPC_STRUCT, results.get("bugs"));
            return this.getCommentList(XMLRPC.cast(XMLRPC.RPC_STRUCT, issues.get(trackerId)));
        }
        return new ArrayList<Comment>();
    }

    public List<Issue> searchIssuesByFilter(URL filterUrl) throws NotFoundException {
        String filterName = Utils.getParamaterFromUrl((Pattern)FILTER_NAME_PARAM_PATTERN, (URL)filterUrl);
        int sharerId = Integer.parseInt(Utils.getParamaterFromUrl((Pattern)SHARER_ID_PARAM_PATTERN, (URL)filterUrl));
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("savedsearch", filterName);
        queryMap.put("sharer_id", sharerId);
        queryMap.put("include_fields", BugzillaFields.RESULT_FIELDS);
        try {
            return this.searchIssues(queryMap);
        }
        catch (RuntimeException e) {
            throw new NotFoundException("Unable to retrieve issues associated with filter url: " + filterUrl, (Throwable)e);
        }
    }

    public List<Issue> searchIssues(SearchCriteria criteria) {
        return this.searchIssues(criteria, -1);
    }

    public List<Issue> searchIssues(SearchCriteria criteria, int defaultIssueLimit) {
        Map<String, Object> queryMap = new BugzillaQueryBuilder(criteria, defaultIssueLimit).getQueryMap();
        if (queryMap == null) {
            return new ArrayList<Issue>();
        }
        return this.searchIssues(queryMap);
    }

    private List<Issue> searchIssues(Map<String, Object> queryMap) {
        List<Object> issueList = new ArrayList<Issue>(0);
        Map<String, Object> resultMap = this.executeRequest(XMLRPC.RPC_STRUCT, "Bug.search", queryMap);
        if (resultMap != null && !resultMap.isEmpty()) {
            Map<String, Issue> issues = this.fetchAllIssues(XMLRPC.cast(XMLRPC.RPC_ARRAY, resultMap.get("bugs")));
            Map<String, List<Comment>> comments = this.getCommentsForIssues(issues);
            issueList = issues.keySet().stream().filter(Objects::nonNull).map(id -> this.associateCommentsToIssue((Issue)issues.get(id), comments)).collect(Collectors.toList());
        }
        return issueList;
    }

    private Issue associateCommentsToIssue(Issue issue, Map<String, List<Comment>> comments) {
        issue.setComments(comments.get(issue.getTrackerId().get()));
        return issue;
    }

    private Map<String, Issue> fetchAllIssues(Object[] bugs) {
        HashMap<String, Issue> issues = new HashMap<String, Issue>();
        for (Map<String, Object> struct : XMLRPC.iterable(XMLRPC.RPC_STRUCT, bugs)) {
            Issue issue = this.WRAPPER.bugzillaBugToIssue(struct, this.baseURL);
            issues.put((String)issue.getTrackerId().get(), issue);
        }
        return issues;
    }

    public boolean updateIssue(Issue issue) throws AphroditeException {
        Map<String, Object> params = this.WRAPPER.issueToBugzillaBug(issue);
        return this.runCommand("Bug.update", params);
    }

    public boolean updateTargetRelease(int id, String ... targetRelease) {
        return this.updateField(id, "target_release", targetRelease);
    }

    public boolean updateStatus(int id, IssueStatus status) {
        return this.updateField(id, "status", status);
    }

    public boolean updateTargetMilestone(int id, String targetMilestone) {
        return this.updateField(id, "target_release", targetMilestone);
    }

    public boolean updateEstimate(int id, double worktime) {
        return this.updateField(id, "estimated_time", worktime);
    }

    public boolean postComment(Issue issue, Comment comment) throws NotFoundException {
        String trackerId = issue.getTrackerId().orElse(Utils.getParamaterFromUrl((Pattern)ID_PARAM_PATTERN, (URL)issue.getURL()));
        return this.postComment(new Integer(trackerId), comment.getBody(), comment.isPrivate());
    }

    public boolean postComment(int id, String comment, boolean isPrivate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("comment", comment);
        params.put("private", isPrivate);
        return this.runCommand("Bug.add_comment", params);
    }

    public boolean postComment(Map<Issue, Comment> commentMap) {
        List requests = commentMap.entrySet().stream().map(entry -> CompletableFuture.supplyAsync(() -> this.postCommentAndLogExceptions((Issue)entry.getKey(), (Comment)entry.getValue()), this.executorService)).collect(Collectors.toList());
        return requests.stream().map(CompletableFuture::join).noneMatch(failed -> failed == false);
    }

    public boolean postComment(Collection<Issue> issues, Comment comment) {
        List requests = issues.stream().map(issue -> CompletableFuture.supplyAsync(() -> this.postCommentAndLogExceptions((Issue)issue, comment), this.executorService)).collect(Collectors.toList());
        return requests.stream().map(CompletableFuture::join).noneMatch(failed -> failed == false);
    }

    private boolean postCommentAndLogExceptions(Issue issue, Comment comment) {
        try {
            return this.postComment(issue, comment);
        }
        catch (NotFoundException e) {
            Utils.logException((Log)LOG, (Exception)((Object)e));
            return false;
        }
    }

    public boolean updateFlags(int ids, String name, FlagStatus status) {
        String flagStatus = status.getSymbol();
        HashMap<String, String> updates = new HashMap<String, String>();
        updates.put("name", name);
        updates.put("status", flagStatus);
        Object[] updateArray = new Object[]{updates};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", ids);
        params.put("updates", updateArray);
        params.put("permissive", true);
        return this.runCommand("Bug.update", params);
    }

    private List<Comment> getCommentList(Map<String, Object> issues) {
        ArrayList<Comment> issueComments = new ArrayList<Comment>();
        for (Object[] comments : XMLRPC.iterable(XMLRPC.RPC_ARRAY, issues.values())) {
            for (Map<String, Object> comment : XMLRPC.iterable(XMLRPC.RPC_STRUCT, comments)) {
                issueComments.add(this.buildComment(comment));
            }
        }
        return issueComments;
    }

    private boolean updateField(int bugzillaId, String field, Object content) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", bugzillaId);
        params.put(field, content);
        return this.runCommand("Bug.update", params);
    }

    public Issue createIssue(String projectKey, String summary, String component, String version) throws NotFoundException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("product", projectKey);
        params.put("summary", summary);
        params.put("component", component);
        params.put("version", version);
        Map<String, Object> results = this.executeRequest(XMLRPC.RPC_STRUCT, "Bug.create", params);
        if (results == null || results.size() != 1 || results.get("id") == null) {
            throw new NotFoundException("Failed to create issue, result: " + results);
        }
        String trackerId = results.get("id").toString();
        return this.getIssue(trackerId);
    }

    private <T> T executeRequest(XMLRPC<T> type, String method, Object ... params) {
        try {
            return type.cast(this.getRpcClient().execute(method, params));
        }
        catch (XmlRpcException e) {
            Utils.logException((Log)LOG, (Exception)((Object)e));
            throw new RuntimeException(e);
        }
    }

    private XmlRpcClient getRpcClient() {
        String apiURL = this.baseURL + "xmlrpc.cgi";
        XmlRpcClient rpcClient = new XmlRpcClient();
        try {
            URL url = new URL(apiURL);
            rpcClient.setConfig(this.getClientConfig(url));
            XmlRpcCommonsTransportFactory xmlRpcTransportFactory = new XmlRpcCommonsTransportFactory(rpcClient){

                public XmlRpcTransport getTransport() {
                    return new XmlRpcCommonsTransport(this){

                        protected void initHttpHeaders(XmlRpcRequest request) throws XmlRpcClientException {
                            super.initHttpHeaders(request);
                            super.setRequestHeader("Authorization", "Bearer " + BugzillaClient.this.apiKey);
                        }
                    };
                }
            };
            rpcClient.setTransportFactory((XmlRpcTransportFactory)xmlRpcTransportFactory);
        }
        catch (MalformedURLException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new RuntimeException(e);
        }
        return rpcClient;
    }

    private XmlRpcClientConfig getClientConfig(URL apiURL) {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(apiURL);
        config.setEnabledForExtensions(true);
        config.setContentLengthOptional(false);
        return config;
    }

    private boolean runCommand(String method, Object ... params) {
        try {
            this.getRpcClient().execute(method, params);
            return true;
        }
        catch (XmlRpcException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class XMLRPC<T> {
        static final XMLRPC<Object[]> RPC_ARRAY = new XMLRPC(Object[].class);
        static final XMLRPC<Map<String, Object>> RPC_STRUCT = new XMLRPC(Map.class);
        final Class<T> cls;

        XMLRPC(Class<?> cls) {
            this.cls = cls;
        }

        T cast(Object obj) {
            return this.cls.cast(obj);
        }

        static <T> T cast(XMLRPC<T> type, Object obj) {
            return type.cast(obj);
        }

        static <T> Iterable<T> iterable(final XMLRPC<T> type, Collection<Object> c) {
            final Iterator<Object> it = c.iterator();
            return () -> new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public T next() {
                    return type.cast(it.next());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        static <T> Iterable<T> iterable(final XMLRPC<T> type, Object[] array) {
            final Iterator<Object> it = Arrays.asList(array).iterator();
            return () -> new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public T next() {
                    return type.cast(it.next());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }
    }
}

