/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.bugzilla;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.Flag;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.IssueEstimation;
import org.jboss.set.aphrodite.domain.IssueStatus;
import org.jboss.set.aphrodite.domain.IssueType;
import org.jboss.set.aphrodite.domain.Release;
import org.jboss.set.aphrodite.domain.Stage;
import org.jboss.set.aphrodite.domain.TrackerType;
import org.jboss.set.aphrodite.domain.User;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.BugzillaClient;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.BugzillaFields;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.BugzillaIssueTracker;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.IssuePriorityTranslatorUtil;
import org.jboss.set.aphrodite.spi.AphroditeException;

class IssueWrapper {
    private static final Log LOG = LogFactory.getLog(BugzillaIssueTracker.class);

    IssueWrapper() {
    }

    Issue bugzillaBugToIssue(Map<String, Object> bug, URL baseURL) {
        Integer id = (Integer)bug.get("id");
        URL url = Utils.createURL((String)(baseURL + "show_bug.cgi?id=" + id));
        Issue issue = new Issue(url, (TrackerType)org.jboss.set.aphrodite.config.TrackerType.BUGZILLA);
        issue.setTrackerId(id.toString());
        issue.setAssignee(User.createWithEmail((String)((String)bug.get("assigned_to"))));
        issue.setReporter(User.createWithEmail((String)((String)bug.get("creator"))));
        issue.setCreationTime((Date)bug.get("creation_time"));
        issue.setLastUpdated((Date)bug.get("last_change_time"));
        issue.setSummary((String)bug.get("summary"));
        issue.setDescription((String)bug.get("description"));
        String status = (String)bug.get("status");
        issue.setStatus(IssueStatus.valueOf((String)status), status);
        issue.setPriority(IssuePriorityTranslatorUtil.translateFromBugzilla((String)bug.get("priority")));
        Object[] components = (Object[])bug.get("component");
        ArrayList<String> tmp = new ArrayList<String>();
        for (Object component : components) {
            tmp.add((String)component);
        }
        issue.setComponents(tmp);
        issue.setProduct((String)bug.get("product"));
        issue.setStatus(IssueStatus.valueOf((String)((String)bug.get("status")).toUpperCase()));
        String type = (String)bug.get("cf_type");
        issue.setType(IssueType.getMatchingIssueType((String)type), type);
        this.setAffectedVersions(issue, (Object[])bug.get("version"));
        IssueWrapper.setReleases(issue, bug);
        List<URL> dependsOn = this.getListOfURlsFromIds(bug, baseURL, "depends_on");
        dependsOn.addAll(this.getListOfExternalURLsFromIds(bug, "external_bugs"));
        issue.setDependsOn(dependsOn);
        issue.setBlocks(this.getListOfURlsFromIds(bug, baseURL, "blocks"));
        this.checkIsNullEstimation(bug, issue);
        this.extractStageAndStreams(bug, issue);
        return issue;
    }

    private static void setReleases(Issue issue, Map<String, Object> bug) {
        ArrayList<Release> releases = new ArrayList<Release>();
        if (bug.containsKey("target_release") && bug.get("target_release") != null) {
            Object[] targetReleases;
            for (Object targetRelease : targetReleases = (Object[])bug.get("target_release")) {
                if (bug.containsKey("target_milestone") && bug.get("target_milestone") != null) {
                    releases.add(new Release((String)targetRelease, (String)bug.get("target_milestone")));
                    continue;
                }
                releases.add(new Release((String)targetRelease));
            }
        }
        issue.setReleases(releases);
    }

    private void setAffectedVersions(Issue issue, Object[] affectedVersions) {
        if (affectedVersions != null && affectedVersions.length > 0) {
            ArrayList<String> affectedVersionsList = new ArrayList<String>(affectedVersions.length);
            for (Object affectedVersion : affectedVersions) {
                affectedVersionsList.add(affectedVersion.toString());
            }
            issue.setAffectedVersions(affectedVersionsList);
        }
    }

    private void checkIsNullEstimation(Map<String, Object> bug, Issue issue) {
        Double estimatedTime = (Double)bug.get("estimated_time");
        Double hoursWorked = (Double)bug.get("actual_time");
        if (estimatedTime != null && hoursWorked != null) {
            issue.setEstimation(new IssueEstimation(estimatedTime.doubleValue(), hoursWorked.doubleValue()));
        } else if (estimatedTime != null) {
            issue.setEstimation(new IssueEstimation(estimatedTime.doubleValue()));
        }
    }

    Map<String, Object> issueToBugzillaBug(Issue issue) throws AphroditeException {
        this.checkUnsupportedUpdateFields(issue);
        this.checkUnsupportedIssueStatus(issue);
        HashMap<String, Object> params = new HashMap<String, Object>();
        issue.getTrackerId().ifPresent(trackerId -> params.put("ids", trackerId));
        issue.getSummary().ifPresent(summary -> params.put("summary", summary));
        issue.getProduct().ifPresent(product -> params.put("product", product));
        params.put("component", issue.getComponents().toArray(new String[issue.getComponents().size()]));
        issue.getAssignee().ifPresent(assignee -> params.put("assigned_to", assignee.getEmail().orElseThrow(this::nullUserEmail)));
        issue.getReporter().ifPresent(reporter -> params.put("creator", reporter.getEmail().orElseThrow(this::nullUserEmail)));
        issue.getEstimation().ifPresent(tracking -> {
            params.put("actual_time", tracking.getHoursWorked());
            params.put("estimated_time", tracking.getInitialEstimate());
        });
        params.put("status", issue.getStatus().toString());
        params.put("flags", this.getStageAndStreamsMap(issue.getStreamStatus(), issue.getStage().getStateMap()));
        if (issue.getType() != IssueType.UNDEFINED) {
            params.put("cf_type", issue.getType().get());
        }
        this.addReleaseToUpdate(issue, params);
        this.addURLCollectionToParameters(issue.getDependsOn(), "depends_on", params);
        this.addURLCollectionToParameters(issue.getBlocks(), "blocks", params);
        return params;
    }

    private IllegalArgumentException nullUserEmail() {
        throw new IllegalArgumentException("Bugzilla requires a non-null User.email field to update assignee/reporters");
    }

    private void checkUnsupportedUpdateFields(Issue issue) {
        if (issue.getReporter().isPresent() && LOG.isWarnEnabled()) {
            LOG.warn((Object)"Bugzilla does not support updating the reporter field, field ignored.");
        }
        if (issue.getStatus() == IssueStatus.UNDEFINED && LOG.isWarnEnabled()) {
            LOG.warn((Object)"IssueStatus.UNDEFINED is ignored when updating a Bugzilla operation.");
        }
    }

    private void checkUnsupportedIssueStatus(Issue issue) throws AphroditeException {
        if (issue.getStatus() == IssueStatus.CREATED) {
            throw new AphroditeException("Bugzilla issues do not support the IssueStatus CREATED");
        }
    }

    private void addReleaseToUpdate(Issue issue, Map<String, Object> params) {
        List releases = issue.getReleases();
        if (!releases.isEmpty()) {
            Release release = (Release)releases.get(0);
            release.getVersion().ifPresent(version -> params.put("version", version));
            release.getMilestone().ifPresent(milestone -> params.put("target_milestone", milestone));
            if (releases.size() > 1) {
                Utils.logWarnMessage((Log)LOG, (String)"Bugzilla only supports one Release object. The first Release object in Issue::getReleases is used and subsequent Releases are ignored.");
            }
        }
    }

    private List<Map<String, Object>> getStageAndStreamsMap(Map<String, FlagStatus> streams, Map<Flag, FlagStatus> stateMap) {
        HashMap<String, String> flagMap;
        ArrayList<Map<String, Object>> flags = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, FlagStatus> entry : streams.entrySet()) {
            flagMap = new HashMap<String, String>();
            flagMap.put("name", entry.getKey());
            flagMap.put("status", entry.getValue().getSymbol());
            flags.add(flagMap);
        }
        for (Map.Entry<String, FlagStatus> entry : stateMap.entrySet()) {
            flagMap = new HashMap();
            Optional<String> bzFlag = BugzillaFields.getBugzillaFlag((Flag)entry.getKey());
            bzFlag.ifPresent(flagName -> {
                flagMap.put("name", (String)flagName);
                flagMap.put("status", ((FlagStatus)entry.getValue()).getSymbol());
                flags.add(flagMap);
            });
        }
        return flags;
    }

    private void addURLCollectionToParameters(List<URL> urls, String flag, Map<String, Object> params) {
        HashMap<String, List> map = new HashMap<String, List>();
        List ids = Utils.getParametersFromUrls((Pattern)BugzillaClient.ID_PARAM_PATTERN, urls);
        map.put("set", ids);
        params.put(flag, map);
    }

    private List<URL> getListOfURlsFromIds(Map<String, Object> bug, URL baseURL, String field) {
        Object[] ids;
        ArrayList<URL> list = new ArrayList<URL>();
        for (Object id : ids = (Object[])bug.get(field)) {
            list.add(Utils.createURL((String)(baseURL + "show_bug.cgi?id=" + id)));
        }
        return list;
    }

    private List<URL> getListOfExternalURLsFromIds(Map<String, Object> bug, String externalBugField) {
        Object[] eBugs;
        if (!bug.containsKey(externalBugField)) {
            return Collections.emptyList();
        }
        ArrayList<URL> externalURL = new ArrayList<URL>();
        for (Object tmp : eBugs = (Object[])bug.get(externalBugField)) {
            try {
                Map bz = (Map)tmp;
                Map bzType = (Map)bz.get("type");
                if (!"JIRA".equals(bzType.get("type"))) continue;
                String bugId = (String)bz.get("ext_bz_bug_id");
                String urlBase = (String)bzType.get("full_url");
                String url = urlBase.replace("%id%", bugId);
                externalURL.add(URI.create(url).toURL());
            }
            catch (Exception e) {
                Utils.logException((Log)LOG, (String)"cannot convert the url", (Exception)e);
            }
        }
        return externalURL;
    }

    private void extractStageAndStreams(Map<String, Object> bug, Issue issue) {
        Stage issueStage = new Stage();
        HashMap<String, FlagStatus> streams = new HashMap<String, FlagStatus>();
        if (bug.get("flags") != null) {
            for (Object object : (Object[])bug.get("flags")) {
                Map flagMap = (Map)object;
                String name = (String)flagMap.get("name");
                if (name.contains("_ack")) {
                    Optional<Flag> flag = BugzillaFields.getAphroditeFlag(name);
                    if (!flag.isPresent()) continue;
                    FlagStatus status = FlagStatus.getMatchingFlag((String)((String)flagMap.get("status")));
                    issueStage.setStatus(flag.get(), status);
                    continue;
                }
                if (name.equals("needinfo") || name.equals("requires_doc_text") || name.equals("qe_test_coverage")) continue;
                FlagStatus status = FlagStatus.getMatchingFlag((String)((String)flagMap.get("status")));
                streams.put(name, status);
            }
        }
        issue.setStage(IssueWrapper.ensureStageMapIsComplete(issueStage));
        issue.setStreamStatus(streams);
    }

    private static Stage ensureStageMapIsComplete(Stage issue) {
        for (Flag flag : Flag.values()) {
            issue.getStateMap().putIfAbsent(flag, FlagStatus.NO_SET);
        }
        return issue;
    }
}

