/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.bugzilla;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.IssueTrackerConfig;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.domain.Comment;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.IssueStatus;
import org.jboss.set.aphrodite.domain.SearchCriteria;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.BugzillaClient;
import org.jboss.set.aphrodite.issue.trackers.bugzilla.BugzillaIssueCreationDetails;
import org.jboss.set.aphrodite.issue.trackers.common.AbstractIssueTracker;
import org.jboss.set.aphrodite.issue.trackers.common.IssueCreationDetails;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class BugzillaIssueTracker
extends AbstractIssueTracker {
    static final Pattern BUGZILLAFIXVERSION = Pattern.compile("(\\d\\.)(\\d\\.)(\\d+)");
    private static final Log LOG = LogFactory.getLog(BugzillaIssueTracker.class);
    private BugzillaClient bzClient;

    public BugzillaIssueTracker() {
        super(TrackerType.BUGZILLA);
    }

    public boolean init(IssueTrackerConfig config) {
        boolean parentInitiated = super.init(config);
        if (!parentInitiated) {
            return false;
        }
        try {
            this.bzClient = new BugzillaClient(this.baseUrl, config.getPassword(), this.executorService);
        }
        catch (IllegalStateException e) {
            Utils.logException((Log)LOG, (Exception)e);
            return false;
        }
        return true;
    }

    public Issue getIssue(URL url) throws NotFoundException {
        this.checkHost(url);
        return this.bzClient.getIssueWithComments(url);
    }

    public List<Issue> getIssues(Collection<URL> urls) {
        if ((urls = this.filterUrlsByHost(urls)).isEmpty()) {
            return new ArrayList<Issue>();
        }
        return this.bzClient.getIssues(urls);
    }

    public List<Issue> searchIssues(SearchCriteria searchCriteria) {
        return this.bzClient.searchIssues(searchCriteria, this.config.getDefaultIssueLimit());
    }

    public List<Issue> searchIssuesByFilter(URL filterUrl) throws NotFoundException {
        this.checkHost(filterUrl);
        return this.bzClient.searchIssuesByFilter(filterUrl);
    }

    public boolean updateIssue(Issue issue) throws NotFoundException, AphroditeException {
        this.checkHost(issue.getURL());
        return this.bzClient.updateIssue(issue);
    }

    public void addCommentToIssue(Issue issue, Comment comment) throws NotFoundException {
        super.addCommentToIssue(issue, comment);
        this.bzClient.postComment(issue, comment);
    }

    public boolean addCommentToIssue(Map<Issue, Comment> commentMap) {
        return (commentMap = this.filterIssuesByHost(commentMap)).isEmpty() || this.bzClient.postComment(commentMap);
    }

    public boolean addCommentToIssue(Collection<Issue> issues, Comment comment) {
        return (issues = this.filterIssuesByHost(issues)).isEmpty() || this.bzClient.postComment(issues, comment);
    }

    public BugzillaClient getBzClient() {
        return this.bzClient;
    }

    protected Log getLog() {
        return LOG;
    }

    public boolean isCPReleased(String cpVersion) {
        Matcher matcher = BUGZILLAFIXVERSION.matcher(cpVersion);
        if (!matcher.matches()) {
            return false;
        }
        String payloadTrackerId = "eap" + cpVersion.replace(".", "") + "-payload";
        try {
            Issue issue = this.bzClient.getIssue(payloadTrackerId);
            if (issue.getStatus().equals((Object)IssueStatus.CLOSED) || issue.getStatus().equals((Object)IssueStatus.VERIFIED)) {
                return true;
            }
        }
        catch (NotFoundException e) {
            Utils.logException((Log)LOG, (Exception)((Object)e));
            return false;
        }
        return false;
    }

    public Issue createIssue(IssueCreationDetails details) throws NotFoundException {
        assert (details != null);
        assert (details instanceof BugzillaIssueCreationDetails);
        BugzillaIssueCreationDetails localDetails = (BugzillaIssueCreationDetails)details;
        assert (details.getDescription() != null);
        assert (details.getProjectKey() != null);
        assert (localDetails.getComponent() != null);
        assert (localDetails.getVersion() != null);
        assert (localDetails.getTrackerURL() != null);
        assert (localDetails.getProjectKey() != null);
        return this.bzClient.createIssue(localDetails.getProjectKey(), localDetails.getDescription(), localDetails.getComponent(), localDetails.getVersion());
    }
}

