/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.IssueTrackerConfig;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.config.StreamConfig;
import org.jboss.set.aphrodite.config.StreamType;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;

public class AphroditeConfig {
    private final ScheduledExecutorService executorService;
    private final List<IssueTrackerConfig> issueTrackerConfigs;
    private final List<RepositoryConfig> repositoryConfigs;
    private final List<StreamConfig> streamConfigs;

    public static AphroditeConfig singleIssueTracker(IssueTrackerConfig issueTrackerConfig) {
        ArrayList<IssueTrackerConfig> list = new ArrayList<IssueTrackerConfig>();
        list.add(issueTrackerConfig);
        return AphroditeConfig.issueTrackersOnly(list);
    }

    public static AphroditeConfig issueTrackersOnly(List<IssueTrackerConfig> issueTrackerConfigs) {
        return new AphroditeConfig(issueTrackerConfigs, new ArrayList<RepositoryConfig>(), new ArrayList<StreamConfig>());
    }

    public static AphroditeConfig singleRepositoryService(RepositoryConfig repositoryConfig) {
        ArrayList<RepositoryConfig> list = new ArrayList<RepositoryConfig>();
        list.add(repositoryConfig);
        return AphroditeConfig.repositoryServicesOnly(list);
    }

    public static AphroditeConfig repositoryServicesOnly(List<RepositoryConfig> repositoryConfigs) {
        return new AphroditeConfig(new ArrayList<IssueTrackerConfig>(), repositoryConfigs, new ArrayList<StreamConfig>());
    }

    public AphroditeConfig(List<IssueTrackerConfig> issueTrackerConfigs, List<RepositoryConfig> repositoryConfigs, List<StreamConfig> streamConfigs) {
        this(Executors.newScheduledThreadPool(3, new DefaultThreadFactory()), issueTrackerConfigs, repositoryConfigs, streamConfigs);
    }

    public AphroditeConfig(ScheduledExecutorService executorService, List<IssueTrackerConfig> issueTrackerConfigs, List<RepositoryConfig> repositoryConfigs, List<StreamConfig> streamConfigs) {
        Objects.requireNonNull(executorService, "executorService cannot be null");
        this.executorService = executorService;
        this.issueTrackerConfigs = issueTrackerConfigs == null ? new ArrayList() : issueTrackerConfigs;
        this.repositoryConfigs = repositoryConfigs == null ? new ArrayList() : repositoryConfigs;
        this.streamConfigs = streamConfigs == null ? new ArrayList() : streamConfigs;
    }

    public AphroditeConfig(AphroditeConfig config) {
        this(config.getExecutorService(), new ArrayList<IssueTrackerConfig>(config.getIssueTrackerConfigs()), new ArrayList<RepositoryConfig>(config.getRepositoryConfigs()), new ArrayList<StreamConfig>(config.getStreamConfigs()));
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public List<IssueTrackerConfig> getIssueTrackerConfigs() {
        return this.issueTrackerConfigs;
    }

    public List<RepositoryConfig> getRepositoryConfigs() {
        return this.repositoryConfigs;
    }

    public List<StreamConfig> getStreamConfigs() {
        return this.streamConfigs;
    }

    public static AphroditeConfig fromJson(JsonObject jsonObject) {
        int maxThreadCount = jsonObject.getInt("maxThreadCount", 0);
        List<IssueTrackerConfig> issueTrackerConfigs = AphroditeConfig.getIssueTrackerConfigs(jsonObject);
        List<RepositoryConfig> repositoryConfigs = AphroditeConfig.getRepositoryConfigs(jsonObject);
        List<StreamConfig> streamConfigs = AphroditeConfig.getStreamConfigs(jsonObject);
        if (maxThreadCount > 0) {
            return new AphroditeConfig(Executors.newScheduledThreadPool(maxThreadCount, new DefaultThreadFactory()), issueTrackerConfigs, repositoryConfigs, streamConfigs);
        }
        return new AphroditeConfig(issueTrackerConfigs, repositoryConfigs, streamConfigs);
    }

    private static List<IssueTrackerConfig> getIssueTrackerConfigs(JsonObject jsonObject) {
        JsonArray jsonArray = jsonObject.getJsonArray("issueTrackerConfigs");
        Objects.requireNonNull(jsonArray, "issueTrackerConfigs array must be specified");
        return jsonArray.stream().map(JsonObject.class::cast).map(json -> new IssueTrackerConfig(json.getString("url", null), json.getString("username", null), json.getString("password", null), TrackerType.valueOf(json.getString("tracker", null)), json.getInt("defaultIssueLimit", -1))).collect(Collectors.toList());
    }

    private static List<RepositoryConfig> getRepositoryConfigs(JsonObject jsonObject) {
        JsonArray jsonArray = jsonObject.getJsonArray("repositoryConfigs");
        Objects.requireNonNull(jsonArray, "repositoryConfigs array must be specified");
        return jsonArray.stream().map(JsonObject.class::cast).map(json -> new RepositoryConfig(json.getString("url", null), json.getString("username", null), json.getString("password", null), RepositoryType.valueOf(json.getString("type", null)))).collect(Collectors.toList());
    }

    private static List<StreamConfig> getStreamConfigs(JsonObject jsonObject) {
        JsonArray jsonArray = jsonObject.getJsonArray("streamConfigs");
        if (jsonArray == null) {
            return new ArrayList<StreamConfig>();
        }
        return jsonArray.stream().map(JsonObject.class::cast).map(json -> {
            StreamType type = StreamType.valueOf(json.getString("type", null));
            String url = json.getString("url", null);
            String fileLocation = json.getString("file", null);
            if (url != null && fileLocation != null) {
                throw new IllegalArgumentException("A StreamConfigs entry cannot contain both a 'file' and 'url' field");
            }
            if (url != null) {
                return new StreamConfig(Utils.createURL(url), type);
            }
            if (fileLocation == null) {
                throw new IllegalArgumentException("A StreamConfigs entry must have a 'file' or 'url' field set");
            }
            return new StreamConfig(new File(fileLocation), type);
        }).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AphroditeConfig that = (AphroditeConfig)o;
        if (this.issueTrackerConfigs != null ? !this.issueTrackerConfigs.equals(that.issueTrackerConfigs) : that.issueTrackerConfigs != null) {
            return false;
        }
        if (this.repositoryConfigs != null ? !this.repositoryConfigs.equals(that.repositoryConfigs) : that.repositoryConfigs != null) {
            return false;
        }
        return this.streamConfigs != null ? this.streamConfigs.equals(that.streamConfigs) : that.streamConfigs == null;
    }

    public int hashCode() {
        int result = this.issueTrackerConfigs != null ? this.issueTrackerConfigs.hashCode() : 0;
        result = 31 * result + (this.repositoryConfigs != null ? this.repositoryConfigs.hashCode() : 0);
        result = 31 * result + (this.streamConfigs != null ? this.streamConfigs.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AphroditeConfig{issueTrackerConfigs=" + this.issueTrackerConfigs + ", repositoryConfigs=" + this.repositoryConfigs + ",streamConfigs=" + this.streamConfigs + '}';
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

