/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.stream.services.json;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.config.StreamConfig;
import org.jboss.set.aphrodite.config.StreamType;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Stream;
import org.jboss.set.aphrodite.domain.StreamComponent;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.aphrodite.spi.StreamService;
import org.jboss.set.aphrodite.stream.services.json.StreamComponentJsonParser;

public class JsonStreamService
implements StreamService {
    private static final Log LOG = LogFactory.getLog(JsonStreamService.class);
    private final Map<String, Stream> streamMap = new HashMap<String, Stream>();
    private Aphrodite aphrodite;
    private AphroditeConfig config;

    @Override
    public boolean init(Aphrodite aphrodite, AphroditeConfig config) throws NotFoundException {
        this.aphrodite = aphrodite;
        this.config = config;
        return this.updateStreams();
    }

    private boolean init(StreamConfig config) throws NotFoundException {
        if (config.getURL().isPresent()) {
            this.readJsonFromURL(config.getURL().get());
        } else if (config.getStreamFile().isPresent()) {
            this.readJsonFromFile(config.getStreamFile().get());
        } else {
            throw new IllegalArgumentException("StreamConfig requires either a URL or File to be specified");
        }
        return true;
    }

    @Override
    public synchronized boolean updateStreams() throws NotFoundException {
        Iterator<StreamConfig> i = this.config.getStreamConfigs().iterator();
        while (i.hasNext()) {
            StreamConfig streamConfig = i.next();
            if (streamConfig.getStreamType() != StreamType.JSON) continue;
            i.remove();
            return this.init(streamConfig);
        }
        return false;
    }

    @Override
    public synchronized List<Stream> getStreams() {
        return new ArrayList<Stream>(this.streamMap.values());
    }

    @Override
    public synchronized Stream getStream(String streamName) {
        return this.streamMap.get(streamName);
    }

    private void readJsonFromFile(File file) throws NotFoundException {
        try (JsonReader jr = Json.createReader((InputStream)new FileInputStream(file));){
            this.parseJson(jr.readObject());
        }
        catch (IOException e) {
            Utils.logException(LOG, "Unable to load file: " + file.getPath(), e);
            throw new NotFoundException("Unable to load file: " + file.getPath(), e);
        }
        catch (JsonException e) {
            Utils.logException(LOG, (Exception)((Object)e));
            throw new NotFoundException(e);
        }
    }

    private void readJsonFromURL(URL url) throws NotFoundException {
        try (InputStream is = url.openStream();){
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            JsonReader jr = Json.createReader((Reader)rd);
            this.parseJson(jr.readObject());
        }
        catch (IOException | NotFoundException e) {
            Utils.logException(LOG, "Unable to load url: " + url.toString(), e);
            throw new NotFoundException(e);
        }
    }

    private void parseJson(JsonObject jsonObject) throws NotFoundException {
        JsonArray jsonArray = jsonObject.getJsonArray("streams");
        Objects.requireNonNull(jsonArray, "streams array must be specified in json file");
        for (JsonValue value : jsonArray) {
            JsonObject json = (JsonObject)value;
            String upstreamName = json.getString("upstream", null);
            Stream upstream = this.streamMap.get(upstreamName);
            JsonArray codebases = json.getJsonArray("codebases");
            Map<String, StreamComponent> codebaseMap = this.parseStreamCodebases(codebases);
            Stream currentStream = new Stream(json.getString("name"), upstream, codebaseMap);
            this.streamMap.put(currentStream.getName(), currentStream);
        }
    }

    private Map<String, StreamComponent> parseStreamCodebases(JsonArray codebases) {
        HashMap<String, StreamComponent> codebaseMap = new HashMap<String, StreamComponent>();
        for (JsonValue value : codebases) {
            JsonObject json = (JsonObject)value;
            StreamComponent component = StreamComponentJsonParser.parse(json);
            if (component == null) continue;
            codebaseMap.put(component.getName(), component);
        }
        return codebaseMap;
    }

    @Override
    public List<URI> getDistinctURLRepositories() {
        return this.getStreams().stream().flatMap(stream -> this.getDistinctURLRepositoriesByStream(stream.getName()).stream()).collect(Collectors.toList());
    }

    @Override
    public List<URI> getDistinctURLRepositoriesByStream(String streamName) {
        Stream stream = this.getStream(streamName);
        if (stream == null) {
            return new ArrayList<URI>();
        }
        return stream.getAllComponents().stream().map(StreamComponent::getRepositoryURL).distinct().collect(Collectors.toList());
    }

    @Override
    public List<Stream> getStreamsBy(URI repositoryURL, Codebase codebase) {
        ArrayList<Stream> streams = new ArrayList<Stream>();
        block0: for (Stream stream : this.getStreams()) {
            for (StreamComponent component : stream.getAllComponents()) {
                if (!component.getRepositoryURL().equals(repositoryURL) || !component.getCodebase().equals((Object)codebase)) continue;
                streams.add(stream);
                continue block0;
            }
        }
        return streams;
    }

    @Override
    public StreamComponent getComponentBy(URI repositoryURL, Codebase codebase) {
        for (Stream stream : this.getStreams()) {
            for (StreamComponent component : stream.getAllComponents()) {
                if (!component.getRepositoryURL().equals(repositoryURL) || !component.getCodebase().equals((Object)codebase)) continue;
                return component;
            }
        }
        return null;
    }
}

