/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.stream.services.json;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.RepositoryType;
import org.jboss.set.aphrodite.domain.StreamComponent;

public class StreamComponentJsonParser {
    private static final Log LOG = LogFactory.getLog(StreamComponentJsonParser.class);
    public static final String JSON_NAME = "component_name";
    public static final String JSON_CONTACTS = "contacts";
    public static final String JSON_REPOSITORY_TYPE = "repository_type";
    public static final String JSON_REPOSITORY_URL = "repository_url";
    public static final String JSON_CODEBASE = "codebase";
    public static final String JSON_TAG = "tag";
    public static final String JSON_VERSION = "version";
    public static final String JSON_GAV = "gav";
    public static final String JSON_COMMENT = "comment";

    private StreamComponentJsonParser() {
    }

    public static StreamComponent parse(JsonObject json) {
        try {
            String name = json.getString(JSON_NAME);
            List<String> contacts = StreamComponentJsonParser.getContacts(json);
            RepositoryType repositoryType = RepositoryType.fromType((String)json.getString(JSON_REPOSITORY_TYPE));
            String repository = json.getString(JSON_REPOSITORY_URL);
            URI repositoryURI = null;
            if (repository != null) {
                if (!repository.endsWith("/")) {
                    repository = repository + "/";
                }
                repositoryURI = new URI(repository);
            }
            Codebase codeBase = new Codebase(json.getString(JSON_CODEBASE));
            String tag = json.getString(JSON_TAG);
            String version = json.getString(JSON_VERSION);
            String gav = json.getString(JSON_GAV);
            String comment = json.getString(JSON_COMMENT);
            return new StreamComponent(name, contacts, repositoryType, repositoryURI, codeBase, tag, version, gav, comment);
        }
        catch (Exception e) {
            Utils.logException(LOG, e);
            return null;
        }
    }

    private static List<String> getContacts(JsonObject json) {
        JsonArray contactsArray = json.getJsonArray(JSON_CONTACTS);
        ArrayList<String> contacts = new ArrayList<String>(contactsArray.size());
        for (int index = 0; index < contactsArray.size(); ++index) {
            contacts.add(contactsArray.getString(index));
        }
        return contacts;
    }
}

