/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.config.IssueTrackerConfig;
import org.jboss.set.aphrodite.config.TrackerType;
import org.jboss.set.aphrodite.domain.Comment;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.spi.IssueTrackerService;
import org.jboss.set.aphrodite.spi.NotFoundException;

public abstract class AbstractIssueTracker
implements IssueTrackerService {
    public static final Pattern URL_REGEX = Pattern.compile("(http|ftp|https)://([\\w_-]+(?:(?:\\.[\\w_-]+)+))([\\w.,@?^=%&:/~+#-]*[\\w@?^=%&/~+#-])?\\d+");
    protected final TrackerType TRACKER_TYPE;
    protected ExecutorService executorService;
    protected IssueTrackerConfig config;
    protected URL baseUrl;

    protected abstract Log getLog();

    public AbstractIssueTracker(TrackerType TRACKER_TYPE) {
        this.TRACKER_TYPE = TRACKER_TYPE;
    }

    @Override
    public boolean init(AphroditeConfig aphroditeConfig) {
        this.executorService = aphroditeConfig.getExecutorService();
        Iterator<IssueTrackerConfig> i = aphroditeConfig.getIssueTrackerConfigs().iterator();
        while (i.hasNext()) {
            IssueTrackerConfig config = i.next();
            if (config.getTracker() != this.TRACKER_TYPE) continue;
            i.remove();
            return this.init(config);
        }
        return false;
    }

    @Override
    public boolean init(IssueTrackerConfig config) {
        this.config = config;
        String url = config.getUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            this.baseUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            String errorMsg = "Invalid IssueTracker url. " + this.getClass().getName() + " service for '" + url + "' cannot be started";
            Utils.logException(this.getLog(), errorMsg, e);
            return false;
        }
        return true;
    }

    @Override
    public List<Issue> getIssuesAssociatedWith(PullRequest pullRequest) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Matcher m = URL_REGEX.matcher(pullRequest.getTitle() + pullRequest.getBody());
        while (m.find()) {
            String link = m.group();
            try {
                URL url = new URL(link);
                if (!url.getHost().equals(this.baseUrl.getHost())) continue;
                issues.add(this.getIssue(url));
            }
            catch (MalformedURLException e) {
                if (!this.getLog().isTraceEnabled()) continue;
                this.getLog().trace((Object)e);
            }
            catch (NotFoundException e) {
                Utils.logException(this.getLog(), "Unable to retrieve Issue at " + link + ":", e);
            }
        }
        return issues;
    }

    @Override
    public void addCommentToIssue(Issue issue, Comment comment) throws NotFoundException {
        this.checkHost(issue.getURL());
        comment.getId().ifPresent(id -> Utils.logWarnMessage(this.getLog(), "ID: " + id + "ignored when posting comments as this is set by the issue tracker."));
    }

    protected void checkHost(URL url) throws NotFoundException {
        if (!this.urlExists(url)) {
            throw new NotFoundException("The requested entity cannot be found at this tracker as the specified host domain is different from this service.");
        }
    }

    @Override
    public boolean urlExists(URL url) {
        Objects.requireNonNull(url);
        return AbstractIssueTracker.convertToTrackerID(url).equals(this.getTrackerID());
    }

    @Override
    public String getTrackerID() {
        return AbstractIssueTracker.convertToTrackerID(this.baseUrl);
    }

    public static String convertToTrackerID(URL url) {
        Objects.requireNonNull(url);
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append(url.getProtocol()).append("://").append(url.getHost());
        if (url.getPort() > 0) {
            stringBuilder.append(":").append(url.getPort());
        }
        return stringBuilder.toString();
    }

    protected Map<Issue, Comment> filterIssuesByHost(Map<Issue, Comment> commentMap) {
        Objects.requireNonNull(commentMap);
        return commentMap.entrySet().stream().filter(entry -> entry.getKey() != null && this.urlExists(((Issue)entry.getKey()).getURL())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected Collection<Issue> filterIssuesByHost(Collection<Issue> issues) {
        Objects.requireNonNull(issues);
        return issues.stream().filter(i -> i != null && this.urlExists(i.getURL())).collect(Collectors.toList());
    }

    protected Collection<URL> filterUrlsByHost(Collection<URL> urls) {
        Objects.requireNonNull(urls);
        return urls.stream().filter(url -> url != null && this.urlExists((URL)url)).collect(Collectors.toList());
    }
}

