/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.stream.services.json;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.config.StreamConfig;
import org.jboss.set.aphrodite.config.StreamType;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Stream;
import org.jboss.set.aphrodite.domain.StreamComponent;
import org.jboss.set.aphrodite.domain.StreamComponentUpdateException;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.aphrodite.spi.StreamService;
import org.jboss.set.aphrodite.stream.services.json.StreamsJsonParser;

public class JsonStreamService
implements StreamService {
    private static final Log LOG = LogFactory.getLog(JsonStreamService.class);
    private final Map<String, Stream> parsedStreamsMap = new LinkedHashMap<String, Stream>();
    private final Map<URL, Collection<Stream>> urlToParsedStreams = new LinkedHashMap<URL, Collection<Stream>>();
    private AphroditeConfig config;

    @Override
    public boolean init(Aphrodite aphrodite, AphroditeConfig config) throws NotFoundException {
        this.config = config;
        return this.updateStreams();
    }

    @Override
    public synchronized boolean updateStreams() throws NotFoundException {
        for (StreamConfig streamConfig : this.config.getStreamConfigs()) {
            if (streamConfig.getStreamType() != StreamType.JSON) continue;
            return this.init(streamConfig);
        }
        return false;
    }

    private boolean init(StreamConfig config) throws NotFoundException {
        URL url = null;
        if (config.getURL().isPresent()) {
            url = config.getURL().get();
        } else if (config.getStreamFile().isPresent()) {
            try {
                url = config.getStreamFile().get().toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new NotFoundException(e);
            }
        } else {
            LOG.error((Object)"StreamConfig requires either a URL or File to be specified");
            return false;
        }
        Map<String, Stream> streamsMap = StreamsJsonParser.parse(url);
        this.parsedStreamsMap.putAll(streamsMap);
        this.urlToParsedStreams.put(url, streamsMap.values());
        return true;
    }

    @Override
    public synchronized List<Stream> getStreams() {
        return new ArrayList<Stream>(this.parsedStreamsMap.values());
    }

    @Override
    public synchronized Stream getStream(String streamName) {
        return this.parsedStreamsMap.get(streamName);
    }

    @Override
    public List<URI> getDistinctURLRepositories() {
        return this.getStreams().stream().flatMap(stream -> this.getDistinctURLRepositoriesByStream(stream.getName()).stream()).collect(Collectors.toList());
    }

    @Override
    public List<URI> getDistinctURLRepositoriesByStream(String streamName) {
        Stream stream = this.getStream(streamName);
        if (stream == null) {
            return new ArrayList<URI>();
        }
        return stream.getAllComponents().stream().map(StreamComponent::getRepositoryURL).distinct().collect(Collectors.toList());
    }

    @Override
    public List<Stream> getStreamsBy(URI repositoryURL, Codebase codebase) {
        ArrayList<Stream> streams = new ArrayList<Stream>();
        block0: for (Stream stream : this.getStreams()) {
            for (StreamComponent component : stream.getAllComponents()) {
                if (!component.getRepositoryURL().equals(repositoryURL) || !component.getCodebase().equals((Object)codebase)) continue;
                streams.add(stream);
                continue block0;
            }
        }
        return streams;
    }

    @Override
    public StreamComponent getComponentBy(URI repositoryURL, Codebase codebase) {
        for (Stream stream : this.getStreams()) {
            for (StreamComponent component : stream.getAllComponents()) {
                if (!component.getRepositoryURL().equals(repositoryURL) || !component.getCodebase().equals((Object)codebase)) continue;
                return component;
            }
        }
        return null;
    }

    @Override
    public StreamComponent updateStreamComponent(StreamComponent streamComponent) throws StreamComponentUpdateException {
        Stream owner = streamComponent.getStream();
        if (owner == null) {
            throw new StreamComponentUpdateException("No owner stream for component.", streamComponent);
        }
        owner.updateComponent(streamComponent);
        return streamComponent;
    }

    @Override
    public void serializeStreams(URL url, OutputStream out) throws NotFoundException {
        Collection<Stream> streams = this.urlToParsedStreams.get(url);
        if (streams == null) {
            throw new NotFoundException("No matching set of streams for '" + url + "'");
        }
        JsonObject jsonObject = StreamsJsonParser.encode(streams);
        Map<String, Boolean> config = JsonStreamService.buildConfig();
        JsonWriterFactory writerFactory = Json.createWriterFactory(config);
        JsonWriter jsonWriter = writerFactory.createWriter(out);
        jsonWriter.write((JsonStructure)jsonObject);
        jsonWriter.close();
    }

    private static Map<String, Boolean> buildConfig() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        return config;
    }
}

