/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.stream.services.json;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.Stream;
import org.jboss.set.aphrodite.domain.StreamComponent;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.aphrodite.spi.StreamService;
import org.jboss.set.aphrodite.stream.services.json.StreamComponentJsonParser;

public class StreamsJsonParser {
    private static final Log LOG = LogFactory.getLog(StreamService.class);
    public static final String JSON_STREAMS = "streams";
    public static final String JSON_UPSTREAM = "upstream";
    public static final String JSON_CODEBASES = "codebases";
    public static final String JSON_NAME = "name";
    public static final String JSON_VALUE_NULL = "null";

    private StreamsJsonParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Stream> parse(URL url) throws NotFoundException {
        try (InputStream is = url.openStream();){
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            JsonReader jr = Json.createReader((Reader)rd);
            JsonArray jsonArray = jr.readObject().getJsonArray(JSON_STREAMS);
            Objects.requireNonNull(jsonArray, "streams array must be specified in json file");
            LinkedHashMap<String, Stream> streamMap = new LinkedHashMap<String, Stream>();
            for (JsonValue value : jsonArray) {
                JsonObject json = (JsonObject)value;
                String upstreamName = json.getString(JSON_UPSTREAM, null);
                Stream upstream = (Stream)streamMap.get(upstreamName);
                JsonArray codebases = json.getJsonArray(JSON_CODEBASES);
                Map<String, StreamComponent> codebaseMap = StreamsJsonParser.parseStreamCodebases(codebases);
                Stream currentStream = new Stream(url, json.getString(JSON_NAME), upstream, codebaseMap);
                streamMap.put(currentStream.getName(), currentStream);
            }
            LinkedHashMap<String, Stream> linkedHashMap = streamMap;
            return linkedHashMap;
        }
        catch (Exception e) {
            Utils.logException(LOG, "Unable to load url: " + url.toString(), e);
            throw new NotFoundException(e);
        }
    }

    private static Map<String, StreamComponent> parseStreamCodebases(JsonArray codebases) {
        LinkedHashMap<String, StreamComponent> codebaseMap = new LinkedHashMap<String, StreamComponent>();
        for (JsonValue value : codebases) {
            JsonObject json = (JsonObject)value;
            StreamComponent component = StreamComponentJsonParser.parse(json);
            if (component == null) continue;
            codebaseMap.put(component.getName(), component);
        }
        return codebaseMap;
    }

    public static JsonObject encode(Collection<Stream> toEncode) {
        JsonObjectBuilder rootBuilder = Json.createObjectBuilder();
        JsonArrayBuilder array = StreamsJsonParser.encodeStreams(toEncode);
        rootBuilder.add(JSON_STREAMS, array);
        return rootBuilder.build();
    }

    private static JsonArrayBuilder encodeStreams(Collection<Stream> streams) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (Stream s : streams) {
            array.add(StreamsJsonParser.encodeStream(s));
        }
        return array;
    }

    private static JsonObjectBuilder encodeStream(Stream stream) {
        JsonObjectBuilder object = Json.createObjectBuilder();
        object.add(JSON_NAME, stream.getName());
        object.add(JSON_UPSTREAM, stream.getUpstream() == null ? JSON_VALUE_NULL : stream.getUpstream().getName());
        object.add(JSON_CODEBASES, StreamsJsonParser.encodeStreamComponents(stream.getAllComponents()));
        return object;
    }

    private static JsonArrayBuilder encodeStreamComponents(Collection<StreamComponent> components) {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (StreamComponent c : components) {
            array.add((JsonValue)StreamComponentJsonParser.encodeStreamComponent(c));
        }
        return array;
    }
}

