/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.config;

import java.util.Objects;

public abstract class AbstractServiceConfig {
    private final String url;
    private final String username;
    private final String password;

    public AbstractServiceConfig(String url, String username, String password) {
        Objects.requireNonNull(url, "A services 'url' must be specified.");
        Objects.requireNonNull(password, "A 'password' must be specified for each service.");
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "AbstractServiceConfig{url='" + this.url + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractServiceConfig other = (AbstractServiceConfig)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

