/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Comment;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.PullRequestState;
import org.jboss.set.aphrodite.domain.PullRequestUpgrade;
import org.jboss.set.aphrodite.domain.RateLimit;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.domain.SearchCriteria;
import org.jboss.set.aphrodite.domain.Stream;
import org.jboss.set.aphrodite.domain.StreamComponent;
import org.jboss.set.aphrodite.issue.trackers.common.AbstractIssueTracker;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.IssueTrackerService;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.aphrodite.spi.RepositoryService;
import org.jboss.set.aphrodite.spi.StreamService;

public class Aphrodite
implements AutoCloseable {
    public static final String FILE_PROPERTY = "aphrodite.config";
    private static final Log LOG = LogFactory.getLog(Aphrodite.class);
    private static Aphrodite instance;
    private static final String URL_REGEX_STRING = "(http|ftp|https)://([\\w_-]+(?:(?:\\.[\\w_-]+)+))([\\w.,@?^=%&:/~+#-]*[\\w@?^=%&/~+#-])?\\d+";
    private static final Pattern URL_REGEX;
    private static final Pattern UPSTREAM_ISSUE_NOT_REQUIRED;
    private static final Pattern ISSUE;
    private static final Pattern UPSTREAM_ISSUE;
    private static final Pattern UPSTREAM_PR;
    private static final Pattern RELATED_ISSUES;
    private static final String UPGRADE_META_BIT_REGEX = "\\w++=\\w++";
    private static final String UPGRADE_META_REGEX = "\\s*+\\w++=\\w++(,\\s*+\\w++=\\w++)*+";
    private static final Pattern UPGRADE;
    private final Map<String, IssueTrackerService> issueTrackers = new TreeMap<String, IssueTrackerService>(String.CASE_INSENSITIVE_ORDER);
    private final List<RepositoryService> repositories = new ArrayList<RepositoryService>();
    private final List<StreamService> streamServices = new ArrayList<StreamService>();
    private ScheduledExecutorService executorService;
    private AphroditeConfig config;

    public static synchronized Aphrodite instance() throws AphroditeException {
        if (instance == null) {
            instance = new Aphrodite();
        }
        return instance;
    }

    public static synchronized Aphrodite instance(AphroditeConfig config) throws AphroditeException {
        if (instance != null) {
            if (Aphrodite.instance.config.equals(config)) {
                return instance;
            }
            throw new IllegalStateException("Cannot create a new instance of " + Aphrodite.class.getName() + " as it is a singleton which has already been initialised.");
        }
        instance = new Aphrodite(config);
        return Aphrodite.instance();
    }

    @Override
    public void close() throws Exception {
        this.executorService.shutdown();
        this.issueTrackers.values().forEach(IssueTrackerService::destroy);
        this.issueTrackers.clear();
        this.repositories.forEach(RepositoryService::destroy);
        this.repositories.clear();
    }

    private Aphrodite() throws AphroditeException {
        String propFileLocation = System.getProperty(FILE_PROPERTY);
        if (propFileLocation == null) {
            throw new IllegalArgumentException("Property 'aphrodite.config' must be set");
        }
        try (JsonReader jr = Json.createReader((InputStream)new FileInputStream(propFileLocation));){
            this.init(AphroditeConfig.fromJson(jr.readObject()));
        }
        catch (IOException e) {
            Utils.logException(LOG, "Unable to load file: " + propFileLocation, e);
            throw new AphroditeException(e);
        }
    }

    private Aphrodite(AphroditeConfig config) throws AphroditeException {
        this.init(config);
    }

    private void init(AphroditeConfig config) throws AphroditeException {
        boolean initialised;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Initiating Aphrodite ...");
        }
        this.config = config;
        this.executorService = config.getExecutorService();
        AphroditeConfig mutableConfig = new AphroditeConfig(config);
        for (IssueTrackerService is : ServiceLoader.load(IssueTrackerService.class)) {
            initialised = is.init(mutableConfig);
            if (!initialised) continue;
            this.issueTrackers.put(is.getTrackerID(), is);
        }
        for (RepositoryService rs : ServiceLoader.load(RepositoryService.class)) {
            initialised = rs.init(mutableConfig);
            if (!initialised) continue;
            this.repositories.add(rs);
        }
        if (this.issueTrackers.isEmpty()) {
            throw new AphroditeException("Unable to initiatilise Aphrodite, as a valid " + IssueTrackerService.class.getName() + " does not exist.");
        }
        if (this.repositories.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unable to initiatilise Aphrodite, as a valid " + RepositoryService.class.getName() + " does not exist."));
        }
        this.initialiseStreams(mutableConfig);
        int period = config.getStreamServiceUpdateRate();
        int initialDelay = config.getInitialDelay();
        if (period > 0) {
            this.executorService.scheduleAtFixedRate(new UpdateStreamServices(), initialDelay, config.getStreamServiceUpdateRate(), TimeUnit.MINUTES);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Aphrodite Initialisation Complete");
        }
    }

    private void initialiseStreams(AphroditeConfig mutableConfig) throws AphroditeException {
        if (mutableConfig.getStreamConfigs().isEmpty() && this.repositories.isEmpty()) {
            throw new AphroditeException("Unable to initialise any Stream Services as no " + RepositoryService.class.getName() + " have been created.");
        }
        for (StreamService ss : ServiceLoader.load(StreamService.class)) {
            try {
                boolean initialised = ss.init(this, mutableConfig);
                if (!initialised) continue;
                this.streamServices.add(ss);
            }
            catch (NotFoundException e) {
                throw new AphroditeException("Unable to initiatilise Aphrodite as an error was thrown when initiating " + ss.getClass().getName() + ": " + e);
            }
        }
    }

    public Issue getIssue(URL url) throws NotFoundException {
        Objects.requireNonNull(url, "url cannot be null");
        this.checkIssueTrackerExists();
        IssueTrackerService its = this.getTrackerFor(url);
        if (its != null) {
            return its.getIssue(url);
        }
        throw new NotFoundException("No issues found which correspond to url: " + url);
    }

    @Deprecated
    public Issue getIssue(PullRequest pullRequest) throws NotFoundException, MalformedURLException {
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        this.checkIssueTrackerExists();
        String body = pullRequest.getBody();
        String[] url = this.extractURLs(body, ISSUE, false);
        if (url == null || url.length == 0 || url[0] == null) {
            return null;
        }
        return this.getIssue(new URL(url[0]));
    }

    @Deprecated
    public List<Issue> getRelatedIssues(PullRequest pullRequest) throws MalformedURLException, NotFoundException {
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        this.checkIssueTrackerExists();
        String body = pullRequest.getBody();
        String[] urls = this.extractURLs(body, RELATED_ISSUES, true);
        if (urls == null || urls.length == 0 || urls[0] == null) {
            return null;
        }
        ArrayList<Issue> issues = new ArrayList<Issue>(urls.length);
        for (String url : urls) {
            issues.add(this.getIssue(new URL(url)));
        }
        return issues;
    }

    @Deprecated
    public Issue getUpstreamIssue(PullRequest pullRequest) throws NotFoundException, MalformedURLException {
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        this.checkIssueTrackerExists();
        if (this.isUpstreamRequired(pullRequest)) {
            String body = pullRequest.getBody();
            String[] url = this.extractURLs(body, UPSTREAM_ISSUE, false);
            if (url == null || url.length == 0 || url[0] == null) {
                return null;
            }
            return this.getIssue(new URL(url[0]));
        }
        return null;
    }

    @Deprecated
    public PullRequest getUpstreamPullRequest(PullRequest pullRequest) throws MalformedURLException, NotFoundException {
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        this.checkIssueTrackerExists();
        if (this.isUpstreamRequired(pullRequest)) {
            String body = pullRequest.getBody();
            String[] url = this.extractURLs(body, UPSTREAM_PR, false);
            if (url == null || url.length == 0 || url[0] == null) {
                return null;
            }
            return this.getPullRequest(new URL(url[0]));
        }
        return null;
    }

    @Deprecated
    public PullRequestUpgrade getPullRequestUpgrade(PullRequest pullRequest) {
        if (!this.hasUpgrade(pullRequest)) {
            return null;
        }
        String body = pullRequest.getBody();
        Matcher m = UPGRADE.matcher(body);
        m.find();
        String upgradeBody = body.substring(m.start(), m.end());
        m = Pattern.compile(UPGRADE_META_BIT_REGEX).matcher(upgradeBody);
        Properties metas = new Properties();
        while (m.find()) {
            String[] x = upgradeBody.substring(m.start(), m.end()).split("=");
            metas.put(x[0], x[1]);
        }
        return new PullRequestUpgrade(pullRequest, metas.getProperty("id"), metas.getProperty("tag"), metas.getProperty("version"), metas.getProperty("branch"));
    }

    @Deprecated
    public boolean isUpstreamRequired(PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        this.checkIssueTrackerExists();
        String body = pullRequest.getBody();
        Matcher m = UPSTREAM_ISSUE_NOT_REQUIRED.matcher(body);
        return !m.find();
    }

    @Deprecated
    public boolean hasUpgrade(PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        this.checkIssueTrackerExists();
        String body = pullRequest.getBody();
        Matcher m = UPGRADE.matcher(body);
        return m.find();
    }

    protected String[] extractURLs(String source, Pattern initialMatchPattern, boolean multiple) {
        Matcher m = initialMatchPattern.matcher(source);
        if (m.find()) {
            String urlSource = source.substring(m.start(), m.end());
            m = URL_REGEX.matcher(urlSource);
            if (multiple) {
                ArrayList<String> urls = new ArrayList<String>();
                while (m.find()) {
                    urls.add(urlSource.substring(m.start(), m.end()));
                }
                return urls.toArray(new String[urls.size()]);
            }
            if (m.find()) {
                return new String[]{urlSource.substring(m.start(), m.end())};
            }
            return null;
        }
        return null;
    }

    public List<Issue> getIssues(Collection<URL> urls) {
        Objects.requireNonNull(urls, "the collection of urls cannot be null");
        if (urls.isEmpty()) {
            return new ArrayList<Issue>();
        }
        List requests = this.issueTrackers.values().stream().map(tracker -> CompletableFuture.supplyAsync(() -> tracker.getIssues(urls), this.executorService)).collect(Collectors.toList());
        return requests.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Issue> searchIssues(SearchCriteria searchCriteria) {
        Objects.requireNonNull(searchCriteria, "searchCriteria cannot be null");
        this.checkIssueTrackerExists();
        if (searchCriteria.isEmpty()) {
            return new ArrayList<Issue>();
        }
        List searchRequests = this.issueTrackers.values().stream().map(tracker -> CompletableFuture.supplyAsync(() -> tracker.searchIssues(searchCriteria), this.executorService)).collect(Collectors.toList());
        return searchRequests.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Issue> searchIssuesByFilter(URL filterUrl) throws NotFoundException {
        Objects.requireNonNull(filterUrl, "filterUrl cannot be null");
        this.checkIssueTrackerExists();
        IssueTrackerService its = this.getTrackerFor(filterUrl);
        if (its != null) {
            return its.searchIssuesByFilter(filterUrl);
        }
        throw new NotFoundException("No filter found which correspond to url: " + filterUrl);
    }

    public boolean updateIssue(Issue issue) throws NotFoundException, AphroditeException {
        Objects.requireNonNull(issue, "issue cannot be null");
        this.checkIssueTrackerExists();
        IssueTrackerService its = this.getTrackerFor(issue.getURL());
        if (its != null) {
            return its.updateIssue(issue);
        }
        throw new NotFoundException("No issues found which correspond to url: " + issue.getURL());
    }

    public void addCommentToIssue(Issue issue, Comment comment) throws NotFoundException {
        Objects.requireNonNull(issue, "issue cannot be null");
        Objects.requireNonNull(comment, "comment cannot be null");
        this.checkIssueTrackerExists();
        IssueTrackerService its = this.getTrackerFor(issue.getURL());
        if (its != null) {
            its.addCommentToIssue(issue, comment);
            return;
        }
        throw new NotFoundException("No issues found which correspond to url: " + issue.getURL());
    }

    public boolean addCommentToIssue(Map<Issue, Comment> commentMap) {
        this.checkIssueTrackerExists();
        Objects.requireNonNull(commentMap, "commentMap cannot be null");
        boolean isSuccess = true;
        for (Map.Entry<Issue, Comment> ie : commentMap.entrySet()) {
            IssueTrackerService its = this.getTrackerFor(ie.getKey().getURL());
            if (its != null) {
                try {
                    its.addCommentToIssue(ie.getKey(), ie.getValue());
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                    isSuccess = false;
                }
                continue;
            }
            isSuccess = false;
        }
        return isSuccess;
    }

    public boolean addCommentToIssue(Collection<Issue> issues, Comment comment) {
        this.checkIssueTrackerExists();
        Objects.requireNonNull(issues, "issues collection cannot be null");
        Objects.requireNonNull(comment, "comment cannot be null");
        boolean isSuccess = true;
        for (Issue i : issues) {
            IssueTrackerService its = this.getTrackerFor(i.getURL());
            if (its != null) {
                try {
                    its.addCommentToIssue(i, comment);
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                    isSuccess = false;
                }
                continue;
            }
            isSuccess = false;
        }
        return isSuccess;
    }

    @Deprecated
    public List<Issue> getIssuesAssociatedWith(PullRequest pullRequest) {
        this.checkIssueTrackerExists();
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        return this.issueTrackers.values().stream().map(service -> service.getIssuesAssociatedWith(pullRequest)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Repository getRepository(URL url) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(url, "url cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.repositoryAccessable(url) || !repositoryService.urlExists(url)) continue;
            return repositoryService.getRepository(url);
        }
        throw new NotFoundException("No repositories found which correspond to url: " + url);
    }

    public List<PullRequest> getPullRequestsByState(Repository repository, PullRequestState state) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        Objects.requireNonNull(state, "state cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(repository.getURL())) continue;
            return repositoryService.getPullRequestsByState(repository, state);
        }
        return Collections.emptyList();
    }

    public PullRequest getPullRequest(URL url) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(url, "url cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.repositoryAccessable(url) || !repositoryService.urlExists(url)) continue;
            return repositoryService.getPullRequest(url);
        }
        throw new NotFoundException("No pull request found which corresponds to url: " + url);
    }

    public Map<RepositoryType, RateLimit> getRateLimits() throws NotFoundException {
        HashMap<RepositoryType, RateLimit> rateLimits = new HashMap<RepositoryType, RateLimit>();
        for (RepositoryService repositoryService : this.repositories) {
            RepositoryType repositoryType = repositoryService.getRepositoryType();
            RateLimit requestLimit = repositoryService.getRateLimit();
            rateLimits.put(repositoryType, requestLimit);
        }
        return Collections.unmodifiableMap(rateLimits);
    }

    public List<Label> getLabelsFromRepository(Repository repository) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(repository.getURL())) continue;
            return repositoryService.getLabelsFromRepository(repository);
        }
        return Collections.emptyList();
    }

    public List<Label> getLabelsFromPullRequest(PullRequest pullRequest) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(pullRequest.getURL())) continue;
            return repositoryService.getLabelsFromPullRequest(pullRequest);
        }
        return Collections.emptyList();
    }

    public boolean isRepositoryLabelsModifiable(Repository repository) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(repository.getURL())) continue;
            return repositoryService.hasModifiableLabels(repository);
        }
        throw new NotFoundException("No repository found which corresponds to url: " + repository.getURL());
    }

    public void setLabelsToPullRequest(PullRequest pullRequest, List<Label> labels) throws NotFoundException, AphroditeException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        Objects.requireNonNull(labels, "labels cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(pullRequest.getURL())) continue;
            repositoryService.setLabelsToPullRequest(pullRequest, labels);
        }
    }

    public void removeLabelFromPullRequest(PullRequest pullRequest, String name) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        Objects.requireNonNull(name, "labelname cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(pullRequest.getURL())) continue;
            repositoryService.removeLabelFromPullRequest(pullRequest, name);
        }
    }

    public void addCommentToPullRequest(PullRequest pullRequest, String comment) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        Objects.requireNonNull(comment, "comment cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(pullRequest.getURL())) continue;
            repositoryService.addCommentToPullRequest(pullRequest, comment);
            return;
        }
        throw new NotFoundException("No pull request found which corresponds to pull request.");
    }

    public void addLabelToPullRequest(PullRequest pullRequest, String labelName) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        Objects.requireNonNull(labelName, "labelName cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(pullRequest.getURL())) continue;
            repositoryService.addLabelToPullRequest(pullRequest, labelName);
        }
    }

    public List<PullRequest> findPullRequestsRelatedTo(PullRequest pullRequest) {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        return this.repositories.stream().filter(service -> service.urlExists(pullRequest.getURL())).flatMap(service -> service.findPullRequestsRelatedTo(pullRequest).stream()).collect(Collectors.toList());
    }

    public CommitStatus getCommitStatusFromPullRequest(PullRequest pullRequest) throws NotFoundException {
        this.checkRepositoryServiceExists();
        Objects.requireNonNull(pullRequest, "pull request cannot be null");
        for (RepositoryService repositoryService : this.repositories) {
            if (!repositoryService.urlExists(pullRequest.getURL())) continue;
            return repositoryService.getCommitStatusFromPullRequest(pullRequest);
        }
        throw new NotFoundException("No commit status found for pull request:" + pullRequest.getURL());
    }

    public List<Stream> getAllStreams() {
        this.checkStreamServiceExists();
        return this.streamServices.stream().flatMap(streamService -> streamService.getStreams().stream()).collect(Collectors.toList());
    }

    public Stream getStream(String streamName) throws NotFoundException {
        this.checkStreamServiceExists();
        Objects.requireNonNull(streamName, "stream name can not be null");
        for (StreamService ss : this.streamServices) {
            Stream stream = ss.getStream(streamName);
            if (stream == null) continue;
            return stream;
        }
        throw new NotFoundException("No Stream exists with the name '" + streamName + "'");
    }

    public boolean isCPReleased(String cpVersion) {
        Objects.requireNonNull(cpVersion, "CP version cannot be null");
        this.checkIssueTrackerExists();
        boolean released = this.issueTrackers.values().stream().anyMatch(e -> e.isCPReleased(cpVersion));
        return released;
    }

    @Deprecated
    public List<URI> getDistinctURLRepositoriesFromStreams() {
        this.checkStreamServiceExists();
        return this.streamServices.stream().flatMap(streamService -> streamService.getDistinctURLRepositories().stream()).distinct().collect(Collectors.toList());
    }

    @Deprecated
    public List<URI> getDistinctURLRepositoriesByStream(String streamName) {
        this.checkStreamServiceExists();
        Objects.requireNonNull(streamName, "streamName can not be null");
        return this.streamServices.stream().flatMap(streamService -> streamService.getDistinctURLRepositoriesByStream(streamName).stream()).distinct().collect(Collectors.toList());
    }

    @Deprecated
    public List<Stream> getStreamsBy(URI repository, Codebase codebase) {
        this.checkStreamServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        Objects.requireNonNull(codebase, "codebase cannot be null");
        return this.streamServices.stream().flatMap(streamService -> streamService.getStreamsBy(repository, codebase).stream()).collect(Collectors.toList());
    }

    @Deprecated
    public StreamComponent getComponentBy(URI repository, Codebase codebase) throws NotFoundException {
        this.checkStreamServiceExists();
        Objects.requireNonNull(repository, "repository cannot be null");
        Objects.requireNonNull(codebase, "codebase cannot be null");
        for (StreamService streamService : this.streamServices) {
            StreamComponent streamComponent = streamService.getComponentBy(repository, codebase);
            if (streamComponent == null) continue;
            return streamComponent;
        }
        throw new NotFoundException("No StreamComponent is associated with '" + repository + "' and '" + codebase + "'");
    }

    private void checkIssueTrackerExists() {
        if (this.issueTrackers.isEmpty()) {
            throw new IllegalStateException("Unable to retrieve issues as a valid " + IssueTrackerService.class.getName() + " has not been created.");
        }
    }

    private void checkRepositoryServiceExists() {
        if (this.repositories.isEmpty()) {
            throw new IllegalStateException("Unable to find any repository data as a valid " + RepositoryService.class.getName() + " has not been created.");
        }
    }

    private void checkStreamServiceExists() {
        if (this.streamServices.isEmpty()) {
            throw new IllegalStateException("Unable to retrieve streamas a valid " + StreamService.class.getName() + " has not been created.");
        }
    }

    private IssueTrackerService getTrackerFor(URL url) {
        String id = AbstractIssueTracker.convertToTrackerID(url);
        if (this.issueTrackers.containsKey(id)) {
            return this.issueTrackers.get(id);
        }
        return null;
    }

    static {
        URL_REGEX = Pattern.compile(URL_REGEX_STRING);
        UPSTREAM_ISSUE_NOT_REQUIRED = Pattern.compile("^\\s*Upstream not required.*$", 2);
        ISSUE = Pattern.compile("^\\s*Issue[:|]\\s*+(http|ftp|https)://([\\w_-]+(?:(?:\\.[\\w_-]+)+))([\\w.,@?^=%&:/~+#-]*[\\w@?^=%&/~+#-])?\\d+", 2);
        UPSTREAM_ISSUE = Pattern.compile("^\\s*Upstream Issue[:|]\\s*+(http|ftp|https)://([\\w_-]+(?:(?:\\.[\\w_-]+)+))([\\w.,@?^=%&:/~+#-]*[\\w@?^=%&/~+#-])?\\d+", 2);
        UPSTREAM_PR = Pattern.compile("^\\s*Upstream PR[:|]\\s*+(http|ftp|https)://([\\w_-]+(?:(?:\\.[\\w_-]+)+))([\\w.,@?^=%&:/~+#-]*[\\w@?^=%&/~+#-])?\\d+", 2);
        RELATED_ISSUES = Pattern.compile("^\\s*Related Issue[s|][:|]\\s*+(http|ftp|https)://([\\w_-]+(?:(?:\\.[\\w_-]+)+))([\\w.,@?^=%&:/~+#-]*[\\w@?^=%&/~+#-])?\\d+(,\\s*+(http|ftp|https)://([\\w_-]+(?:(?:\\.[\\w_-]+)+))([\\w.,@?^=%&:/~+#-]*[\\w@?^=%&/~+#-])?\\d+)*+", 2);
        UPGRADE = Pattern.compile("\\s*Upgrade[:|]\\s*+\\w++=\\w++(,\\s*+\\w++=\\w++)*+", 2);
    }

    private class UpdateStreamServices
    implements Runnable {
        private UpdateStreamServices() {
        }

        @Override
        public void run() {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Update Aphrodite streams");
            }
            for (StreamService ss : Aphrodite.this.streamServices) {
                try {
                    ss.updateStreams();
                }
                catch (NotFoundException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("Failed to update stream service: " + ss), (Throwable)e);
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Aphrodite streams update complete");
            }
        }
    }
}

