/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.common;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class Utils {
    private static final Log LOG = LogFactory.getLog(Utils.class);

    public static String decodeURLParam(String parameter) {
        try {
            return URLDecoder.decode(parameter, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getParamaterFromUrl(Pattern pattern, URL url) throws NotFoundException {
        Matcher matcher = pattern.matcher(url.getQuery());
        if (!matcher.find()) {
            throw new NotFoundException("No parameter matching the specified pattern exists in the provided url.");
        }
        return Utils.decodeURLParam(matcher.group(1));
    }

    public static List<String> getParametersFromUrls(Pattern pattern, List<URL> urls) {
        ArrayList<String> ids = new ArrayList<String>();
        for (URL url : urls) {
            try {
                ids.add(Utils.getParamaterFromUrl(pattern, url));
            }
            catch (NotFoundException e) {
                Utils.logException(LOG, e);
            }
        }
        return ids;
    }

    public static String getTrailingValueFromUrlPath(URL url) {
        String path = url.getPath();
        String[] components = path.split("/");
        return components[components.length - 1];
    }

    public static URL createURL(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void logWarnMessage(Log log, String message) {
        if (log.isWarnEnabled()) {
            log.warn((Object)message);
        }
    }

    public static void logException(Log log, Exception e) {
        Utils.logException(log, null, e);
    }

    public static void logException(Log log, String message, Exception e) {
        if (log.isErrorEnabled()) {
            if (message == null) {
                log.error((Object)e);
            } else {
                log.error((Object)message, (Throwable)e);
            }
        }
    }

    public static Exception logExceptionAndGet(Log log, Exception e) {
        Utils.logException(log, null, e);
        return e;
    }

    public static Exception logExceptionAndGet(Log log, String message, Exception e) {
        Utils.logException(log, message, e);
        return e;
    }
}

