/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.spi;

import java.net.URL;
import java.util.List;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.PullRequestState;
import org.jboss.set.aphrodite.domain.RateLimit;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public interface RepositoryService {
    public boolean init(AphroditeConfig var1);

    public boolean init(RepositoryConfig var1);

    public boolean urlExists(URL var1);

    public boolean repositoryAccessable(URL var1);

    public Repository getRepository(URL var1) throws NotFoundException;

    public PullRequest getPullRequest(URL var1) throws NotFoundException;

    public List<PullRequest> getPullRequestsAssociatedWith(Issue var1) throws NotFoundException;

    public List<PullRequest> getPullRequestsByState(Repository var1, PullRequestState var2) throws NotFoundException;

    public List<Label> getLabelsFromRepository(Repository var1) throws NotFoundException;

    public List<Label> getLabelsFromPullRequest(PullRequest var1) throws NotFoundException;

    public boolean hasModifiableLabels(Repository var1) throws NotFoundException;

    public void setLabelsToPullRequest(PullRequest var1, List<Label> var2) throws NotFoundException, AphroditeException;

    public void removeLabelFromPullRequest(PullRequest var1, String var2) throws NotFoundException;

    public void addCommentToPullRequest(PullRequest var1, String var2) throws NotFoundException;

    public void addLabelToPullRequest(PullRequest var1, String var2) throws NotFoundException;

    public List<PullRequest> findPullRequestsRelatedTo(PullRequest var1);

    public CommitStatus getCommitStatusFromPullRequest(PullRequest var1) throws NotFoundException;

    default public void destroy() {
    }

    public RateLimit getRateLimit() throws NotFoundException;

    public RepositoryType getRepositoryType();
}

