/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.AphroditeConfig;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.spi.NotFoundException;

public abstract class AbstractRepositoryService {
    protected final RepositoryType REPOSITORY_TYPE;
    protected RepositoryConfig config;
    protected URL baseUrl;

    protected abstract Log getLog();

    public AbstractRepositoryService(RepositoryType REPOSITORY_TYPE) {
        this.REPOSITORY_TYPE = REPOSITORY_TYPE;
    }

    public boolean init(AphroditeConfig aphroditeConfig) {
        for (RepositoryConfig config : aphroditeConfig.getRepositoryConfigs()) {
            if (config.getType() != this.REPOSITORY_TYPE) continue;
            return this.init(config);
        }
        return false;
    }

    public boolean init(RepositoryConfig config) {
        this.config = config;
        String url = config.getUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            this.baseUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            String errorMsg = "Invalid Repository url. " + this.getClass().getName() + " service for '" + url + "' cannot be started";
            Utils.logException(this.getLog(), errorMsg, e);
            return false;
        }
        return true;
    }

    public boolean urlExists(URL url) {
        Objects.requireNonNull(url);
        return url.getHost().equals(this.baseUrl.getHost());
    }

    protected void checkHost(URL url) throws NotFoundException {
        if (!this.urlExists(url)) {
            throw new NotFoundException("The requested Repository cannot be found as it is not hosted on this server.");
        }
    }
}

