/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.common;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RepositoryUtils {
    private static final Pattern RELATED_PR_PATTERN = Pattern.compile(".*github\\.com.*?/([a-zA-Z_0-9-]*)/([a-zA-Z_0-9-]*)/pull.?/(\\d+)", 2);
    private static final Pattern ABBREVIATED_RELATED_PR_PATTERN = Pattern.compile("([a-zA-Z_0-9-//]*)#(\\d+)", 2);
    private static final Pattern ABBREVIATED_RELATED_PR_PATTERN_EXTERNAL_REPO = Pattern.compile("([a-zA-Z_0-9-]*)/([a-zA-Z_0-9-]*)#(\\d+)", 2);

    public static String createRepositoryIdFromUrl(URL url) {
        return url != null ? RepositoryUtils.createRepositoryIdFromId(url.getPath()) : null;
    }

    private static String createRepositoryIdFromId(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        String owner = null;
        String name = null;
        for (String segment : id.split("/")) {
            if (segment.length() <= 0) continue;
            if (owner == null) {
                owner = segment;
                continue;
            }
            if (name != null) break;
            name = segment;
        }
        return owner != null && owner.length() > 0 && name != null && name.length() > 0 ? owner + "/" + name : null;
    }

    public static List<URL> getPRFromDescription(URL url, String content) throws MalformedURLException, URISyntaxException {
        String[] paths = url.getPath().split("/");
        Matcher matcher = RELATED_PR_PATTERN.matcher(content);
        ArrayList<URL> relatedPullRequests = new ArrayList<URL>();
        while (matcher.find()) {
            if (matcher.groupCount() != 3) continue;
            URL relatedPullRequest = new URI("https://github.com/" + matcher.group(1) + "/" + matcher.group(2) + "/pulls/" + matcher.group(3)).toURL();
            relatedPullRequests.add(relatedPullRequest);
        }
        Matcher abbreviatedMatcher = ABBREVIATED_RELATED_PR_PATTERN.matcher(content);
        while (abbreviatedMatcher.find()) {
            URL relatedPullRequest;
            String match = abbreviatedMatcher.group();
            Matcher abbreviatedExternalMatcher = ABBREVIATED_RELATED_PR_PATTERN_EXTERNAL_REPO.matcher(match);
            if (abbreviatedExternalMatcher.find() && abbreviatedExternalMatcher.groupCount() == 3) {
                relatedPullRequest = new URI("https://github.com/" + abbreviatedExternalMatcher.group(1) + "/" + abbreviatedExternalMatcher.group(2) + "/pull/" + abbreviatedExternalMatcher.group(3)).toURL();
                relatedPullRequests.add(relatedPullRequest);
                continue;
            }
            if (abbreviatedMatcher.groupCount() != 2) continue;
            relatedPullRequest = new URI("https://github.com/" + paths[1] + "/" + paths[2] + "//pulls/" + abbreviatedMatcher.group(2)).toURL();
            relatedPullRequests.add(relatedPullRequest);
        }
        return relatedPullRequests;
    }
}

