/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.IssueStatus;
import org.jboss.set.aphrodite.domain.Release;
import org.jboss.set.aphrodite.domain.Stage;
import org.jboss.set.aphrodite.domain.Stream;

public class SearchCriteria {
    private final IssueStatus status;
    private final String assignee;
    private final String reporter;
    private final String product;
    private final String component;
    private final Stage stage;
    private final Release release;
    private final Map<Stream, FlagStatus> streams;
    private final LocalDate lastUpdated;
    private final Integer maxResults;

    private SearchCriteria(IssueStatus status, String assignee, String reporter, String product, String component, Stage stage, Release release, Map<Stream, FlagStatus> streams, LocalDate lastUpdated, Integer maxResults) {
        this.status = status;
        this.assignee = assignee;
        this.reporter = reporter;
        this.product = product;
        this.component = component;
        this.stage = stage;
        this.release = release;
        this.streams = streams;
        this.lastUpdated = lastUpdated;
        this.maxResults = maxResults;
        if (lastUpdated != null && lastUpdated.isAfter(LocalDate.now())) {
            throw new IllegalArgumentException("lastUpdated cannot be in the future.");
        }
    }

    public Optional<IssueStatus> getStatus() {
        return Optional.ofNullable(this.status);
    }

    public Optional<String> getAssignee() {
        return Optional.ofNullable(this.assignee);
    }

    public Optional<String> getReporter() {
        return Optional.ofNullable(this.reporter);
    }

    public Optional<String> getProduct() {
        return Optional.ofNullable(this.product);
    }

    public Optional<String> getComponent() {
        return Optional.ofNullable(this.component);
    }

    public Optional<Stage> getStage() {
        return Optional.ofNullable(this.stage);
    }

    public Optional<Release> getRelease() {
        return Optional.ofNullable(this.release);
    }

    public Optional<Map<Stream, FlagStatus>> getStreams() {
        return Optional.ofNullable(this.streams);
    }

    public Optional<LocalDate> getLastUpdated() {
        return Optional.ofNullable(this.lastUpdated);
    }

    public Optional<Integer> getMaxResults() {
        return Optional.ofNullable(this.maxResults);
    }

    public boolean isEmpty() {
        return this.status == null && this.assignee == null && this.reporter == null && this.product == null && this.component == null && this.stage == null && this.release == null && this.streams == null && this.lastUpdated == null && this.maxResults == null;
    }

    public static class Builder {
        private IssueStatus status;
        private String assignee;
        private String reporter;
        private String product;
        private String component;
        private Stage stage;
        private Release release;
        private Map<Stream, FlagStatus> streams;
        private LocalDate startDate;
        private Integer maxResults;

        public Builder setStatus(IssueStatus status) {
            this.status = status;
            return this;
        }

        public Builder setAssignee(String assignee) {
            this.assignee = assignee;
            return this;
        }

        public Builder setReporter(String reporter) {
            this.reporter = reporter;
            return this;
        }

        public Builder setProduct(String product) {
            this.product = product;
            return this;
        }

        public Builder setComponent(String component) {
            this.component = component;
            return this;
        }

        public Builder setStage(Stage stage) {
            this.stage = stage;
            return this;
        }

        public Builder setRelease(Release release) {
            this.release = release;
            return this;
        }

        public Builder setStreams(Map<Stream, FlagStatus> streams) {
            this.streams = streams;
            return this;
        }

        public Builder setStartDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public SearchCriteria build() {
            return new SearchCriteria(this.status, this.assignee, this.reporter, this.product, this.component, this.stage, this.release, this.streams, this.startDate, this.maxResults);
        }
    }
}

