/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.set.aphrodite.domain.StreamComponent;

public class Stream {
    private final String name;
    private final Stream upstream;
    private final Map<String, StreamComponent> components;

    public Stream() {
        this("N/A");
    }

    public Stream(String name) {
        this(name, null);
    }

    public Stream(String name, Stream upstream) {
        this(name, upstream, new HashMap<String, StreamComponent>());
    }

    public Stream(String name, Stream upstream, Map<String, StreamComponent> components) {
        this.name = name;
        this.upstream = upstream;
        this.components = components;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasUpstream() {
        return this.upstream != null;
    }

    public Stream getUpstream() {
        return this.upstream;
    }

    public Collection<StreamComponent> getAllComponents() {
        return this.components.values();
    }

    public void addComponent(StreamComponent component) {
        this.components.put(component.getName(), component);
    }

    public StreamComponent getComponent(String componentName) {
        return this.components.get(componentName.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stream stream = (Stream)o;
        return this.name.equals(stream.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Stream{name='" + this.name + '\'' + ", upstream=" + this.upstream + ", components=" + this.components + '}';
    }
}

