/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.domain;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import org.jboss.set.aphrodite.container.Container;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.MergeableState;
import org.jboss.set.aphrodite.domain.PullRequestState;
import org.jboss.set.aphrodite.domain.PullRequestUpgrade;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.domain.internal.URLUtils;
import org.jboss.set.aphrodite.domain.spi.PullRequestHome;

public class PullRequest {
    private static final Pattern UPGRADE_TITLE = Pattern.compile("\\s*Upgrade \\s*", 2);
    private static final Pattern UPSTREAM_ISSUE_NOT_REQUIRED = Pattern.compile("\\s*Upstream not required.*$", 10);
    private static final Pattern NO_UPSTREAM_REQUIRED = Pattern.compile("\\s*No upstream required.*$", 10);
    private static final Pattern UPSTREAM_PR = Pattern.compile("^\\s*\\[?Upstream PR[:|]\\s*+(http|ftp|https)://(\\w+(:\\w+)@)?([a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]+(/[\\w.@?^=%&:/~+#-]*)?\\]?", 10);
    private static final Pattern UPSTREAM_ISSUE = Pattern.compile("^\\s*Upstream Issue[:|]\\s*+(http|ftp|https)://(\\w+(:\\w+)@)?([a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]+(/[\\w.@?^=%&:/~+#-]*)?", 10);
    private static final Pattern ISSUE = Pattern.compile("^\\s*Issue[:|]\\s*+(http|ftp|https)://(\\w+(:\\w+)@)?([a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]+(/[\\w.@?^=%&:/~+#-]*)?", 10);
    private static final Pattern RELATED_ISSUES = Pattern.compile("^\\s*\\[?Related Issue[s|][:|]\\s*+(http|ftp|https)://(\\w+(:\\w+)@)?([a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]+(/[\\w.@?^=%&:/~+#-]*)?(,\\s*+(http|ftp|https)://(\\w+(:\\w+)@)?([a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]+(/[\\w.@?^=%&:/~+#-]*)?)*+\\]?", 10);
    private static final String UPGRADE_META_BIT_REGEX = "\\w++=\\w++";
    private static final String UPGRADE_META_REGEX = "\\s*+\\w++=\\w++(,\\s*+\\w++=\\w++)*+";
    private static final Pattern UPGRADE = Pattern.compile("\\s*Upgrade[:|]\\s*+\\w++=\\w++(,\\s*+\\w++=\\w++)*+", 10);
    private final String id;
    private final URL url;
    private final Codebase codebase;
    private PullRequestState state;
    private String title;
    private String body;
    private Repository repository;
    private boolean mergeable;
    private boolean merged;
    private boolean upgrade;
    private MergeableState mergableState;
    private Date mergedAt;

    public PullRequest(String id, URL url, Repository repository, Codebase codebase, PullRequestState state, String title, String body, boolean mergeable, boolean merged, MergeableState mergeableState, Date mergedAt) {
        this.id = id;
        this.url = url;
        this.codebase = codebase;
        this.state = state;
        this.title = title;
        this.body = body;
        this.repository = repository;
        this.mergeable = mergeable;
        this.merged = merged;
        this.mergedAt = mergedAt;
        if (this.title != null) {
            this.upgrade = UPGRADE_TITLE.matcher(this.title).find();
        }
    }

    public String getId() {
        return this.id;
    }

    public URL getURL() {
        return this.url;
    }

    public Codebase getCodebase() {
        return this.codebase;
    }

    public PullRequestState getState() {
        return this.state;
    }

    public void setState(PullRequestState state) {
        this.state = state;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public boolean isUpstreamRequired() {
        Matcher m1 = UPSTREAM_ISSUE_NOT_REQUIRED.matcher(this.body);
        Matcher m2 = NO_UPSTREAM_REQUIRED.matcher(this.body);
        return !m1.find() && !m2.find();
    }

    public URL findUpstreamPullRequestURL() throws MalformedURLException {
        if (this.isUpstreamRequired()) {
            String[] url = URLUtils.extractURLs(this.body, UPSTREAM_PR, false);
            if (url == null || url.length == 0 || url[0] == null) {
                return null;
            }
            return new URL(url[0]);
        }
        return null;
    }

    public URL findUpstreamIssueURL() throws MalformedURLException {
        if (this.isUpstreamRequired()) {
            String[] url = URLUtils.extractURLs(this.body, UPSTREAM_ISSUE, false);
            if (url == null || url.length == 0 || url[0] == null) {
                return null;
            }
            return new URL(url[0]);
        }
        return null;
    }

    public URL findIssueURL() throws MalformedURLException {
        String[] url = URLUtils.extractURLs(this.body, ISSUE, false);
        if (url == null || url.length == 0 || url[0] == null) {
            return null;
        }
        return new URL(url[0]);
    }

    public List<URL> findRelatedIssuesURL() throws MalformedURLException {
        String[] urls = URLUtils.extractURLs(this.body, RELATED_ISSUES, true);
        if (urls == null || urls.length == 0 || urls[0] == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> issues = new ArrayList<URL>(urls.length);
        for (String url : urls) {
            issues.add(new URL(url));
        }
        return issues;
    }

    public boolean hasUpgradeMeta() {
        Matcher m = UPGRADE.matcher(this.body);
        return m.find();
    }

    public boolean hasUpgrade() {
        Matcher m = UPGRADE.matcher(this.body);
        return m.find();
    }

    public PullRequestUpgrade findPullRequestUpgrade() {
        Matcher m = UPGRADE.matcher(this.body);
        if (!m.find()) {
            return null;
        }
        String upgradeBody = this.body.substring(m.start(), m.end());
        m = Pattern.compile(UPGRADE_META_BIT_REGEX).matcher(upgradeBody);
        Properties metas = new Properties();
        while (m.find()) {
            String[] x = upgradeBody.substring(m.start(), m.end()).split("=");
            metas.put(x[0], x[1]);
        }
        return new PullRequestUpgrade(this, metas.getProperty("id"), metas.getProperty("tag"), metas.getProperty("version"), metas.getProperty("branch"));
    }

    public List<PullRequest> findReferencedPullRequests() throws NameNotFoundException {
        return ((PullRequestHome)Container.instance().lookup(PullRequestHome.class.getSimpleName(), PullRequestHome.class)).findReferencedPullRequests(this);
    }

    public boolean addComment(String comment) throws NameNotFoundException {
        return ((PullRequestHome)Container.instance().lookup(PullRequestHome.class.getSimpleName(), PullRequestHome.class)).addComment(this, comment);
    }

    public List<Label> getLabels() throws NameNotFoundException {
        return ((PullRequestHome)Container.instance().lookup(PullRequestHome.class.getSimpleName(), PullRequestHome.class)).getLabels(this);
    }

    public boolean setLabels(List<Label> labels) throws NameNotFoundException {
        return ((PullRequestHome)Container.instance().lookup(PullRequestHome.class.getSimpleName(), PullRequestHome.class)).setLabels(this, labels);
    }

    public boolean addLabel(Label label) throws NameNotFoundException {
        return ((PullRequestHome)Container.instance().lookup(PullRequestHome.class.getSimpleName(), PullRequestHome.class)).addLabel(this, label);
    }

    public boolean removeLabel(Label label) throws NameNotFoundException {
        return ((PullRequestHome)Container.instance().lookup(PullRequestHome.class.getSimpleName(), PullRequestHome.class)).removeLabel(this, label);
    }

    public CommitStatus getCommitStatus() throws NameNotFoundException {
        return ((PullRequestHome)Container.instance().lookup(PullRequestHome.class.getSimpleName(), PullRequestHome.class)).getCommitStatus(this);
    }

    public void approveOnPullRequest() throws NameNotFoundException {
        ((PullRequestHome)Container.instance().lookup(PullRequestHome.class.getSimpleName(), PullRequestHome.class)).approveOnPullRequest(this);
    }

    public void requestChangesOnPullRequest(String comment) throws NameNotFoundException {
        ((PullRequestHome)Container.instance().lookup(PullRequestHome.class.getSimpleName(), PullRequestHome.class)).requestChangesOnPullRequest(this, comment);
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public MergeableState getMergableState() {
        return this.mergableState;
    }

    public Date getMergedAt() {
        return this.mergedAt;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PullRequest pullRequset = (PullRequest)o;
        return this.url.equals(pullRequset.url);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public String toString() {
        return "PullRequest{url=" + this.url + ", state=" + (Object)((Object)this.state) + ", title='" + this.title + '\'' + ", body='" + this.body + '\'' + ", codebase=" + this.codebase + '}';
    }
}

