/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.github;

import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.PullRequestState;
import org.jboss.set.aphrodite.domain.RateLimit;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.repository.services.common.AbstractRepositoryService;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.repository.services.github.GitHubWrapper;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.aphrodite.spi.RepositoryService;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.extras.OkHttpConnector;

public class GitHubRepositoryService
extends AbstractRepositoryService {
    private static final Log LOG = LogFactory.getLog(RepositoryService.class);
    private final GitHubWrapper WRAPPER = new GitHubWrapper();
    private static final int DEFAULT_CACHE_SIZE = 20;
    private String cacheDir;
    private String cacheName;
    private String cacheSize;
    private File cacheFile;
    private Cache cache;
    private GitHub github;
    private static final Pattern RELATED_PR_PATTERN = Pattern.compile(".*github\\.com.*?/([a-zA-Z_0-9-]*)/([a-zA-Z_0-9-]*)/pull.?/(\\d+)", 2);
    private static final Pattern ABBREVIATED_RELATED_PR_PATTERN = Pattern.compile("([a-zA-Z_0-9-//]*)#(\\d+)", 2);
    private static final Pattern ABBREVIATED_RELATED_PR_PATTERN_EXTERNAL_REPO = Pattern.compile("([a-zA-Z_0-9-]*)/([a-zA-Z_0-9-]*)#(\\d+)", 2);

    public GitHubRepositoryService() {
        super(RepositoryType.GITHUB);
    }

    protected Log getLog() {
        return LOG;
    }

    public boolean init(RepositoryConfig config) {
        block8: {
            boolean parentInitiated = super.init(config);
            if (!parentInitiated) {
                return false;
            }
            this.cacheDir = System.getProperty("cacheDir");
            this.cacheName = System.getProperty("cacheName");
            try {
                if (this.cacheDir == null || this.cacheName == null) {
                    this.github = GitHub.connect((String)config.getUsername(), (String)config.getPassword());
                    break block8;
                }
                this.cacheFile = new File(this.cacheDir, this.cacheName);
                this.cacheSize = System.getProperty("cacheSize");
                if (this.cacheSize == null) {
                    this.cache = new Cache(this.cacheFile, 0x1400000L);
                } else {
                    int size = 20;
                    try {
                        size = Integer.valueOf(this.cacheSize);
                    }
                    catch (NumberFormatException e) {
                        Utils.logWarnMessage((Log)LOG, (String)(this.cacheSize + " is not a valid cache size. Use default size 20MB."));
                    }
                    this.cache = new Cache(this.cacheFile, (long)(size * 1024 * 1024));
                }
                this.github = new GitHubBuilder().withOAuthToken(config.getPassword(), config.getUsername()).withConnector((HttpConnector)new OkHttpConnector(new OkUrlFactory(new OkHttpClient().setCache(this.cache)))).build();
            }
            catch (IOException e) {
                Utils.logException((Log)LOG, (String)("Authentication failed for RepositoryService: " + ((Object)((Object)this)).getClass().getName()), (Exception)e);
                return false;
            }
        }
        return true;
    }

    public PullRequest getPullRequest(URL url) throws NotFoundException {
        this.checkHost(url);
        String[] elements = url.getPath().split("/");
        int pullId = Integer.parseInt(elements[elements.length - 1]);
        String repositoryId = this.createFromUrl(url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHPullRequest pullRequest = repository.getPullRequest(pullId);
            return this.WRAPPER.pullRequestToPullRequest(pullRequest);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    public Repository getRepository(URL url) throws NotFoundException {
        this.checkHost(url);
        String repositoryId = this.createFromUrl(url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            Collection<GHBranch> branches = repository.getBranches().values();
            return this.WRAPPER.toAphroditeRepository(url, branches);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    public List<PullRequest> getPullRequestsByState(Repository repository, PullRequestState state) throws NotFoundException {
        URL url = repository.getURL();
        this.checkHost(url);
        String repositoryId = this.createFromUrl(url);
        try {
            GHIssueState issueState;
            GHRepository githubRepository = this.github.getRepository(repositoryId);
            try {
                issueState = GHIssueState.valueOf((String)state.toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                issueState = GHIssueState.OPEN;
            }
            List pullRequests = githubRepository.getPullRequests(issueState);
            return this.WRAPPER.toAphroditePullRequests(pullRequests);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    public void addCommentToPullRequest(PullRequest pullRequest, String comment) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        int id = Integer.parseInt(pullRequest.getId());
        String repositoryId = this.createFromUrl(url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(id);
            issue.comment(comment);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    public boolean hasModifiableLabels(Repository repository) throws NotFoundException {
        URL url = repository.getURL();
        this.checkHost(url);
        String repositoryId = this.createFromUrl(url);
        try {
            GHMyself myself = this.github.getMyself();
            GHRepository githubRepository = this.github.getRepository(repositoryId);
            Set collaborators = githubRepository.listCollaborators().asSet();
            return collaborators.stream().anyMatch(e -> e.getLogin().equals(myself.getLogin()));
        }
        catch (Throwable t) {
            if (t.getMessage().contains("Must have push access")) {
                return false;
            }
            Exception e2 = (Exception)t;
            Utils.logException((Log)LOG, (Exception)e2);
            throw new NotFoundException((Throwable)e2);
        }
    }

    public void addLabelToPullRequest(PullRequest pullRequest, String labelName) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        int pullRequestId = new Integer(Utils.getTrailingValueFromUrlPath((URL)url));
        String repositoryId = this.createFromUrl(url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHLabel newLabel = this.getLabel(repository, labelName);
            GHIssue issue = repository.getIssue(pullRequestId);
            Collection labels = issue.getLabels();
            if (labels.contains(newLabel)) {
                return;
            }
            List<String> list = labels.stream().map(e -> e.getName()).collect(Collectors.toList());
            list.add(newLabel.getName());
            String[] labelArray = list.toArray(new String[list.size()]);
            issue.setLabels(labelArray);
        }
        catch (IOException e2) {
            Utils.logException((Log)LOG, (Exception)e2);
            throw new NotFoundException((Throwable)e2);
        }
    }

    private GHLabel getLabel(GHRepository repository, String labelName) throws NotFoundException, IOException {
        List labels = repository.listLabels().asList();
        return this.getLabel(repository, labelName, labels);
    }

    private GHLabel getLabel(GHRepository repository, String labelName, List<GHLabel> validLabels) throws NotFoundException {
        for (GHLabel label : validLabels) {
            if (!label.getName().equalsIgnoreCase(labelName)) continue;
            return label;
        }
        throw new NotFoundException("No label exists with the name '" + labelName + "' at repository '" + repository.getName() + "'");
    }

    public List<Label> getLabelsFromRepository(Repository repository) throws NotFoundException {
        List labels;
        URL url = repository.getURL();
        this.checkHost(url);
        String repositoryId = this.createFromUrl(url);
        try {
            GHRepository githubRepository = this.github.getRepository(repositoryId);
            labels = githubRepository.listLabels().asList();
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
        return this.WRAPPER.pullRequestLabeltoPullRequestLabel(labels);
    }

    public List<Label> getLabelsFromPullRequest(PullRequest pullRequest) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        String repositoryId = this.createFromUrl(url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(Integer.parseInt(pullRequest.getId()));
            return this.WRAPPER.pullRequestLabeltoPullRequestLabel(issue.getLabels());
        }
        catch (IOException | NumberFormatException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    public void setLabelsToPullRequest(PullRequest pullRequest, List<Label> labels) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        int pullRequestId = new Integer(Utils.getTrailingValueFromUrlPath((URL)url));
        String repositoryId = this.createFromUrl(url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(pullRequestId);
            ArrayList<Object> issueLabels = new ArrayList<Object>();
            List existingLabels = repository.listLabels().asList();
            for (Label label : labels) {
                issueLabels.add(this.getLabel(repository, label.getName(), existingLabels));
            }
            issueLabels.add(existingLabels.get(0));
            List<String> list = issueLabels.stream().map(e -> e.getName()).collect(Collectors.toList());
            String[] labelArray = list.toArray(new String[list.size()]);
            issue.setLabels(labelArray);
        }
        catch (IOException e2) {
            Utils.logException((Log)LOG, (Exception)e2);
            throw new NotFoundException((Throwable)e2);
        }
    }

    public void removeLabelFromPullRequest(PullRequest pullRequest, String name) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        int pullRequestId = new Integer(Utils.getTrailingValueFromUrlPath((URL)url));
        String repositoryId = this.createFromUrl(url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            GHIssue issue = repository.getIssue(pullRequestId);
            Collection labels = issue.getLabels();
            for (GHLabel label : labels) {
                if (!label.getName().equalsIgnoreCase(name)) continue;
                List<String> list = labels.stream().map(e -> e.getName()).collect(Collectors.toList());
                list.remove(label.getName());
                String[] labelArray = list.toArray(new String[list.size()]);
                issue.setLabels(labelArray);
                return;
            }
        }
        catch (IOException e2) {
            Utils.logException((Log)LOG, (Exception)e2);
            throw new NotFoundException((Throwable)e2);
        }
        throw new NotFoundException("No label exists with the name '" + name + "' at repository '" + repositoryId + "'");
    }

    public List<PullRequest> findPullRequestsRelatedTo(PullRequest pullRequest) {
        try {
            List<URL> urls = this.getPRFromDescription(pullRequest.getURL(), pullRequest.getBody());
            ArrayList<PullRequest> related = new ArrayList<PullRequest>();
            for (URL url : urls) {
                try {
                    if (this.urlExists(url)) {
                        related.add(this.getPullRequest(url));
                        continue;
                    }
                    Utils.logWarnMessage((Log)LOG, (String)("Unable to process url '" + url + "' as it is not located on this service"));
                }
                catch (NotFoundException e) {
                    Utils.logException((Log)LOG, (String)("Unable to retrieve url '" + url + "' referenced in the pull request at: " + pullRequest.getURL()), (Exception)((Object)e));
                }
            }
            return related;
        }
        catch (MalformedURLException | URISyntaxException e) {
            Utils.logException((Log)LOG, (String)("something went wrong while trying to get related pull requests to " + pullRequest.getURL()), (Exception)e);
            return Collections.emptyList();
        }
    }

    private List<URL> getPRFromDescription(URL url, String content) throws MalformedURLException, URISyntaxException {
        String[] paths = url.getPath().split("/");
        Matcher matcher = RELATED_PR_PATTERN.matcher(content);
        ArrayList<URL> relatedPullRequests = new ArrayList<URL>();
        while (matcher.find()) {
            if (matcher.groupCount() != 3) continue;
            URL relatedPullRequest = new URI("https://github.com/" + matcher.group(1) + "/" + matcher.group(2) + "/pulls/" + matcher.group(3)).toURL();
            relatedPullRequests.add(relatedPullRequest);
        }
        Matcher abbreviatedMatcher = ABBREVIATED_RELATED_PR_PATTERN.matcher(content);
        while (abbreviatedMatcher.find()) {
            URL relatedPullRequest;
            String match = abbreviatedMatcher.group();
            Matcher abbreviatedExternalMatcher = ABBREVIATED_RELATED_PR_PATTERN_EXTERNAL_REPO.matcher(match);
            if (abbreviatedExternalMatcher.find() && abbreviatedExternalMatcher.groupCount() == 3) {
                relatedPullRequest = new URI("https://github.com/" + abbreviatedExternalMatcher.group(1) + "/" + abbreviatedExternalMatcher.group(2) + "/pulls/" + abbreviatedExternalMatcher.group(3)).toURL();
                relatedPullRequests.add(relatedPullRequest);
                continue;
            }
            if (abbreviatedMatcher.groupCount() != 2) continue;
            relatedPullRequest = new URI("https://github.com/" + paths[1] + "/" + paths[2] + "/" + "/pulls/" + abbreviatedMatcher.group(2)).toURL();
            relatedPullRequests.add(relatedPullRequest);
        }
        return relatedPullRequests;
    }

    public CommitStatus getCommitStatusFromPullRequest(PullRequest pullRequest) throws NotFoundException {
        URL url = pullRequest.getURL();
        this.checkHost(url);
        CommitStatus status = null;
        int pullRequestId = Integer.parseInt(pullRequest.getId());
        String repositoryId = this.createFromUrl(url);
        try {
            GHCommitState sta;
            List statuses;
            String sha = null;
            GHRepository repository = this.github.getRepository(repositoryId);
            GHPullRequest ghPullRequest = repository.getPullRequest(pullRequestId);
            List commits = ghPullRequest.listCommits().asList();
            if (commits.size() > 0) {
                sha = ((GHPullRequestCommitDetail)commits.get(commits.size() - 1)).getSha();
            }
            if ((statuses = repository.listCommitStatuses(sha).asList()).size() > 0 && (sta = this.getCombineStatus(statuses)) != null) {
                status = CommitStatus.fromString((String)sta.toString());
            }
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
        if (status != null) {
            return status;
        }
        return CommitStatus.UNKNOWN;
    }

    private GHCommitState getCombineStatus(List<GHCommitStatus> comStatuses) {
        int count = 0;
        boolean flag = false;
        ArrayList<GHCommitState> stas = new ArrayList<GHCommitState>();
        for (GHCommitStatus status : comStatuses) {
            GHCommitState sta = status.getState();
            stas.add(sta);
            if (!sta.equals((Object)GHCommitState.PENDING)) {
                if (sta.equals((Object)GHCommitState.FAILURE)) {
                    return GHCommitState.FAILURE;
                }
                if (sta.equals((Object)GHCommitState.ERROR)) {
                    return GHCommitState.ERROR;
                }
            } else {
                flag = true;
                String description = status.getDescription();
                if (description != null && description.contains("Travis")) {
                    return stas.contains(GHCommitState.SUCCESS) ? GHCommitState.SUCCESS : GHCommitState.PENDING;
                }
                if (comStatuses.size() > 2 * count) {
                    GHCommitState temp = comStatuses.get(2 * count).getState();
                    return temp.equals((Object)GHCommitState.PENDING) ? GHCommitState.PENDING : GHCommitState.SUCCESS;
                }
                if (comStatuses.size() == 2 * count) {
                    return GHCommitState.SUCCESS;
                }
            }
            ++count;
        }
        return !flag ? GHCommitState.SUCCESS : null;
    }

    public boolean repositoryAccessable(URL url) {
        if (url.toString().contains("svn.jboss.org")) {
            Utils.logWarnMessage((Log)LOG, (String)("svn repository : " + url + " is not supported."));
            return false;
        }
        String repositoryId = this.createFromUrl(url);
        try {
            GHRepository repository = this.github.getRepository(repositoryId);
            repository.getBranches();
        }
        catch (IOException e) {
            Utils.logWarnMessage((Log)LOG, (String)("repository : " + url + " is not accessable due to " + e.getMessage() + ". Check repository link and your account permission."));
            return false;
        }
        return true;
    }

    public RateLimit getRateLimit() throws NotFoundException {
        try {
            GHRateLimit ghRateLimit = this.github.getRateLimit();
            return this.WRAPPER.ghRateLimittoRateLimit(ghRateLimit);
        }
        catch (IOException e) {
            Utils.logException((Log)LOG, (Exception)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    public RepositoryType getRepositoryType() {
        return this.REPOSITORY_TYPE;
    }
}

