/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.github;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Label;
import org.jboss.set.aphrodite.domain.MergeableState;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.PullRequestState;
import org.jboss.set.aphrodite.domain.RateLimit;
import org.jboss.set.aphrodite.domain.Repository;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRateLimit;

class GitHubWrapper {
    GitHubWrapper() {
    }

    Repository toAphroditeRepository(URL url, Collection<GHBranch> branches) {
        Repository repo = new Repository(url);
        List branchNames = branches.stream().map(this::repositoryBranchToCodebase).collect(Collectors.toList());
        repo.getCodebases().addAll(branchNames);
        return repo;
    }

    List<PullRequest> toAphroditePullRequests(List<GHPullRequest> pullRequests) {
        return pullRequests.stream().map(this::pullRequestToPullRequest).collect(Collectors.toList());
    }

    PullRequest pullRequestToPullRequest(GHPullRequest pullRequest) {
        try {
            String id = Integer.toString(pullRequest.getNumber());
            URL url = pullRequest.getHtmlUrl();
            Codebase codebase = new Codebase(pullRequest.getBase().getRef());
            PullRequestState state = GitHubWrapper.getPullRequestState(pullRequest.getState());
            String title = pullRequest.getTitle() == null ? "" : pullRequest.getTitle().replaceFirst("\\u2026", "");
            String body = pullRequest.getBody() == null ? "" : pullRequest.getBody().replaceFirst("\\u2026", "");
            boolean mergeable = pullRequest.getMergeable();
            boolean merged = pullRequest.isMerged();
            Date mergedAt = pullRequest.getMergedAt();
            MergeableState mergeableState = pullRequest.getMergeableState() == null ? null : MergeableState.valueOf((String)pullRequest.getMergeableState().toUpperCase());
            String urlString = url.toString();
            int idx = urlString.indexOf("pull");
            if (idx >= 0) {
                urlString = urlString.substring(0, idx);
            }
            Repository repo = new Repository(URI.create(urlString).toURL());
            return new PullRequest(id, url, repo, codebase, state, title, body, mergeable, merged, mergeableState, mergedAt);
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<Label> pullRequestLabeltoPullRequestLabel(Collection<GHLabel> labels) {
        ArrayList<Label> patchLabels = new ArrayList<Label>();
        for (GHLabel label : labels) {
            String name = label.getName();
            String color = label.getColor();
            String url = label.getUrl();
            patchLabels.add(new Label(color, name, url));
        }
        return patchLabels;
    }

    public static PullRequestState getPullRequestState(GHIssueState state) {
        try {
            return PullRequestState.valueOf((String)state.toString().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return PullRequestState.UNDEFINED;
        }
    }

    public RateLimit ghRateLimittoRateLimit(GHRateLimit ghRateLimit) {
        return new RateLimit(ghRateLimit.remaining, ghRateLimit.limit, ghRateLimit.reset);
    }

    private Codebase repositoryBranchToCodebase(GHBranch branch) {
        return new Codebase(branch.getName());
    }
}

