/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.gitlab;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.CommitStatusFilter;
import org.gitlab4j.api.models.Label;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.MergeRequestParams;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.Commit;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.spi.PullRequestHome;
import org.jboss.set.aphrodite.repository.services.gitlab.GitLabRepositoryService;
import org.jboss.set.aphrodite.repository.services.gitlab.GitLabUtils;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class GitLabPullRequestHomeService
implements PullRequestHome {
    private static final Log LOG = LogFactory.getLog(GitLabPullRequestHomeService.class);
    private final GitLabApi gitLabApi;
    private final GitLabRepositoryService gitLabRepo;
    private final Pattern prPattern;

    public GitLabPullRequestHomeService(GitLabApi gitLabApi, GitLabRepositoryService gitLabRepo) {
        this.gitLabApi = gitLabApi;
        this.gitLabRepo = gitLabRepo;
        String patternString = ".*" + Pattern.quote(gitLabRepo.getBaseUrl().getHost()) + ".*?/([a-zA-Z_0-9-]*)/([a-zA-Z_0-9-]*)/-?/?merge_requests/(\\d+)";
        this.prPattern = Pattern.compile(patternString, 2);
    }

    public boolean addComment(PullRequest pullRequest, String comment) {
        String repoId = GitLabUtils.getProjectIdFromURL(pullRequest.getRepository().getURL());
        int mergeId = Integer.parseInt(pullRequest.getId());
        try {
            this.gitLabApi.getDiscussionsApi().createMergeRequestDiscussion((Object)repoId, Integer.valueOf(mergeId), comment, new Date(), null, null);
            return true;
        }
        catch (GitLabApiException e) {
            LOG.debug((Object)"addComment error", (Throwable)e);
            return false;
        }
    }

    public List<org.jboss.set.aphrodite.domain.Label> getLabels(PullRequest pullRequest) {
        String repoId = GitLabUtils.getProjectIdFromURL(pullRequest.getRepository().getURL());
        int mergeId = Integer.parseInt(pullRequest.getId());
        try {
            MergeRequest merge = this.gitLabApi.getMergeRequestApi().getMergeRequest((Object)repoId, Integer.valueOf(mergeId));
            List labels = merge.getLabels();
            ArrayList<org.jboss.set.aphrodite.domain.Label> res = new ArrayList<org.jboss.set.aphrodite.domain.Label>(labels.size());
            for (String name : labels) {
                Label l = this.gitLabApi.getLabelsApi().getProjectLabel((Object)repoId, (Object)name);
                res.add(GitLabUtils.toLabel(l, pullRequest.getRepository().getURL()));
            }
            return res;
        }
        catch (GitLabApiException e) {
            Utils.logException((Log)LOG, (String)"Error getting the labels", (Exception)((Object)e));
            return Collections.emptyList();
        }
    }

    public boolean setLabels(PullRequest pullRequest, List<org.jboss.set.aphrodite.domain.Label> labels) {
        String repoId = GitLabUtils.getProjectIdFromURL(pullRequest.getRepository().getURL());
        int mergeId = Integer.parseInt(pullRequest.getId());
        try {
            List names = labels.stream().map(org.jboss.set.aphrodite.domain.Label::getName).collect(Collectors.toList());
            this.gitLabApi.getMergeRequestApi().updateMergeRequest((Object)repoId, Integer.valueOf(mergeId), new MergeRequestParams().withLabels(names));
            return true;
        }
        catch (GitLabApiException e) {
            Utils.logException((Log)LOG, (String)"Error setting the labels", (Exception)((Object)e));
            return false;
        }
    }

    public boolean addLabel(PullRequest pullRequest, org.jboss.set.aphrodite.domain.Label label) {
        String repoId = GitLabUtils.getProjectIdFromURL(pullRequest.getRepository().getURL());
        int mergeId = Integer.parseInt(pullRequest.getId());
        try {
            MergeRequest merge = this.gitLabApi.getMergeRequestApi().getMergeRequest((Object)repoId, Integer.valueOf(mergeId));
            List names = merge.getLabels();
            if (!names.contains(label.getName())) {
                names.add(label.getName());
                this.gitLabApi.getMergeRequestApi().updateMergeRequest((Object)repoId, Integer.valueOf(mergeId), new MergeRequestParams().withLabels(names));
                return true;
            }
        }
        catch (GitLabApiException e) {
            Utils.logException((Log)LOG, (String)"Error adding the label", (Exception)((Object)e));
        }
        return false;
    }

    public boolean removeLabel(PullRequest pullRequest, org.jboss.set.aphrodite.domain.Label label) {
        String repoId = GitLabUtils.getProjectIdFromURL(pullRequest.getRepository().getURL());
        int mergeId = Integer.parseInt(pullRequest.getId());
        try {
            MergeRequest merge = this.gitLabApi.getMergeRequestApi().getMergeRequest((Object)repoId, Integer.valueOf(mergeId));
            List names = merge.getLabels();
            if (names.remove(label.getName())) {
                this.gitLabApi.getMergeRequestApi().updateMergeRequest((Object)repoId, Integer.valueOf(mergeId), new MergeRequestParams().withLabels(names));
                return true;
            }
        }
        catch (GitLabApiException e) {
            Utils.logException((Log)LOG, (String)"Error removing the label", (Exception)((Object)e));
        }
        return false;
    }

    private List<URL> getPRFromDescription(URL url, String content) throws MalformedURLException, URISyntaxException {
        Matcher gitlabMatcher = this.prPattern.matcher(content);
        ArrayList<URL> relatedPullRequests = new ArrayList<URL>();
        while (gitlabMatcher.find()) {
            if (gitlabMatcher.groupCount() != 3) continue;
            URL relatedPullRequest = new URI(this.gitLabRepo.getBaseUrl() + gitlabMatcher.group(1) + "/" + gitlabMatcher.group(2) + "/-/merge_requests/" + gitlabMatcher.group(3)).toURL();
            relatedPullRequests.add(relatedPullRequest);
        }
        return relatedPullRequests;
    }

    public List<PullRequest> findReferencedPullRequests(PullRequest pullRequest) {
        try {
            List<URL> urls = this.getPRFromDescription(pullRequest.getURL(), pullRequest.getBody());
            ArrayList<PullRequest> related = new ArrayList<PullRequest>();
            for (URL url : urls) {
                if (!GitLabUtils.urlIsInRepo(url, pullRequest.getRepository().getURL())) continue;
                try {
                    related.add(this.gitLabRepo.getPullRequest(url));
                }
                catch (NotFoundException e) {
                    Utils.logException((Log)LOG, (String)("Unable to retrieve url '" + url + "' referenced in the pull request."), (Exception)((Object)e));
                }
            }
            return related;
        }
        catch (MalformedURLException | URISyntaxException e) {
            Utils.logException((Log)LOG, (String)("something went wrong while trying to get related pull requests to " + pullRequest.getURL()), (Exception)e);
            return Collections.emptyList();
        }
    }

    public CommitStatus getCommitStatus(PullRequest pullRequest) {
        String repoId = GitLabUtils.getProjectIdFromURL(pullRequest.getRepository().getURL());
        int mergeId = Integer.parseInt(pullRequest.getId());
        try {
            List commits = pullRequest.getCommits();
            if (commits != null && !commits.isEmpty()) {
                String sha = ((Commit)commits.get(commits.size() - 1)).getSha();
                CommitStatusFilter filter = new CommitStatusFilter().withAll(Boolean.valueOf(true));
                List statuses = this.gitLabApi.getCommitsApi().getCommitStatuses((Object)repoId, sha, filter);
                if (!statuses.isEmpty()) {
                    return GitLabUtils.toCommitStatus(((org.gitlab4j.api.models.CommitStatus)statuses.iterator().next()).getStatus());
                }
            }
            return CommitStatus.UNKNOWN;
        }
        catch (GitLabApiException e) {
            Utils.logException((Log)LOG, (Exception)((Object)e));
            return CommitStatus.UNKNOWN;
        }
    }

    public void approveOnPullRequest(PullRequest pullRequest) {
        String repoId = GitLabUtils.getProjectIdFromURL(pullRequest.getRepository().getURL());
        int mergeId = Integer.parseInt(pullRequest.getId());
        try {
            this.gitLabApi.getMergeRequestApi().approveMergeRequest((Object)repoId, Integer.valueOf(mergeId), null);
        }
        catch (GitLabApiException e) {
            LOG.error((Object)"Error approving the request", (Throwable)e);
        }
    }

    public void requestChangesOnPullRequest(PullRequest pullRequest, String body) {
        String repoId = GitLabUtils.getProjectIdFromURL(pullRequest.getRepository().getURL());
        int mergeId = Integer.parseInt(pullRequest.getId());
        try {
            this.gitLabApi.getMergeRequestApi().unapproveMergeRequest((Object)repoId, Integer.valueOf(mergeId));
        }
        catch (GitLabApiException e) {
            Utils.logException((Log)LOG, (Exception)((Object)e));
        }
    }
}

