/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.gitlab;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gitlab4j.api.models.Label;
import org.gitlab4j.api.models.MergeRequest;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Commit;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.MergeableState;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.PullRequestState;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.domain.spi.PullRequestHome;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class GitLabUtils {
    private static final Log LOG = LogFactory.getLog(GitLabUtils.class);

    public static String getProjectIdFromURL(URL url) {
        try {
            url = url.toURI().normalize().toURL();
            String[] path = url.getPath().split("/");
            String projectId = null;
            boolean done = false;
            for (int i = 0; i < path.length && !done; ++i) {
                if (path[i].isEmpty()) continue;
                if ("-".equals(path[i])) {
                    done = true;
                    continue;
                }
                projectId = projectId == null ? path[i] : projectId + "/" + path[i];
            }
            return projectId;
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.debug((Object)(url + "is not a valid URL"), (Throwable)e);
            return null;
        }
    }

    public static String[] getProjectIdAndLastFieldFromURL(URL url) {
        try {
            url = url.toURI().normalize().toURL();
            String[] path = url.getPath().split("/");
            String projectId = null;
            boolean done = false;
            int idx = -1;
            for (int i = 0; i < path.length && !done; ++i) {
                if (path[i].isEmpty()) continue;
                if ("-".equals(path[i])) {
                    done = true;
                    idx = i;
                    continue;
                }
                projectId = projectId == null ? path[i] : projectId + "/" + path[i];
            }
            String mergeId = null;
            if (idx != -1) {
                for (int i = path.length - 1; i > idx && mergeId == null; --i) {
                    if (path[i].isEmpty()) continue;
                    mergeId = path[i];
                }
            }
            if (projectId != null && mergeId != null) {
                return new String[]{projectId, mergeId};
            }
            return null;
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.debug((Object)(url + "is not a valid URL"), (Throwable)e);
            return null;
        }
    }

    public static boolean urlIsInRepo(URL url, URL repoUrl) {
        Objects.requireNonNull(url);
        return url.getProtocol().equals(repoUrl.getProtocol()) && url.getHost().equalsIgnoreCase(repoUrl.getHost()) && url.getPort() == repoUrl.getPort();
    }

    public static void checkIsInRepo(URL url, URL repoUrl) throws NotFoundException {
        if (!GitLabUtils.urlIsInRepo(url, repoUrl)) {
            throw new NotFoundException("Repository " + url + " cannot be found as it is not hosted on this server.");
        }
    }

    public static PullRequestState toPullRequestState(String state) {
        switch (state) {
            case "opened": {
                return PullRequestState.OPEN;
            }
            case "closed": 
            case "merged": {
                return PullRequestState.CLOSED;
            }
        }
        return PullRequestState.UNDEFINED;
    }

    public static boolean toMergeable(String mergeStatus) {
        return "can_be_merged".equals(mergeStatus);
    }

    public static CommitStatus toCommitStatus(String statusValue) {
        switch (statusValue) {
            case "pending": {
                return CommitStatus.PENDING;
            }
            case "running": {
                return CommitStatus.PENDING;
            }
            case "success": {
                return CommitStatus.SUCCESS;
            }
            case "failed": {
                return CommitStatus.FAILURE;
            }
        }
        return CommitStatus.UNKNOWN;
    }

    public static PullRequest toPullRequest(MergeRequest m, List<org.gitlab4j.api.models.Commit> commits, URL url, Repository repo, PullRequestHome prHome) {
        return new PullRequest(m.getIid().toString(), url, repo, new Codebase(m.getTargetBranch()), GitLabUtils.toPullRequestState(m.getState()), m.getTitle(), m.getDescription(), GitLabUtils.toMergeable(m.getMergeStatus()), m.getMergedAt() != null, MergeableState.UNKNOWN, m.getMergedAt(), commits.stream().map(commit -> new Commit(commit.getId(), commit.getMessage())).collect(Collectors.toList()), prHome);
    }

    public static org.jboss.set.aphrodite.domain.Label toLabel(Label l, URL repoUrl) {
        return new org.jboss.set.aphrodite.domain.Label(l.getId().toString(), l.getColor(), l.getName(), repoUrl + "/labels/" + l.getName());
    }
}

