/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

public enum JiraIssueResolution {
    DONE(1L, "DONE"),
    REJECTED(2L, "REJECTED"),
    DUPLICATE_ISSUE(3L, "DUPLICATE ISSUE"),
    INCOMPLETE_DESCRIPTION(4L, "INCOMPLETE DESCRIPTION"),
    CANNOT_REPRODUCE_BUG(5L, "CANNOT REPRODUCE BUG"),
    PARTIALLY_COMPLETED(7L, "PARTIALLY COMPLETED"),
    DEFERRED(8L, "DEFERRED"),
    WONTFIX(9L, "WON'T FIX"),
    OUT_OF_DATE(10L, "OUT OF DATE"),
    MIGRATED(11L, "MIGRATED TO ANOTHER ITS"),
    RESOLVED_AT_APACHE(12L, "RESOLVED AT APACHE"),
    UNRESOLVED(0L, "UNRESOLVED"),
    WONTDO(10000L, "WON'T DO"),
    CANNOT_REPRODUCE(10002L, "CANNOT REPRODUCE"),
    DUPLICATE(10200L, "DUPLICATE"),
    EXPLAINED(10300L, "EXPLAINED");

    private long id;
    private String label;

    private JiraIssueResolution(long id, String label) {
        this.id = id;
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    public long getId() {
        return this.id;
    }

    public static boolean hasId(long id) {
        for (JiraIssueResolution resolution : JiraIssueResolution.values()) {
            if (resolution.getId() != id) continue;
            return true;
        }
        return false;
    }

    public static JiraIssueResolution getById(long id) {
        for (JiraIssueResolution resolution : JiraIssueResolution.values()) {
            if (resolution.getId() != id) continue;
            return resolution;
        }
        throw new IllegalArgumentException("No resolution associated with id:" + id);
    }
}

