/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

import com.atlassian.jira.rest.client.api.domain.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NameNotFoundException;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.issue.trackers.jira.CandidateRelease;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssueTracker;
import org.jboss.set.aphrodite.simplecontainer.SimpleContainer;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class JiraRelease {
    private static final String PROJECT_NAME = "JBEAP";
    private Version version;
    private List<CandidateRelease> candidateReleases;
    private Set<Issue> issuesInRelease;

    public JiraRelease(Version version, List<CandidateRelease> candidateReleases) {
        this.version = version;
        this.candidateReleases = candidateReleases;
    }

    public Version getVersion() {
        return this.version;
    }

    private void addCandidateRelease(CandidateRelease cr) {
        this.candidateReleases.add(cr);
    }

    public List<CandidateRelease> getCandidateReleases() {
        return this.candidateReleases;
    }

    public Set<Issue> getIssues() {
        if (this.issuesInRelease == null) {
            HashSet<Issue> issues = new HashSet<Issue>();
            this.candidateReleases.forEach(candidateRelease -> {
                try {
                    issues.addAll(candidateRelease.getIssues());
                }
                catch (NameNotFoundException e) {
                    e.printStackTrace();
                }
            });
            this.issuesInRelease = issues;
        }
        return this.issuesInRelease;
    }

    public static Collection<JiraRelease> findAll() throws NameNotFoundException {
        HashMap releases = new HashMap();
        JiraIssueTracker issueTrackerService = (JiraIssueTracker)((Object)SimpleContainer.instance().lookup(JiraIssueTracker.class.getSimpleName(), JiraIssueTracker.class));
        Iterable<Version> versions = issueTrackerService.getVersionsByProject(PROJECT_NAME);
        versions.forEach(version -> {
            if (CandidateRelease.isGA(version.getName())) {
                try {
                    JiraRelease release = new JiraRelease((Version)version, (List<CandidateRelease>)new ArrayList<CandidateRelease>());
                    release.addCandidateRelease(new CandidateRelease((Version)version));
                    releases.put(CandidateRelease.extractVersion(version.getName()), release);
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        versions.forEach(version -> {
            if (CandidateRelease.isCR(version.getName())) {
                try {
                    String nameGA = CandidateRelease.extractVersion(version.getName());
                    if (releases.containsKey(nameGA)) {
                        ((JiraRelease)releases.get(nameGA)).addCandidateRelease(new CandidateRelease((Version)version));
                    }
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        return releases.values();
    }
}

