/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

import com.atlassian.jira.rest.client.api.domain.Version;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssueTracker;
import org.jboss.set.aphrodite.simplecontainer.SimpleContainer;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class CandidateRelease {
    private List<Issue> issues;
    public static final Pattern GA_VERSION = Pattern.compile("^[7-9]+\\.[0-9]+\\.[0-9]+\\.GA$");
    public static final Pattern VERSION_PART = Pattern.compile("^[7-9]+\\.[0-9]+\\.[0-9]+");
    public static final Pattern CR_VERSION = Pattern.compile("^[7-9]*\\.[0-9]*\\.[0-9]*\\.CR[0-9]+$");
    private String project;
    private Version releaseCandidateVersion;

    public static boolean isGA(String releaseCandidateName) {
        return GA_VERSION.matcher(releaseCandidateName).find();
    }

    public static boolean isCR(String releaseCandidateName) {
        return CR_VERSION.matcher(releaseCandidateName).find();
    }

    public CandidateRelease(String project, Version version) {
        this.project = project;
        this.releaseCandidateVersion = version;
    }

    public static String extractVersion(String name) throws NotFoundException {
        Matcher matcher = VERSION_PART.matcher(name);
        if (!matcher.find()) {
            throw new NotFoundException();
        }
        return matcher.group();
    }

    public List<Issue> getIssues() throws NameNotFoundException {
        if (this.issues == null) {
            JiraIssueTracker issueTrackerService = (JiraIssueTracker)((Object)SimpleContainer.instance().lookup(JiraIssueTracker.class.getSimpleName(), JiraIssueTracker.class));
            this.issues = issueTrackerService.getIssues(this.project, this.releaseCandidateVersion);
        }
        return this.issues;
    }
}

