/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.Patch;
import org.jboss.set.aphrodite.domain.PatchState;
import org.jboss.set.aphrodite.domain.PatchType;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.spi.PatchHome;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssue;
import org.jboss.set.aphrodite.spi.AphroditeException;
import org.jboss.set.aphrodite.spi.NotFoundException;

public class JiraPatchHomeImpl
implements PatchHome {
    private static final Log logger = LogFactory.getLog(JiraPatchHomeImpl.class);

    public Stream<Patch> findPatchesByIssue(Issue issue) {
        List<URL> urls = ((JiraIssue)issue).getPullRequests();
        return this.mapURLtoPatchStream(urls);
    }

    private Stream<Patch> mapURLtoPatchStream(List<URL> urls) {
        List list = urls.stream().map(e -> {
            PatchType patchType = this.getPatchType((URL)e);
            PatchState patchState = this.getPatchState((URL)e, patchType);
            return new Patch(e, patchType, patchState);
        }).collect(Collectors.toList());
        return list.stream();
    }

    private PatchType getPatchType(URL url) {
        String urlStr = url.toString();
        if (urlStr.contains("/pull/")) {
            return PatchType.PULLREQUEST;
        }
        if (urlStr.contains("/commit/")) {
            return PatchType.COMMIT;
        }
        return PatchType.FILE;
    }

    private PatchState getPatchState(URL url, PatchType patchType) {
        if (patchType.equals((Object)PatchType.PULLREQUEST)) {
            try {
                PullRequest pullRequest = Aphrodite.instance().getPullRequest(url);
                if (pullRequest != null && pullRequest.getState() != null) {
                    return PatchState.valueOf((String)pullRequest.getState().toString());
                }
            }
            catch (NotFoundException e) {
                Utils.logException((Log)logger, (String)("Unable to find pull request with url: " + url), (Exception)((Object)e));
            }
            catch (AphroditeException e) {
                Utils.logException((Log)logger, (Exception)((Object)e));
            }
        } else if (patchType.equals((Object)PatchType.COMMIT)) {
            return PatchState.CLOSED;
        }
        return PatchState.UNDEFINED;
    }
}

