/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.issue.trackers.jira;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.set.aphrodite.Aphrodite;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.domain.FlagStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.spi.IssueHome;
import org.jboss.set.aphrodite.issue.trackers.jira.JiraIssue;
import org.jboss.set.aphrodite.issue.trackers.jira.VersionComparator;
import org.jboss.set.aphrodite.spi.AphroditeException;

public class JiraIssueHomeImpl
implements IssueHome {
    public static final String JBEAPProject = "JBoss Enterprise Application Platform";
    private static final Log LOG = LogFactory.getLog(JiraIssueHomeImpl.class);

    public Stream<Issue> findUpstreamReferences(Issue issue) {
        if (!(issue instanceof JiraIssue)) {
            return null;
        }
        return this.filterUpstreamReferences(this.loadLinkedCloneIssues((JiraIssue)issue), (JiraIssue)issue);
    }

    public Stream<Issue> filterUpstreamReferences(List<Issue> cloneIssues, JiraIssue downstreamIssue) {
        ArrayList upstreamReferences = new ArrayList();
        cloneIssues.stream().filter(i -> JiraIssueHomeImpl.isUpstreamIssue((JiraIssue)((Object)i), downstreamIssue)).forEach(upstreamReferences::add);
        return upstreamReferences.stream();
    }

    private List<Issue> loadLinkedCloneIssues(JiraIssue jiraIssue) {
        List issues = null;
        try {
            issues = Aphrodite.instance().getIssues(jiraIssue.getLinkedCloneIssues());
        }
        catch (AphroditeException e) {
            Utils.logException((Log)LOG, (Exception)((Object)e));
        }
        return issues != null ? issues : new ArrayList();
    }

    public static boolean isUpstreamIssue(JiraIssue upstreamIssue, JiraIssue downstreamIssue) {
        if (upstreamIssue == null || downstreamIssue == null) {
            return false;
        }
        if (!JiraIssueHomeImpl.isIssueJBEAP(upstreamIssue)) {
            return true;
        }
        if (!JiraIssueHomeImpl.matchesSuffix(upstreamIssue.getSummary(), downstreamIssue.getSummary())) {
            return false;
        }
        String v1 = JiraIssueHomeImpl.extractTargetRelease(upstreamIssue.getStreamStatus());
        String v2 = JiraIssueHomeImpl.extractTargetRelease(downstreamIssue.getStreamStatus());
        if (!JiraIssueHomeImpl.isMajroAndMinorVersionNumeric(v1) || !JiraIssueHomeImpl.isMajroAndMinorVersionNumeric(v2)) {
            return false;
        }
        return VersionComparator.INSTANCE.compare(v1 = JiraIssueHomeImpl.getMajorAndMinorOf(v1), v2 = JiraIssueHomeImpl.getMajorAndMinorOf(v2)) > 0;
    }

    public static boolean isIssueJBEAP(JiraIssue issue) {
        return issue != null && issue.getProduct().isPresent() && ((String)issue.getProduct().get()).equals(JBEAPProject);
    }

    private static boolean matchesSuffix(Optional<String> summary, Optional<String> summary1) {
        if (!summary.isPresent() && !summary1.isPresent()) {
            return true;
        }
        if (summary.isPresent() && summary1.isPresent()) {
            int endOfPrefix = summary.get().indexOf(")") + 1;
            int endOfPrefix1 = summary1.get().indexOf(")") + 1;
            String trimmedSummaryWithoutPrefix = summary.get().substring(endOfPrefix).trim();
            String trimmedSummaryWithoutPrefix1 = summary1.get().substring(endOfPrefix1).trim();
            return trimmedSummaryWithoutPrefix.equals(trimmedSummaryWithoutPrefix1);
        }
        return false;
    }

    private static String extractTargetRelease(Map<String, FlagStatus> streamStatus) {
        return streamStatus.size() > 0 ? streamStatus.keySet().iterator().next() : "";
    }

    private static boolean isMajroAndMinorVersionNumeric(String version) {
        return version.matches("^[0-9]+\\.[0-9]+\\..*$");
    }

    private static String getMajorAndMinorOf(String version) {
        int indexOfSecondDot = version.indexOf(".", version.indexOf(".") + 1);
        return version.substring(0, indexOfSecondDot + 1);
    }
}

