/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import java.util.Iterator;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinateImpl;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusionImpl;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyImpl;
import org.junit.Assert;
import org.junit.Test;

public class MavenDependencyImplTestCase {
    @Test
    public void equalsByValueNoExclusions() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[0]);
        MavenDependencyImpl dependency2 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[0]);
        Assert.assertEquals((Object)dependency1, (Object)dependency2);
    }

    @Test
    public void equalsByValueExclusions() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyExclusionImpl exclusion1 = new MavenDependencyExclusionImpl("groupId1", "artifactId1");
        MavenDependencyExclusionImpl exclusion2 = new MavenDependencyExclusionImpl("groupId2", "artifactId2");
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion1, exclusion2});
        MavenDependencyImpl dependency2 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion1, exclusion2});
        Assert.assertEquals((Object)dependency1, (Object)dependency2);
    }

    @Test
    public void equalsByValueExclusionsUnordered() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyExclusionImpl exclusion11 = new MavenDependencyExclusionImpl("groupId1", "artifactId1");
        MavenDependencyExclusionImpl exclusion12 = new MavenDependencyExclusionImpl("groupId2", "artifactId2");
        MavenDependencyExclusionImpl exclusion21 = new MavenDependencyExclusionImpl("groupId1", "artifactId1");
        MavenDependencyExclusionImpl exclusion22 = new MavenDependencyExclusionImpl("groupId2", "artifactId2");
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion11, exclusion12});
        MavenDependencyImpl dependency2 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion22, exclusion21});
        Assert.assertEquals((Object)dependency1, (Object)dependency2);
    }

    @Test
    public void notEqualsByValueExclusions() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyExclusionImpl exclusion1 = new MavenDependencyExclusionImpl("groupId1", "artifactId1");
        MavenDependencyExclusionImpl exclusion2 = new MavenDependencyExclusionImpl("wrong", "artifactId2");
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion1});
        MavenDependencyImpl dependency2 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion2});
        Assert.assertTrue((boolean)dependency1.equals(dependency2));
    }

    @Test
    public void notEqualsByValueExclusionsMismatchThis() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyExclusionImpl exclusion = new MavenDependencyExclusionImpl("groupId1", "artifactId1");
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[0]);
        MavenDependencyImpl dependency2 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion});
        Assert.assertTrue((boolean)dependency1.equals(dependency2));
    }

    @Test
    public void notEqualsByValueExclusionsMismatchThat() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyExclusionImpl exclusion = new MavenDependencyExclusionImpl("groupId1", "artifactId1");
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion});
        MavenDependencyImpl dependency2 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[0]);
        Assert.assertTrue((boolean)dependency1.equals(dependency2));
    }

    @Test
    public void notEqualsByValueCoordinate() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[0]);
        MavenDependencyImpl dependency2 = new MavenDependencyImpl((MavenCoordinate)new MavenCoordinateImpl("g", "a", "v", null, "c"), scope, true, new MavenDependencyExclusion[0]);
        Assert.assertFalse((boolean)dependency1.equals(dependency2));
    }

    @Test
    public void notEqualsByValueScope() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[0]);
        MavenDependencyImpl dependency2 = new MavenDependencyImpl(coordinate, ScopeType.IMPORT, true, new MavenDependencyExclusion[0]);
        Assert.assertTrue((boolean)dependency1.equals(dependency2));
    }

    @Test
    public void notEqualsByValueOptional() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[0]);
        MavenDependencyImpl dependency2 = new MavenDependencyImpl(coordinate, scope, false, new MavenDependencyExclusion[0]);
        Assert.assertTrue((boolean)dependency1.equals(dependency2));
    }

    @Test
    public void equalHashCodes() {
        MavenCoordinate coordinate = this.createCoordinate();
        ScopeType scope = ScopeType.RUNTIME;
        boolean optional = true;
        MavenDependencyExclusionImpl exclusion1 = new MavenDependencyExclusionImpl("groupId1", "artifactId1");
        MavenDependencyExclusionImpl exclusion2 = new MavenDependencyExclusionImpl("groupId2", "artifactId2");
        MavenDependencyImpl dependency1 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion1, exclusion2});
        MavenDependencyImpl dependency2 = new MavenDependencyImpl(coordinate, scope, true, new MavenDependencyExclusion[]{exclusion1, exclusion2});
        Assert.assertTrue((dependency1.hashCode() == dependency2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void properties() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        ScopeType scope = ScopeType.IMPORT;
        boolean optional = true;
        MavenCoordinateImpl coordinate = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        MavenDependencyExclusionImpl exclusion1 = new MavenDependencyExclusionImpl("groupId1", "artifactId1");
        MavenDependencyExclusionImpl exclusion2 = new MavenDependencyExclusionImpl("groupId2", "artifactId2");
        MavenDependencyImpl dependency = new MavenDependencyImpl((MavenCoordinate)coordinate, scope, true, new MavenDependencyExclusion[]{exclusion1, exclusion2});
        Assert.assertEquals((Object)"groupId", (Object)dependency.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)dependency.getArtifactId());
        Assert.assertEquals((Object)"version", (Object)dependency.getVersion());
        Assert.assertEquals((Object)packaging, (Object)dependency.getPackaging());
        Assert.assertEquals((Object)"classifier", (Object)dependency.getClassifier());
        Set exclusions = dependency.getExclusions();
        Assert.assertEquals((long)2L, (long)exclusions.size());
        Iterator it = exclusions.iterator();
        MavenDependencyExclusion roundtrip1 = (MavenDependencyExclusion)it.next();
        Assert.assertTrue((boolean)exclusions.contains(roundtrip1));
        MavenDependencyExclusion roundtrip2 = (MavenDependencyExclusion)it.next();
        Assert.assertTrue((boolean)exclusions.contains(roundtrip2));
        Assert.assertEquals((Object)("groupId:artifactId:" + packaging.toString() + ":" + "classifier" + ":" + "version"), (Object)dependency.toCanonicalForm());
    }

    @Test
    public void prohibitAddingExclusions() {
        MavenCoordinate coordinate = this.createCoordinate();
        MavenDependencyImpl dependency = new MavenDependencyImpl(coordinate, null, true, new MavenDependencyExclusion[0]);
        MavenDependencyExclusionImpl exclusion = new MavenDependencyExclusionImpl("g", "a");
        boolean gotExpectedException = false;
        try {
            dependency.getExclusions().add(exclusion);
        }
        catch (UnsupportedOperationException uoe) {
            gotExpectedException = true;
        }
        Assert.assertTrue((boolean)gotExpectedException);
    }

    @Test
    public void defaultScope() {
        MavenCoordinate coordinate = this.createCoordinate();
        boolean optional = true;
        MavenDependencyImpl dependency = new MavenDependencyImpl(coordinate, null, true, new MavenDependencyExclusion[0]);
        Assert.assertEquals((Object)ScopeType.COMPILE, (Object)dependency.getScope());
    }

    private MavenCoordinate createCoordinate() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        PackagingType packaging = PackagingType.POM;
        String classifier = "classifier";
        MavenCoordinateImpl coordinate = new MavenCoordinateImpl("groupId", "artifactId", "version", packaging, "classifier");
        return coordinate;
    }
}

