/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusionImpl;
import org.junit.Assert;
import org.junit.Test;

public class MavenDependencyExclusionImplTestCase {
    @Test
    public void equalsByValue() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        MavenDependencyExclusionImpl exclusion1 = new MavenDependencyExclusionImpl("groupId", "artifactId");
        MavenDependencyExclusionImpl exclusion2 = new MavenDependencyExclusionImpl("groupId", "artifactId");
        Assert.assertEquals((Object)exclusion1, (Object)exclusion2);
    }

    @Test
    public void notEqualsByGroupIdValue() {
        MavenDependencyExclusionImpl exclusion1 = new MavenDependencyExclusionImpl("groupId", "artifactId");
        MavenDependencyExclusionImpl exclusion2 = new MavenDependencyExclusionImpl("groupId2", "artifactId");
        Assert.assertFalse((boolean)exclusion1.equals(exclusion2));
    }

    @Test
    public void notEqualsByArtifactIdValue() {
        MavenDependencyExclusionImpl exclusion1 = new MavenDependencyExclusionImpl("groupId", "artifactId");
        MavenDependencyExclusionImpl exclusion2 = new MavenDependencyExclusionImpl("groupId", "artifactId2");
        Assert.assertFalse((boolean)exclusion1.equals(exclusion2));
    }

    @Test
    public void equalHashCodes() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        MavenDependencyExclusionImpl exclusion1 = new MavenDependencyExclusionImpl("groupId", "artifactId");
        MavenDependencyExclusionImpl exclusion2 = new MavenDependencyExclusionImpl("groupId", "artifactId");
        Assert.assertTrue((exclusion1.hashCode() == exclusion2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void properties() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        MavenDependencyExclusionImpl exclusion = new MavenDependencyExclusionImpl("groupId", "artifactId");
        Assert.assertEquals((Object)"groupId", (Object)exclusion.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)exclusion.getArtifactId());
        Assert.assertEquals((Object)"groupId:artifactId", (Object)exclusion.toCanonicalForm());
    }
}

