/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.formatprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.shrinkwrap.resolver.api.formatprocessor.FormatProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InputStreamFormatProcessor implements FormatProcessor<InputStream>
{
    INSTANCE;


    @Override
    public InputStream process(File input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("input file must be specified");
        }
        if (!input.exists()) {
            throw new IllegalArgumentException("input file does not exist: " + input.getAbsolutePath());
        }
        if (input.isDirectory()) {
            throw new IllegalArgumentException("input file is a directory: " + input.getAbsolutePath());
        }
        try {
            return new FileInputStream(input);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalArgumentException(fnfe);
        }
    }
}

