/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.jboss.shrinkwrap.resolver.api.ResolverSystem;
import org.jboss.shrinkwrap.resolver.api.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResolverSystemFactory {
    private static final String MAPPING_LOCATION = "META-INF/services/";
    private static final String KEY_IMPL_CLASS_NAME = "implClass";

    private ResolverSystemFactory() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    static <RESOLVERSYSTEMTYPE extends ResolverSystem> RESOLVERSYSTEMTYPE createFromUserView(Class<RESOLVERSYSTEMTYPE> userViewClass) throws IllegalArgumentException {
        return ResolverSystemFactory.createFromUserView(userViewClass, SecurityActions.getThreadContextClassLoader());
    }

    static <RESOLVERSYSTEMTYPE extends ResolverSystem> RESOLVERSYSTEMTYPE createFromUserView(Class<RESOLVERSYSTEMTYPE> userViewClass, ClassLoader cl) throws IllegalArgumentException {
        ResolverSystem dependencyType;
        Constructor<RESOLVERSYSTEMTYPE> ctor;
        Class<RESOLVERSYSTEMTYPE> implClass = ResolverSystemFactory.getImplClassForUserView(userViewClass, cl);
        try {
            ctor = SecurityActions.getConstructor(implClass, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(implClass + " must contain a public no args contructor");
        }
        try {
            dependencyType = (ResolverSystem)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new descriptor instance", e);
        }
        return (RESOLVERSYSTEMTYPE)((ResolverSystem)userViewClass.cast(dependencyType));
    }

    private static <RESOLVERSYSTEMTYPE extends ResolverSystem> Class<RESOLVERSYSTEMTYPE> getImplClassForUserView(Class<RESOLVERSYSTEMTYPE> userViewClass, ClassLoader cl) throws IllegalArgumentException {
        Class implClass;
        if (userViewClass == null) {
            throw new IllegalArgumentException("User view class must be specified");
        }
        if (cl == null) {
            throw new IllegalArgumentException("ClassLoader must be specified");
        }
        String className = userViewClass.getName();
        String resourceName = MAPPING_LOCATION + className;
        InputStream resourceStream = cl.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new IllegalArgumentException("No resource " + resourceName + " was found configured for user view class " + userViewClass.getName());
        }
        Properties props = new Properties();
        try {
            props.load(resourceStream);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O Problem in reading the properties for " + userViewClass.getName(), e);
        }
        String implClassName = props.getProperty(KEY_IMPL_CLASS_NAME);
        if (implClassName == null || implClassName.length() == 0) {
            throw new IllegalStateException("Resource " + resourceName + " for " + userViewClass + " does not contain key " + KEY_IMPL_CLASS_NAME);
        }
        Class<?> resolverSystemTypeClassClass = userViewClass.getClass();
        try {
            implClass = (Class)resolverSystemTypeClassClass.cast(Class.forName(implClassName, false, cl));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load specified implementation class from " + cl + ": " + implClassName, e);
        }
        return implClass;
    }
}

